(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1501463,      26072]
NotebookOptionsPosition[   1487613,      25831]
NotebookOutlinePosition[   1488739,      25866]
CellTagsIndexPosition[   1488617,      25860]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["2| Rectangular slab", "Section",
 CellFrame->{{0.5, 3}, {3, 0.5}},
 CellChangeTimes->{{3.961298320960185*^9, 3.9612983463801403`*^9}},
 FontColor->GrayLevel[0],
 CellTags->
  "rectangularSlab",ExpressionUUID->"98ae8edd-9959-4373-a3bb-9cb878b90fc0"],

Cell[TextData[{
 "In this chapter a simple rectangular slab is analysed, with detailed \
explanations of each stage. Post processing is carried out  to obtain the \
bending moments, which are plotted. Comparison is also made with the values \
obtained from ",
 StyleBox["Timoshenko 1959", "Reference",
  FontWeight->"SemiBold"],
 StyleBox[".",
  FontWeight->"Bold"]
}], "Text",
 CellChangeTimes->{{3.9612987046622133`*^9, 3.961298724770185*^9}, {
  3.961298774797086*^9, 3.96129889960784*^9}, {3.961299970233672*^9, 
  3.9612999810918083`*^9}, {3.964315268329748*^9, 3.964315270926216*^9}, {
  3.9647754211029377`*^9, 3.9647754252606792`*^9}},
 FontWeight->"Regular",ExpressionUUID->"5d504da3-a781-453f-b7d4-f49085c6ff13"],

Cell[CellGroupData[{

Cell["Units, Quantities and subscripts", "Subsection",
 CellChangeTimes->{{3.9626376130537767`*^9, 3.962637622711289*^9}, {
  3.9643156673451233`*^9, 3.964315677613175*^9}, {3.967649727244849*^9, 
  3.967649730615047*^9}},ExpressionUUID->"11c2dc1a-b8f6-4d1f-9827-\
1a1c31d3d836"],

Cell["\<\
Finite element programs should be run in SI or equivalent consistent units \
without specification of the unit. SI units are used throughout this book. 
When units are needed eg. for post processing, the following definitions may \
be helpful. Once run, units may be entered just by typing the abbreviation \
eg. m for metres. Other units can be added if required. The congruent symbol \
is used to define results in the units required. The Symbolize expression \
means any expression with a subscript is treated as a symbol. Which is \
convenient for engineering calculations.\
\>", "Text",
 CellChangeTimes->{{3.964315706553684*^9, 3.964316206457526*^9}, {
  3.964316310922208*^9, 3.964316328665501*^9}, {3.9647762306562653`*^9, 
  3.964776256743475*^9}},
 FontWeight->"Regular",ExpressionUUID->"c95ca108-0a3b-48ac-8d0d-a828c40d3f99"],

Cell[TextData[StyleBox["Note: The definition of units to be used and \
subscripts are contained in the following initialisation cells for \
convenience.",
 FontWeight->"Regular"]], "Text",
 CellChangeTimes->{{3.962637167298503*^9, 3.962637168481374*^9}, {
   3.962637231509852*^9, 3.962637280216382*^9}, 3.96431557626436*^9, {
   3.967649812716938*^9, 
   3.967649833558962*^9}},ExpressionUUID->"1c41c77f-50d3-4cb5-820a-\
a6cd078d7759"],

Cell[BoxData[
 RowBox[{
  RowBox[{"units", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<GigaPascals\>\""}], "]"}]}], ";", 
     RowBox[{"MPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<MegaPascals\>\""}], "]"}]}], ";", 
     RowBox[{"kPa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kiloPascals\>\""}], "]"}]}], ";", 
     RowBox[{"Pa", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Pascals\>\""}], "]"}]}], ";", 
     RowBox[{"m", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<meter\>\""}], "]"}]}], ";", 
     RowBox[{"mm", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<millimeter\>\""}], "]"}]}], ";", 
     RowBox[{"MN", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Meganewtons\>\""}], "]"}]}], ";", 
     RowBox[{"kN", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kilonewton\>\""}], "]"}]}], ";", 
     RowBox[{"MJ", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<Megajoules\>\""}], "]"}]}], ";", 
     RowBox[{"kJ", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kiloJoules\>\""}], "]"}]}], ";", 
     RowBox[{"kg", "=", 
      RowBox[{"Quantity", "[", 
       RowBox[{"1", ",", "\"\<kilogram\>\""}], "]"}]}], ";", 
     RowBox[{"Unprotect", "[", "Congruent", "]"}], ";", 
     RowBox[{"Congruent", "/:", 
      RowBox[{"x_", "\[Congruent]", "y_"}], ":=", 
      RowBox[{"UnitConvert", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], ";", 
     RowBox[{"Protect", "[", "Congruent", "]"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.9626206118946247`*^9, 3.962620618524969*^9}, 
   3.962636540979307*^9, {3.962636818208417*^9, 3.962636849882018*^9}, {
   3.9626369315357656`*^9, 3.962636943711253*^9}, 3.962637010879611*^9, 
   3.962637086837044*^9, {3.964315295682755*^9, 3.964315304977186*^9}, {
   3.964315487453661*^9, 3.9643155344766827`*^9}, 3.9647761255973787`*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"3c5be113-444f-4726-8ffc-c14a826f59b8"],

Cell["\<\
If subscripts are required then use Symbolize from the Notation palette. The \
Symbolize expression, shown, means any expression with a subscript is treated \
as a symbol. Which is convenient for engineering calculations.\
\>", "Text",
 CellChangeTimes->{{3.964776129849612*^9, 3.9647761980911617`*^9}, {
  3.97056734462551*^9, 
  3.970567354292325*^9}},ExpressionUUID->"852e12ac-f5e5-4c75-8086-\
6faf851f7870"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbolize", "[", 
   TemplateBox[{
     SubscriptBox["_", "_"]},
    "NotationTemplateTag"], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.964315444296866*^9, 3.964315448570669*^9}, 
   3.964315559721434*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"e82195c3-8f89-4ad8-a6e0-e52bb6b5781a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rectangular Slab", "Subsection",
 CellChangeTimes->{{3.964776072185629*^9, 
  3.964776083874544*^9}},ExpressionUUID->"9b286a35-9f92-4053-a9dc-\
60b8badc6c12"],

Cell["\<\
This is a similar example to that in the previous chapter but here, each step \
is examined in detail. Post processing is also undertaken to derive bending \
moments.\
\>", "Text",
 CellChangeTimes->{{3.96477700934109*^9, 3.96477705009783*^9}, {
  3.964777781512431*^9, 
  3.964777800950876*^9}},ExpressionUUID->"9223778c-70d4-4e31-ba5e-\
a0715b49780d"],

Cell[TextData[StyleBox["To start the finite element module is called.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.9626373102003393`*^9, 3.962637327662125*^9}, {
  3.96477706128983*^9, 3.964777064542404*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"e686d542-807f-4c6f-9705-6e8ee863a8e0"],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NDSolve`FEM`\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"a77b34e5-193c-4faa-9192-f6018f42d1af"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Geometry", "Subsection",
 CellChangeTimes->{{3.961300595096981*^9, 
  3.961300597476359*^9}},ExpressionUUID->"f10b8f45-4a58-4f78-add8-\
e574754d424d"],

Cell["\<\
Then the geometry of the region to be analysed is computed. In this case a \
simple rectangular slab.\
\>", "Text",
 CellChangeTimes->{{3.961298985938417*^9, 3.961299037101832*^9}},
 FontWeight->"Regular",ExpressionUUID->"e54fc32e-4edc-4eaf-800e-3b4a7f1ef7c3"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Note: All dimensions should be to SI units i.e. \
metres and Newtons etc. and can then be entered without units. ", "Text"]], \
"Item",
 CellChangeTimes->{{3.9543003468371887`*^9, 3.954300467183632*^9}, 
   3.954300499960986*^9, {3.95430385210491*^9, 3.954303869891575*^9}, {
   3.96129905927344*^9, 3.9612991035698137`*^9}, {3.961299142960003*^9, 
   3.961299159015729*^9}},
 FontSize->18,
 FontWeight->"Regular",ExpressionUUID->"dbd53a23-1cbe-4ff0-90d6-1b011999399a"],

Cell[TextData[{
 StyleBox["Either put dimensions in number of metres else use ", "Text"],
 StyleBox["QuantityMagnitude", "inTextCode",
  FontWeight->"SemiBold"],
 StyleBox[" to abstract the number from the dimension i.e. ", "Text"],
 StyleBox["QuantityMagnitude[{b,a,h},\[CloseCurlyDoubleQuote]SIBase\
\[CloseCurlyDoubleQuote]]", "inTextCode",
  FontWeight->"SemiBold"],
 StyleBox[" . Where b,a and h  can then be entered in any unit  and converted \
e.g.", "Text"]
}], "Item",
 CellChangeTimes->{{3.9543003468371887`*^9, 3.954300467183632*^9}, 
   3.954300499960986*^9, {3.95430385210491*^9, 3.954303869891575*^9}, {
   3.96129905927344*^9, 3.9612991035698137`*^9}, {3.961299142960003*^9, 
   3.961299155095171*^9}, {3.961299225024335*^9, 3.961299226930387*^9}, {
   3.961299410016465*^9, 3.9612994477119303`*^9}, 3.961299493210411*^9, 
   3.9612995284735126`*^9, 3.967649934534083*^9},
 FontSize->18,
 FontWeight->"Regular",ExpressionUUID->"6dbebf65-e5a6-41df-ab9d-fc4fd02b1a11"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantityMagnitude", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"20.", 
      TemplateBox[{
        InterpretationBox["\[InvisibleSpace]", 1], "\"ft\"", "feet", 
        "\"Feet\""},
       "Quantity"]}], ",", 
     RowBox[{"16.", 
      TemplateBox[{
        InterpretationBox["\[InvisibleSpace]", 1], "\"ft\"", "feet", 
        "\"Feet\""},
       "Quantity"]}], ",", 
     RowBox[{"8.", 
      TemplateBox[{
        InterpretationBox["\[InvisibleSpace]", 1], "\"in\"", "inches", 
        "\"Inches\""},
       "Quantity"]}]}], "}"}], ",", "\"\<SIBase\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.961299249824801*^9, 3.9612992503894777`*^9}, {
  3.9612993237004023`*^9, 3.961299386184811*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"888b0f60-c5e0-4c8d-8b19-2c5e938d0d31"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.096`", ",", "4.8768`", ",", "0.2032`"}], "}"}]], "Output",
 CellChangeTimes->{{3.9612993776744747`*^9, 3.961299387853715*^9}, 
   3.9613016652236137`*^9, 3.9613161407700777`*^9, 3.965122829114024*^9, 
   3.973130264489972*^9},
 CellLabel->"Out[6]=",
 CellID->176194051,ExpressionUUID->"19891007-91c6-4def-819c-63a824191044"]
}, Open  ]],

Cell[TextData[StyleBox["However, in this case we will use the following SI \
dimensions.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.961299544195642*^9, 3.961299564682582*^9}, 
   3.961300024818914*^9},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"9d5b0a06-5aba-4143-bb2f-c4a5ca9b3a3e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"slab", "=", 
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "4", ",", "0.2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"49d5fcb1-9cea-443b-ab6a-5dab9b5b2ec8"],

Cell[TextData[StyleBox["This may then, optionally, be plotted out, complete \
with axes to check.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.961299597323773*^9, 3.9612996449505177`*^9}, 
   3.961299763202402*^9, 3.967650203436494*^9},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"57ca81dd-aac2-43b3-91d7-809502ddb227"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"slab", ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9540394007167597`*^9, 3.9540394090562572`*^9}, 
   3.954039487061716*^9, {3.954039534833659*^9, 3.9540395361221437`*^9}, {
   3.954039587409506*^9, 3.954039591878086*^9}, 3.9540402729939337`*^9, {
   3.9612996522425613`*^9, 3.9612997479726*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"88ee2d3d-c3db-4bd9-85c2-a7b60e649435"],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}, {6, 4, 0.2}],
  Axes->True,
  AxesLabel->{
    FormBox["\"X\"", TraditionalForm], 
    FormBox["\"Y\"", TraditionalForm], 
    FormBox["\"Z\"", TraditionalForm]}]], "Output",
 CellChangeTimes->{{3.954039410927305*^9, 3.9540394279729567`*^9}, 
   3.954039488962834*^9, {3.954039537315072*^9, 3.954039592590472*^9}, 
   3.9540398877304497`*^9, 3.9540402129398117`*^9, 3.95404033233687*^9, 
   3.954064597641769*^9, 3.954065693362409*^9, 3.954066003433292*^9, 
   3.954066128610973*^9, 3.954066889824841*^9, 3.954067030206977*^9, 
   3.954067285106345*^9, 3.954067462005333*^9, 3.954067578628643*^9, 
   3.954067745262504*^9, 3.954067782532447*^9, 3.9540828371076593`*^9, 
   3.954082916086301*^9, 3.954083074588632*^9, 3.954084030136313*^9, 
   3.954085773598627*^9, 3.95408589522129*^9, 3.954086820753887*^9, 
   3.954087023744698*^9, 3.954122259887433*^9, 3.9541226475537367`*^9, 
   3.954122748614168*^9, 3.954124137522519*^9, 3.95415204101796*^9, 
   3.954298502655636*^9, {3.954299722644826*^9, 3.954299749681425*^9}, 
   3.954299999671769*^9, 3.954300088698522*^9, 3.954300193094192*^9, 
   3.954300681797948*^9, 3.954307185494578*^9, 3.954315758956156*^9, {
   3.961299682967704*^9, 3.961299700275391*^9}, 3.961299749189644*^9, 
   3.961301665242646*^9, 3.9613161407762117`*^9, 3.9651228291303473`*^9, 
   3.973130264506667*^9},
 CellLabel->"Out[8]=",
 CellID->2060949591,ExpressionUUID->"64296492-0a07-44dc-bb8b-e44ea5392679"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Meshing", "Subsection",
 CellChangeTimes->{{3.9613006070096292`*^9, 
  3.961300609659659*^9}},ExpressionUUID->"c004e081-7cd1-4030-93b3-\
7e3d5047c495"],

Cell[TextData[{
 StyleBox["This is then meshed, using the function ToElementMesh[], and \
plotted out as a wireframe so the mesh can inspected. By outputting the mesh \
the limits and number and type of elements is also show",
  FontSize->18],
 "n. "
}], "Text",
 CellChangeTimes->{{3.961299784444137*^9, 3.961299915409018*^9}, {
  3.9643164534833317`*^9, 3.9643165041669807`*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"4bcad83f-637f-4ccd-98f1-0b9b4a2b636b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mesh", "=", 
  RowBox[{"ToElementMesh", "[", "slab", "]"}]}], "\n", 
 RowBox[{"mesh", "[", "\"\<Wireframe\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.954306352999742*^9, 3.9543063663176403`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"095b927b-c16d-4e1c-a121-984f20975d7d"],

Cell[BoxData[
 TagBox[
  RowBox[{"ElementMesh", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"HexahedronElement", "[", 
      RowBox[{
       StyleBox["\<\"<\"\>",
        ShowStringCharacters->False], "\[InvisibleSpace]", "10368", "\[InvisibleSpace]", 
       StyleBox["\<\">\"\>",
        ShowStringCharacters->False]}], "]"}], "}"}]}], "]"}],
  False,
  Editable->False,
  SelectWithContents->True]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQB+Ky9488dpe+dQzi148H0e7z1qWC6C37GbtAtMnLFZtA
dIf91IMgOnv1/lnHgXRb1jblE0BaRb7SC0Qvc5eLAtGhB1x3gmim9xdOgeiT
89a+AtHbWk4xnATS9kVx/CD6xSQjFRB9zPG2BoheOH9t0wUgPeFNTw+IDlaJ
XQCi/+qfF78Icl/j3o8guiXpI8MlIG00eXEJiP52j6kPRP8613boMZBOefv7
E4j+9GPufxC9wtJ67RMgrXNSy/cTkF6l/uCCZdlbx4mPnB9aAekNva4rbIF0
n5cVnx2Qtpd9aesEpM8rGYVMbX7reCp6ceocIK0itl7xftdbx01M0syqs946
AgBJHKw8
  "],
 CellLabel->"Out[9]=",
 CellID->1616033474,ExpressionUUID->"e25bdf52-4f53-47e6-9834-69d9d30d67fc"],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[RGBColor[
   0.00010000076130382223`, 0.00010000076130382223`, 
    0.00010000076130382223`]], FaceForm[None, None], 
   GraphicsComplex3DBox[CompressedData["
1:eJyMvU1qptm6bZep+P+P2wS3xNEGw9kNMLjs9thN2C4YF9yAr6CCS46KKrck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    "], {Polygon3DBox[CompressedData["
1:eJwskyEwvA/Ydn+LxeLB4sFi8WCxWCzWfzZsEARB8M0IguCbEQTfN4IgmHkF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      "]], Polygon3DBox[CompressedData["
1:eJwt1nt4FXIcx/HvdnZ2v53d79vZdna/X4UQQlg3QuhKCJUQQhLCuiCEdUEI
IYQQQrJWkiRrS5IkSZIkSZLf5/l8/vg+z/u8ns85e/bfzz9y3MCxwWbW7S7E
XZA7fF7lrl3tcdch82i3WtYun+a+2BrEhk8PonVoOyOI1irv6364JZgN7xdM
Q2PbP5jWIk9wf9jnYcMTPTQ0tkkemk++yV2nGt4lQ2PbLeuUz3H/VFsIGz43
hNal7bwQWpt8qNdsiJcNH+alobEd7qUNkeeHmvlD2fCCUBoa28JQml/+k7ud
avguGRrbn2U75S+FmS0KY8NfDqPt0vaVMNoi+dhwszHhbPi4cBoa2+vCaWPk
dRFmtRFseH0EDY1tQwStVv6Xu4Nq+CEZGtu/ZQfl70WaLYtkw9+PpB3S9oNI
2jL5HVFmk6LY8MlRNDS2d0bRJslPjTbrFc2GnxZNQ2N7ejStlzw0xswbw4aH
xdDQ2IbH0Lzyz9ytUcPXytDYfi5bI38g1mxmLBv+YCxtrbYPxdJmygfGmQ2I
Y8PPi6OhsT0/jjZAnhJvlhzPhqfG09DYpsXTkuXfuNushm+RobH9VrZZ/qTP
bL6PDX/KR9ui7dM+2nz5yASzEQls+GUJNDS2lyfQRsiLEs0CiWx4cSINjW1J
Ii0g/8XdbjV8jwyN7a+y3fJXk8wWJ7HhryXR9mj7ehJtsfz6ZLPxyWz4Dck0
NLY3JtPGy5tSzBpT2PDmFBoa2+NSaI3yf9wdVsOPyNDY/is7LP8w1Wx5Khv+
USrtiLYfp9KWy+9KM5uSxobfnUZDY3tPGm2K/Ix0s97pbPiZ6TQ0tmel03rL
IzPMIjLY8KgMGhrb6AxahPwLd+vU8PUyNLZfytbJH840m5XJhj+SSVuv7aOZ
tFnyC7LMBmWx4Rdm0dDYXpRFGyTPyDZLz2bDM7NpaGyzsmnp8u/cbVXDt8nQ
2H4v2yp/JsdsQQ4b/mwObZu2z+XQFsivyDUblcuGX5lLQ2N7VS5tlLwsz6w0
jw0vz6Ohsa3Io5XKf3O3Vw3fJ0Nj+7tsr/wNv9kSPxv+pp+2T9u3/LQl8pvy
zSbks+E359PQ2N6ST5sgP77ArEcBG35CAQ2N7YkFtB7y/9wdVcOPydDYWiHt
qPwT93lFIRu+spB2TNtPC2kr5PcGzKYG2PD7ArSV2t4foE2Vn11k1qeIDT+n
iIbG9twiWh95bLFZTDEbHldMQ2MbX0yLkX/lboMavlGGxvZr2Qb5YyVms0vY
8MdLaBu1faKENlt+canZ4FI2/JJSGhrbS0tpg+U5ZWbZZWx4bhkNjW1eGS1b
/oO77Wr4Dhka2x9l2+XPl5stLGfDXyin7dD2xXLaQvnVFWajK9jwaypoaGyv
raCNlldVmlVWsuHVlTQ0tjWVtEr5H+72q+EHZGhs/5Ttl79dZba0ig1/p4p2
QNt3q2hL5bdWm02sZsNvq6ahsb29mjZRflKNWc8aNvzkGhoa21NqaD3lwbXu
bV/LhntqaWhsQ2ppQfJV7trV8A4ZGtvVsnb5tDr3tq9jw6fX0Tq0nVFHa5X3
rXdv+3o2vF89DY1t/3paizyhwb3tG9jwxAYaGtukBppPvsldpxreJUNj2y3r
lM9pdG/7RjZ8biOtS9t5jbQ2+dAm97ZvYsOHNdHQ2A5vog2R5ze7t30zG17Q
TENjW9hM+x8vZAiD
      "]], Polygon3DBox[CompressedData["
1:eJwBUQKu/SFib1JiAgAAAJAAAAAEAAAABQYCAQYHAwIHCAQDCQoGBQoLBwYL
DAgHDQ4KCQ4PCwoPEAwLERIODRITDw4TFBAPFRYSERYXExIXGBQTGRoWFRob
FxYbHBgXHR4aGR4fGxofIBwbISIeHSIjHx4jJCAfJSYiISYnIyInKCQjKSom
JSorJyYrLCgnLS4qKS4vKyovMCwrMTIuLTIzLy4zNDAvNTYyMTY3MzI3ODQz
OTo2NTo7NzY7PDg3PT46OT4/Ozo/QDw7QUI+PUJDPz5DREA/RUZCQUZHQ0JH
SERDSUpGRUpLR0ZLTEhHTU5KSU5PS0pPUExLUVJOTVJTT05TVFBPVVZSUVZX
U1JXWFRTWVpWVVpbV1ZbXFhXXV5aWV5fW1pfYFxbYWJeXWJjX15jZGBfZWZi
YWZnY2JnaGRjaWpmZWprZ2ZrbGhnbW5qaW5va2pvcGxrcXJubXJzb25zdHBv
dXZycXZ3c3J3eHRzeXp2dXp7d3Z7fHh3fX56eX5/e3p/gHx7gYJ+fYKDf36D
hIB/hYaCgYaHg4KHiISDiYqGhYqLh4aLjIiHjY6KiY6Pi4qPkIyLkZKOjZKT
j46TlJCPlZaSkZaXk5KXmJSTmZqWlZqbl5abnJiXnZ6amZ6fm5qfoJyboaKe
naKjn56jpKCfpaaioaano6KnqKSjqaqmpaqrp6arrKinra6qqa6vq6qvsKyr
sbKurbKzr66ztLCvtbaysba3s7K3uLSzubq2tbq7t7a7vLi3vb66ub6/u7q/
wLy7wcK+vcLDv77DxMC/+rTf3Q==
      "]], Polygon3DBox[CompressedData["
1:eJws3S9wmnm8tnGS0pa2tKEJbUlLG5KShKS0pS3pRiAQCASCOYNAIJh3EAjm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      "]], Polygon3DBox[CompressedData["
1:eJwtlmWUFGQYRt/tnNnundmd7Y7Z3VnBbhEsTAQLu8DuVgQ7Eezu7g7CTkLF
lrC7O757nvfHd8499zz3x/fvTUydPnFaupktCy8zvBlpZqeHNz/wPBPPDG+B
ycGzwltocuNCvGm6drTw+HTtcPCEdDW4SIZZNEM7WrgoQzscXJyhBrco8GJv
Is5LvIk6L/UGNzt84pJM7WjhOZna4eC5mWpwk7LMdszSjhaenKUdDp6SpQYX
yzaLZ2tHCzdka4eDG7PV4JYHXuFNzHmlN3HnVd7gbswxuylHO1r45hztcPAt
OWpw++aa7ZerHS28f652OPiAXDW43jyzvjztaOH+PO1w8ECeGtwPgX/0ptf5
J2/6nH/2BvdgvtlD+drRwg/na4eDH8lXgzu6wOyYAu1o4WMLtMPBxxWowa1Z
aLZWoXa08NqF2uHgdQrV4NIiZukR7WjhjIh2ODgzogb3bODnvElzft6bdOcX
vMGdETU7M6odLXxWVDscfHZUDW6zIrPNi7Sjhbco0g4Hb1mkBldSbFZarB0t
XFasHQ4uL1aDezPwW96UOL/tTanzMm9wl5aYXVaiHS18eYl2OPiKEjW4nUrN
di7VjhbepVQ7HLxrqRpcosysqUw7Wri5TDsc3FKmBvdJ4E+9STh/5k2T8+fe
4G4tN7utXDta+PZy7XDwHeVqcAdWmE2r0I4Wnl6hHQ4+qEINbrDSLFmpHS08
VKkdDh6uVIP7JfCv3gw6/+ZN0vl3b3CPVpk9VqUdLfx4lXY4+IkqNbjjq81O
qNaOFj6xWjscfFK1Gty6NWbr1WhHC69fox0O3qBGDS6r1iy7VjtaOKdWOxyc
W6sG92Lgl7zJcn7Zm2znV7zBnVNndm6ddrTweXXa4eDz69Tgtqo3m1ivHS28
db12OHibejW4iphZZUw7Wrgqph0Oro6pwb0T+F1vKpzf86bS+X1vcFfGza6K
a0cLXx3XDgdfE1eD263BbGqDdrTw7g3a4eA9GtTgWhvN2hq1o4XbG7XDwR2N
anBfBP7Sm1bnr7xpc/7aG9ydCbO7EtrRwncntMPB9yTU4A5uMjukSTta+NAm
7XDwYU1qcCPNZqlm7Wjh0WbtcPBqzWpwfwT+05sR57+8STn/7Q3uyRazp1q0
o4WfbtEOBz/TogZ3cqvZKa3a0cKntmqHg09rVYPbsM1sozbtaOGN27TDwZu0
qcHltZvlt2tHCxe0a4eDC9vV4F4N/Jo3ec6ve5Pv/IY3uAs6zC7s0I4WvqhD
Oxx8cYca3LadZtt1akcLb9+pHQ7eoVMNrqbLrLZLO1q4rks7HFzfpQb3QeAP
valx/sibWuePvcFd2212Xbd2tPD13drh4Bu61eD27DHbq0c7WnjvHu1w8D49
anCdvWZdvdrRwt292uHgnl41uG8Cf+tNp/N33nQ5f+8N7t4+s/v6tKOF7+/T
Dgc/0KcGd3i/2RH92tHCR/Zrh4OP6leDGzNgNnZAO1p49QHtcPAaA2pw/wT+
15sxzv95M9bZBtXg5gWeP6gdLbxgUDscvHBQDW5GMtztSe1o4ZlJ7XDwrKQa
3LihcLcPaUcLjx/SDgdPGFKDiwyHu31YO1q4aFg7HFw8rAa3KPBibyLOS7yJ
Oi/1Bjd7JNztI9rRwnNGtMPBc0fU4Calwt2e0o4WnpzSDgdPSanBxUbD3T6q
HS3cMKodDm4cVYNbHniFNzHnld7EnVd5g/sfhmsLCw==
      "]], Polygon3DBox[CompressedData["
1:eJwtyutSDgAYReFvjBsJSRJySpIkSZKUY5JUkqSShJAkSUIlSZKQJElCkiRJ
kiRJTsn5Qux3Zv1YM3ue2U6xqeEp4xwOR7Ear5w8HY4JarJyZk9ULpjtSWoK
5oxPVa5sczfMhe80zBWfrtzZ5jMwN74zMXd8lvJgm8/GZvCdg3ng89Rctrkn
NpvvfGwuvkB5sc29MU++CzEvfJHyYZv7Yt58F2M++BLlxzb3x3z5LsX88GUq
gG0eiPnzXY4F4CtUENs8GAvkuxILwlepELZ5KBbMdzUWgoerMLb5GiyU71os
DF+v1rHNN2Br+G7E1uGbVATbPBLbwHczFoFvUVFs82gsku9WLAqPVTFs8zgs
mu82LAbfruLZ5glYHN8dWDy+UyWyzZOwBL67sEQ8RSWzzVOxJL67sWR8j0pj
m6djqXz3Ymn4PpXBNt+PpfM9gGXgB1Um2/wQtp/vYSwTP6Ky2ObZ2CG+R7Es
/JjKYZvnYtl8j2M5+AmVxzbPx3L5nsTy8FOqgG1eiOXzPY0V4GfVGbZ5EVbI
txg7g59TJWzzUqyI73msBL+gytjm5Vgp34tYGX5JVbDNK7FyvpexCvyKqmKb
V2OVfK9iVfh1dY1tXoNV872BXcNvqlq2eR1Ww/cWVovfVvVs8wasju8drB6/
qxrZ5k1YA997WCN+XzWzzR9gTXwfYs34I9XCNm/FHvB9jLXgT1Qb27wda+X7
FGvDn6kOtnkn1s73OdaBv1BdbPNurJPvS6wLf6V62Oa9WDff11gP/kb1sc37
sV6+b7E+/J0aYJsPYv1832MD+Ac1xDYfxgb5fsSG8E9qhG3+GRvm+wUbwb+p
r2zzUewz3+/YV/yHGmOb/8RG+f7CxvA/6jfb/C/2k+8/7D/8BKO4
      "]]}]},
  Boxed->False,
  DefaultBaseStyle->{LightDarkAutoColorRules -> <|"MarkedColors" -> True|>},
  ImageSize->{360., 201.34324588774683`},
  ViewAngle->0.18790081983399254`,
  ViewCenter->{{0.5, 0.5, 0.5}, {0.4857516172855464, 0.5262055268721966}},
  ViewPoint->{1.3948195106364902`, -2.7122219334310294`, 1.465718498403918},
  ViewVertical->{-0.002785720879287529, -0.013428328525244719`, 
   0.9999059554539119}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGBQB+Ky9488dpe+dQzi148H0e7z1qWC6C37GbtAtMnLFZtA
dIf91IMgOnv1/lnHgXRb1jblE0BaRb7SC0Qvc5eLAtGhB1x3gmim9xdOgeiT
89a+AtHbWk4xnATS9kVx/CD6xSQjFRB9zPG2BoheOH9t0wUgPeFNTw+IDlaJ
XQCi/+qfF78Icl/j3o8guiXpI8MlIG00eXEJiP52j6kPRP8613boMZBOefv7
E4j+9GPufxC9wtJ67RMgrXNSy/cTkF6l/uCCZdlbx4mPnB9aAekNva4rbIF0
n5cVnx2Qtpd9aesEpM8rGYVMbX7reCp6ceocIK0itl7xftdbxyMBssyqs946
AgBL2qye
  "],
 CellLabel->"Out[10]=",
 CellID->1448913909,ExpressionUUID->"2180faaf-7e9c-48bb-931e-54831aa5dd0e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output Variables", "Subsection",
 CellChangeTimes->{{3.961300617871592*^9, 3.961300624074473*^9}, {
  3.9647754428799753`*^9, 
  3.964775444667988*^9}},ExpressionUUID->"5b0fc64c-537e-4a85-ac7f-\
8cc418664823"],

Cell[TextData[{
 StyleBox["The output variables are defined. In solid mechanics this always ",
  
  FontSize->18],
 StyleBox["u,v", "inTextCode",
  FontSize->18],
 StyleBox[" & ",
  FontSize->18],
 StyleBox["w", "inTextCode",
  FontSize->18],
 StyleBox[" which are defined in terms of ",
  FontSize->18],
 StyleBox["x, y", "inTextCode",
  FontSize->18],
 StyleBox[" & ",
  FontSize->18],
 StyleBox["z", "inTextCode",
  FontSize->18],
 StyleBox[".  Note. Care should be taken that none of these variables are \
previously defined in the notebook. If unsure, then a ",
  FontSize->18],
 StyleBox["Clear[u,v,w,x,y,z]", "inTextCode",
  FontSize->18],
 StyleBox[" expression can be used to clear them.",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.9613000531980667`*^9, 3.961300282281678*^9}, {
   3.964775453219928*^9, 3.9647754834133873`*^9}, 3.967650283171455*^9, 
   3.9705687245820923`*^9},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"86c60f4b-5b48-4093-814d-d3a1f52fe713"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
       RowBox[{"v", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
       RowBox[{"w", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";"}]], "Input",
 TextAlignment->Center,
 CellLabel->"In[11]:=",ExpressionUUID->"14cd84ba-21b5-4636-8486-4612e6f7e662"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Material Parameters", "Subsection",
 CellChangeTimes->{{3.9613008684297523`*^9, 
  3.961300873153916*^9}},ExpressionUUID->"22595fdc-30b9-424b-a255-\
a0404f0fa1c8"],

Cell[TextData[{
 "The material parameters have to be entered. In this case Youngs modulus and \
Poisson\[CloseCurlyQuote]s ratio. The mass density does not have to be \
entered as, in this case, the weight is included in the applied load, so that \
it may be compared to  the ",
 StyleBox["Timoshenko 1959", "Reference",
  FontWeight->"SemiBold"],
 " values."
}], "Text",
 CellChangeTimes->{{3.96130038160254*^9, 3.961300500969872*^9}, {
  3.964777186706441*^9, 3.9647772398807096`*^9}},
 FontFamily->"Baskerville",
 FontSize->18,
 FontWeight->"Regular",ExpressionUUID->"72dd1f1c-a4fc-45f4-a665-f3d30531d54d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"\"\<YoungModulus\>\"", "->", 
      RowBox[{"30", " ", 
       SuperscriptBox["10", "9"]}]}], ",", 
     RowBox[{"\"\<PoissonRatio\>\"", "->", "0.3"}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.9540871628713503`*^9, {3.954299606177107*^9, 3.954299683436338*^9}, 
   3.954300612861306*^9, {3.9613017090383368`*^9, 3.961301729180463*^9}, 
   3.9613161350958147`*^9},
 TextAlignment->Left,
 CellLabel->"In[12]:=",ExpressionUUID->"ca0d555a-e67a-41a0-86f2-c22b69a4d9f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load and Boundary Conditions", "Subsection",
 CellChangeTimes->{{3.96130088172327*^9, 3.961300887387974*^9}, {
  3.9647755124725523`*^9, 
  3.964775516892232*^9}},ExpressionUUID->"5de6c065-7850-44c6-9ce3-\
ebd1df29cd4c"],

Cell[TextData[StyleBox["Specify the loads and boundary conditions i.e. the \
uniformly distributed load (udl) on the top surface and the fixity along the \
edges i.e. z =0. Note that the slab should be anchored in space i.e. by \
specifying a boundary condition in the u and v directions. ",
 FontSize->18]], "Text",
 CellChangeTimes->{
  3.9540396776065273`*^9, {3.954303933184527*^9, 3.954304117127836*^9}, {
   3.9543041996844482`*^9, 3.954304228420632*^9}, {3.954304356671051*^9, 
   3.9543046905901117`*^9}, 3.954315908750505*^9, 3.961300544662278*^9, {
   3.9647755262680063`*^9, 3.964775530541551*^9}, {3.97056859547649*^9, 
   3.97056862965793*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"02c5d18d-3af7-4eb9-959d-2f5501b452ac"],

Cell[TextData[StyleBox["Care should be taken with these boundary conditions. \
As the slab has depth, if the u and v directions were set to zero for the \
full depth of the slab, along the edges then it would reduce the deflection \
and hence the moments  in the u and v directions. To avoid this , here it has \
been anchored at the central point, leaving the edges free to move \
horizontally.",
 FontSize->18]], "Text",
 CellChangeTimes->{
  3.9540396776065273`*^9, {3.954303933184527*^9, 3.954304117127836*^9}, {
   3.9543041996844482`*^9, 3.954304228420632*^9}, {3.954304356671051*^9, 
   3.9543046905901117`*^9}, 3.954315908750505*^9, 3.961300544662278*^9, {
   3.9647755262680063`*^9, 3.964775530541551*^9}, {3.97056859547649*^9, 
   3.970568611274495*^9}},
 FontSize->13,
 FontWeight->"Regular",
 CellID->1278565505,ExpressionUUID->"83e7c95d-9f81-4bf0-9256-c8a568d6d560"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"load", "=", 
   RowBox[{"SolidBoundaryLoadValue", "[", 
    RowBox[{
     RowBox[{"z", "==", "0.2"}], ",", "vars", ",", "pars", ",", 
     RowBox[{"<|", 
      RowBox[{"\"\<Pressure\>\"", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "15"}], 
          TemplateBox[{
            InterpretationBox["\[InvisibleSpace]", 1], "\"kPa\"", 
            "kilopascals", "\"Kilopascals\""},
           "Quantity"]}]}], "}"}]}], "|>"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bc1", "=", 
   RowBox[{"DirichletCondition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "==", "0"}], "||", 
      RowBox[{"x", "==", "6"}], "||", 
      RowBox[{"y", "==", "0"}], "||", 
      RowBox[{"y", "==", "4"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bc2", "=", 
   RowBox[{"DirichletCondition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}]}], "}"}], ",", 
     
     RowBox[{
      RowBox[{"x", "==", "3"}], "\[And]", 
      RowBox[{"y", "==", "2"}], "\[And]", 
      RowBox[{"z", "==", "0"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9540397073619213`*^9, 3.954039795278397*^9}, 
   3.9540401768977957`*^9, {3.954043176501423*^9, 3.954043254517932*^9}, {
   3.9540639049448833`*^9, 3.954063919125894*^9}, {3.954064207572981*^9, 
   3.954064514689419*^9}, 3.954064556110815*^9, {3.9540658573102293`*^9, 
   3.954065882007044*^9}, {3.954066088051283*^9, 3.954066110607388*^9}, {
   3.9540666422243433`*^9, 3.9540666481258802`*^9}, {3.9540667952204027`*^9, 
   3.954066829447299*^9}, 3.954066864869863*^9, {3.95406696828855*^9, 
   3.954067009044436*^9}, 3.954067215517171*^9, {3.954067440188342*^9, 
   3.954067443053299*^9}, {3.9540675552677927`*^9, 3.954067565332037*^9}, {
   3.95406764733066*^9, 3.954067659248849*^9}, {3.954067713595323*^9, 
   3.954067728127842*^9}, 3.954067768883765*^9, 3.954082777092826*^9, 
   3.954082813611479*^9, {3.954082983954248*^9, 3.954083038329702*^9}, {
   3.95408708674751*^9, 3.95408713069617*^9}, {3.954122599941935*^9, 
   3.9541226171349907`*^9}, {3.9541227162176733`*^9, 3.954122725050798*^9}, {
   3.9542995156684113`*^9, 3.954299540567382*^9}, {3.9542996946570873`*^9, 
   3.9542996966056004`*^9}, 3.954300723188067*^9, 3.954301244170043*^9, {
   3.954301690065331*^9, 3.954301708567515*^9}, {3.954301874635439*^9, 
   3.954301876829393*^9}, 3.9543020284056883`*^9, {3.954302211225543*^9, 
   3.954302228926126*^9}, {3.954302270352879*^9, 3.954302339719516*^9}, {
   3.9543024397657013`*^9, 3.9543024794065037`*^9}, 3.9543030101075583`*^9, {
   3.954303526253806*^9, 3.954303579020728*^9}, 3.954303655988847*^9, {
   3.9543039105968037`*^9, 3.954303916368895*^9}, {3.9543043280078373`*^9, 
   3.9543043349419928`*^9}, {3.954304731541716*^9, 3.954304755095962*^9}, {
   3.954316058870275*^9, 3.95431605985804*^9}, {3.9543161133238373`*^9, 
   3.9543161141889753`*^9}, {3.96130168030198*^9, 3.961301680970055*^9}, {
   3.9613052980611143`*^9, 3.961305299776716*^9}, 3.961305363799337*^9},
 TextAlignment->Left,
 CellTags->"ChatGeneratedCell",
 CellLabel->"In[13]:=",ExpressionUUID->"c9306546-89bc-4dfd-8125-80415ac92a4d"],

Cell["\<\
Alternatively, the displacement conditions could be written -\
\>", "Text",
 CellChangeTimes->{{3.9647774838026047`*^9, 
  3.96477751570485*^9}},ExpressionUUID->"115cf9f9-fcc4-469f-9fdb-\
e12f28eb61db"],

Cell[BoxData[{
 RowBox[{"bc1", "=", 
  RowBox[{"SolidDisplacementCondition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "==", "0"}], "||", 
     RowBox[{"x", "==", "6"}], "||", 
     RowBox[{"y", "==", "0"}], "||", 
     RowBox[{"y", "==", "4"}]}], ",", "vars", ",", "pars", ",", 
    RowBox[{"<|", 
     RowBox[{"\"\<Displacement\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None", ",", "0"}], "}"}]}], "|>"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"bc2", "=", 
  RowBox[{"SolidDisplacementCondition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "==", "3"}], "\[And]", 
     RowBox[{"y", "==", "2"}], "\[And]", 
     RowBox[{"z", "==", "0"}]}], ",", "vars", ",", "pars", ",", 
    RowBox[{"<|", 
     RowBox[{"\"\<Displacement\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "None"}], "}"}]}], "|>"}]}], 
   "]"}]}]}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.964777549311348*^9, 3.9647775567238073`*^9}, 
   3.966853787968405*^9},ExpressionUUID->"eb1d2068-d53c-451b-9671-\
08a0117afe51"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operator", "Subsection",
 CellChangeTimes->{{3.961301076874357*^9, 
  3.961301081775724*^9}},ExpressionUUID->"5939215f-cc01-4a00-82a9-\
30f5f09f5335"],

Cell["\<\
The operator, which forms the left hand side of the solution equation that \
incorporates the load and boundary conditions, is used to save typing.\
\>", "Text",
 CellChangeTimes->{{3.961301196385626*^9, 3.961301213861477*^9}, {
  3.9647773502691402`*^9, 3.9647774566794043`*^9}},
 FontWeight->"Regular",ExpressionUUID->"ec0df534-fd35-4d19-92c6-e436d8dd5721"],

Cell[BoxData[
 RowBox[{
  RowBox[{"op", "=", 
   RowBox[{"SolidMechanicsPDEComponent", "[", 
    RowBox[{"vars", ",", "pars"}], "]"}]}], ";"}]], "Input",
 TextAlignment->Left,
 CellLabel->"In[16]:=",ExpressionUUID->"21e3bf18-7c3a-4a1b-b88f-a0d443db79b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "Subsection",
 CellChangeTimes->{{3.9613012392135763`*^9, 
  3.961301241416041*^9}},ExpressionUUID->"f8b23a12-3e41-4684-ae29-\
845dcc3b00c4"],

Cell[TextData[{
 "The solution for the displacement variables ",
 StyleBox["u,v,w", "inTextCode"],
 " over the region ",
 StyleBox["mesh",
  FontSize->15,
  FontWeight->"SemiBold"],
 " is"
}], "Text",
 CellChangeTimes->{{3.961301260782321*^9, 3.961301272031912*^9}, {
  3.961301460933157*^9, 3.961301505166453*^9}, {3.961301547454406*^9, 
  3.961301549879971*^9}},
 FontWeight->"Regular",ExpressionUUID->"a5596e21-3b5c-4d87-951b-42025b0a3f2f"],

Cell[TextData[{
 StyleBox["NDSolveValue[SolidMechanicsPDEComponent[vars,pars]== \
boundaryConditions ]",
  FontWeight->"SemiBold"],
 " i.e."
}], "Text",
 CellChangeTimes->{{3.9613012936233177`*^9, 3.961301344693149*^9}, {
   3.961301393041806*^9, 3.961301457474042*^9}, {3.961301807420903*^9, 
   3.961301812404126*^9}, 3.9676862678531647`*^9},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"76a92304-d9a5-4ab9-954f-60521b20e736"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"displacement", "=", 
  RowBox[{"NDSolveValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"op", "\[Equal]", "load"}], ",", "bc1", ",", "bc2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "mesh"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.954040466842557*^9, 3.954040502028657*^9}, {
   3.95406452017474*^9, 3.954064544123233*^9}, {3.9540659220348673`*^9, 
   3.954065933650009*^9}, {3.9540668392175207`*^9, 3.95406686851197*^9}, 
   3.954067060180211*^9, 3.954067114298661*^9, {3.95408288225825*^9, 
   3.954082895039238*^9}, {3.95408304859315*^9, 3.954083059255823*^9}, {
   3.954087137810206*^9, 3.954087147466118*^9}, {3.954298471498849*^9, 
   3.954298473025745*^9}, 3.9543006506459427`*^9, 3.9543006928439198`*^9, 
   3.9543036643751307`*^9, {3.954304160614592*^9, 3.954304167038673*^9}, 
   3.954304763703815*^9, {3.954307178160687*^9, 3.9543071799018707`*^9}, {
   3.954315537159321*^9, 3.9543155400438213`*^9}, {3.954315748227199*^9, 
   3.954315753380362*^9}, 3.961301778954517*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"552eb478-f1a3-4a98-8e4c-5e41a1da6f0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    TemplateBox[{
      RowBox[{
        StyleBox[
         TagBox["InterpolatingFunction", "SummaryHead"], 
         "NonInterpretableSummary"], 
        StyleBox["[", "NonInterpretableSummary"], 
        DynamicModuleBox[{
         Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
         TemplateBox[{
           TemplateBox[{
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["2", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Unstructured\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
            "SummaryPanel"], 
           ButtonBox[
            DynamicBox[
             ToBoxes[
              If[
               
               Or[$VersionNumber < 11.2, CurrentValue["RunningEvaluator"] =!= 
                "Local"], 
               Style["This object cannot be used as input.", "SummaryEmbed"], 
               
               BoxForm`EmbedSummaryLabel[InterpolatingFunction, 4279016, 
                Dynamic[Typeset`embedState$$], Automatic]], StandardForm]], 
            ButtonFunction :> 
            BoxForm`EmbedSummaryInterpretation[
             "Choose", InterpolatingFunction, 4279016, 
              6955266494116431258129440429932826591122266789157284098448, 
              EvaluationBox[], 
              Dynamic[Typeset`embedState$$], StandardForm, 
              ElisionsDump`embedSummaryBoxes], DefaultBaseStyle -> 
            "SummaryEmbedButton", ImageSize -> Inherited, 
            BaseStyle -> {"DialogStyle"}, Enabled -> Dynamic[
              
              And[$VersionNumber >= 11.2, CurrentValue["RunningEvaluator"] === 
               "Local", Typeset`embedState$$ === "Ready"]], Appearance -> 
            Inherited, Method -> Inherited, Evaluator -> Automatic]}, 
          "SummaryEmbedGrid"], DynamicModuleValues :> {}], 
        StyleBox["]", "NonInterpretableSummary"]}]},
     "CopyTag",
     DisplayFunction->(#& ),
     InterpretationFunction->(
      "InterpolatingFunction[{{0., 6.}, {0., 4.}, {0., 0.2}}, <>]"& )],
    False,
    BoxID -> 6955266494116431258129440429932826591122266789157284098448,
    Editable->False,
    SelectWithContents->True,
    Selectable->False], ",", 
   TagBox[
    TemplateBox[{
      RowBox[{
        StyleBox[
         TagBox["InterpolatingFunction", "SummaryHead"], 
         "NonInterpretableSummary"], 
        StyleBox["[", "NonInterpretableSummary"], 
        DynamicModuleBox[{
         Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
         TemplateBox[{
           TemplateBox[{
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["2", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Unstructured\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
            "SummaryPanel"], 
           ButtonBox[
            DynamicBox[
             ToBoxes[
              If[
               
               Or[$VersionNumber < 11.2, CurrentValue["RunningEvaluator"] =!= 
                "Local"], 
               Style["This object cannot be used as input.", "SummaryEmbed"], 
               
               BoxForm`EmbedSummaryLabel[InterpolatingFunction, 4279016, 
                Dynamic[Typeset`embedState$$], Automatic]], StandardForm]], 
            ButtonFunction :> 
            BoxForm`EmbedSummaryInterpretation[
             "Choose", InterpolatingFunction, 4279016, 
              6955266494116431258129440429932826591140713533230997377616, 
              EvaluationBox[], 
              Dynamic[Typeset`embedState$$], StandardForm, 
              ElisionsDump`embedSummaryBoxes], DefaultBaseStyle -> 
            "SummaryEmbedButton", ImageSize -> Inherited, 
            BaseStyle -> {"DialogStyle"}, Enabled -> Dynamic[
              
              And[$VersionNumber >= 11.2, CurrentValue["RunningEvaluator"] === 
               "Local", Typeset`embedState$$ === "Ready"]], Appearance -> 
            Inherited, Method -> Inherited, Evaluator -> Automatic]}, 
          "SummaryEmbedGrid"], DynamicModuleValues :> {}], 
        StyleBox["]", "NonInterpretableSummary"]}]},
     "CopyTag",
     DisplayFunction->(#& ),
     InterpretationFunction->(
      "InterpolatingFunction[{{0., 6.}, {0., 4.}, {0., 0.2}}, <>]"& )],
    False,
    BoxID -> 6955266494116431258129440429932826591140713533230997377616,
    Editable->False,
    SelectWithContents->True,
    Selectable->False], ",", 
   TagBox[
    TemplateBox[{
      RowBox[{
        StyleBox[
         TagBox["InterpolatingFunction", "SummaryHead"], 
         "NonInterpretableSummary"], 
        StyleBox["[", "NonInterpretableSummary"], 
        DynamicModuleBox[{
         Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
         TemplateBox[{
           TemplateBox[{
             PaneSelectorBox[{False -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}], True -> GridBox[{{
                   PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   GraphicsBox[{{
                    GrayLevel[0.6], 
                    AbsolutePointSize[5], 
                    PointBox[{1, 1}], 
                    PointBox[{2, 4}], 
                    PointBox[{3, 2}], 
                    PointBox[{4, 3}]}, {{}, {}, {
                    AbsoluteThickness[1], 
                    Opacity[1.], 
                    LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA4ScLwZmZ6T/ACPskWpOYv4AjHgZ5
3Os/cnpQh5xu1j/qWn1XCVDuP5K7ih5ptuc/r+pongFN8D/CUK87BHLxP46d
cUQ/bPE/ujUa8/qu9j9TbqBw1aPyP/TWyyAhFfw/neDJZqDG8z+QAqdF9GsA
QM1wGePDAfU/VsVD/9nXAkCidscSKDf2P6Bp73exDQVA/B1wDMFX9z+TpM3k
wfUGQDzjPoyykPg/7M3Z+O7ZCEABSgjW2LT5P3pl9LwNcgpAbCYw0z/T+j86
ypori9cLQL0gflb/Cfw/lpOs9xIqDUCTvMaj8yv9Pw4alcoYNg5AT3Y1d0Bm
/j+pB2LLtyIPQLClAv7Nmv8/NnA5bbjSD0BLO2UnSF0AQFrcILXmpw9AsTLc
klX5AED+sDHBQukOQNp6UGP9igFAbZ+lR/sLDkD10dd20SgCQNHi3Mj38wxA
42MO5MXDAkAZdr6AZb8LQJRGQrZUVANArv7zEMKHCkA4OInLD/EDQLBlMO3M
IglAnnrNRWWDBEA3d8OX6skHQNf3wBnbEgVAD3D3ndNyBkADhMcwfa4FQHOK
7Wak/wRA8WDLrLk/BkC/MhCgYawDQNJM4msi3QZAwss/TmVLAkCGc6iEq3cH
QIsIg92+BgFA/OprAs8HCECrPCvgePD/P2VxQsMepAhAKXVLE0Xg/j+RSBbp
CDYJQPRz0a7WJ/4/kFqZaBPFCUDN4sX5uLj9P4J7LytKYApAvh1MbRmT/T82
7cJSG/EKQHzT1YZwwv0/3W1pvRiOC0B2LZ/10lT+P0c/DY2wIAxAVrX8MJA7
/z+DS2C2aLAMQElWzbMzPQBAsmbGIk1MDUCi9bAadCABQKTSKfTL3Q1AYexd
q+EpAkCJTaAId3sOQFyS/ndEhgNAQAPGdkIWD0BHWcLdahwFQLoJ6Umopg9A
vd1CiejSBkCTjw8wnSEQQPiVkXD08QhAq0KpbbNqEEBsk2Azxi4LQCyTGthZ
shBAYCBYjj+gDUAnaxVkFgARQMwfdA9ySBBAg+uOIqBIEUBj/5rHgMsRQNFn
q5SZmRFAL++xNeOlE0Dwt3AR
                    "]]}}}, AspectRatio -> 1, Axes -> False, Background -> 
                    GrayLevel[0.93], Frame -> True, FrameStyle -> Directive[
                    GrayLevel[0.7], 
                    Thickness[Tiny]], FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRange -> {{0, 5}, {0, 5}}], 
                   GridBox[{{
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "6.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "0.2`"}], "}"}]}], "}"}], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["2", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Unstructured\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 BaselinePosition -> {1, 1}]}, 
              Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
            "SummaryPanel"], 
           ButtonBox[
            DynamicBox[
             ToBoxes[
              If[
               
               Or[$VersionNumber < 11.2, CurrentValue["RunningEvaluator"] =!= 
                "Local"], 
               Style["This object cannot be used as input.", "SummaryEmbed"], 
               
               BoxForm`EmbedSummaryLabel[InterpolatingFunction, 4279016, 
                Dynamic[Typeset`embedState$$], Automatic]], StandardForm]], 
            ButtonFunction :> 
            BoxForm`EmbedSummaryInterpretation[
             "Choose", InterpolatingFunction, 4279016, 
              6955266494116431258129440429932826591159160277304706918912, 
              EvaluationBox[], 
              Dynamic[Typeset`embedState$$], StandardForm, 
              ElisionsDump`embedSummaryBoxes], DefaultBaseStyle -> 
            "SummaryEmbedButton", ImageSize -> Inherited, 
            BaseStyle -> {"DialogStyle"}, Enabled -> Dynamic[
              
              And[$VersionNumber >= 11.2, CurrentValue["RunningEvaluator"] === 
               "Local", Typeset`embedState$$ === "Ready"]], Appearance -> 
            Inherited, Method -> Inherited, Evaluator -> Automatic]}, 
          "SummaryEmbedGrid"], DynamicModuleValues :> {}], 
        StyleBox["]", "NonInterpretableSummary"]}]},
     "CopyTag",
     DisplayFunction->(#& ),
     InterpretationFunction->(
      "InterpolatingFunction[{{0., 6.}, {0., 4.}, {0., 0.2}}, <>]"& )],
    False,
    BoxID -> 6955266494116431258129440429932826591159160277304706918912,
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], "}"}]], "Output",
 CellChangeTimes->{3.961301791629056*^9, 3.961305340942296*^9, 
  3.9613053886119328`*^9, 3.961316152705351*^9, 3.965122843222447*^9, 
  3.973130278149827*^9},
 CellLabel->"Out[17]=",
 CellID->1578995230,ExpressionUUID->"b58685ef-eb28-4539-86e3-a5d196500026"]
}, Open  ]],

Cell[TextData[{
 "Note the use of the equality sign(",
 StyleBox["==", "inTextCode"],
 ") for ",
 StyleBox["op== load", "inTextCode"],
 " etc. and the expression for ",
 StyleBox["op== boundaryConditions", "inTextCode"],
 " is enclosed in curly brackets."
}], "Text",
 CellChangeTimes->{{3.961303340937706*^9, 3.961303448057654*^9}, 
   3.967686261199314*^9},
 FontWeight->"Regular",ExpressionUUID->"ab4f3f39-d1dc-485e-b033-d3f758b1a3ad"],

Cell[TextData[{
 "The solution may take a few moments, depending on the speed of your \
computer. It results in three displacement functions which interpolate the \
displacement over the whole region, the mesh, in the ",
 StyleBox["u",
  FontWeight->"SemiBold"],
 ",",
 StyleBox["v",
  FontWeight->"SemiBold"],
 ", and ",
 StyleBox["w",
  FontWeight->"SemiBold"],
 " directions. These functions can be used to define the displacement in any \
direction anywhere on the slab."
}], "Text",
 CellChangeTimes->{{3.9613018382014847`*^9, 3.961301963366376*^9}, {
  3.961302050804625*^9, 3.961302081892817*^9}},
 FontWeight->"Regular",ExpressionUUID->"52b17407-e99f-44e8-a349-d2a48d3d2d54"],

Cell[TextData[{
 "For instance, this will give me the displacement in the ",
 StyleBox["w",
  FontWeight->"SemiBold"],
 " or vertical direction, at the centre in metres."
}], "Text",
 CellChangeTimes->{{3.9540873058676434`*^9, 3.954087316993663*^9}, {
  3.954304805328042*^9, 3.9543048093478117`*^9}, {3.961302096235385*^9, 
  3.9613021020378447`*^9}, {3.9647776706609297`*^9, 3.964777702340376*^9}},
 FontWeight->"Regular",ExpressionUUID->"60c3aa55-e505-44ce-b642-143153c81004"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"displacement", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "[", 
  RowBox[{"3", ",", "2", ",", "0.1"}], "]"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"9b1c4efe-9ee5-4216-8525-652f09561720"],

Cell[BoxData[
 RowBox[{"-", "0.0014009067412133489`"}]], "Output",
 CellChangeTimes->{3.954298543317819*^9, 3.954300710428666*^9, 
  3.954300747242731*^9, 3.9543012719547253`*^9, 3.954301736761915*^9, 
  3.954301905206807*^9, 3.954302073299246*^9, 3.9543030489969788`*^9, 
  3.954303616647554*^9, 3.95430369561561*^9, 3.954304800693871*^9, 
  3.954307197313711*^9, 3.954315770944531*^9, 3.954316088636756*^9, 
  3.954316142706524*^9, 3.961302107728951*^9, 3.961305341008774*^9, 
  3.961305388676412*^9, 3.961316152755966*^9, 3.9651228433014317`*^9, 
  3.9731302782298737`*^9},
 CellLabel->"Out[18]=",
 CellID->1717404631,ExpressionUUID->"a7f201fa-b5ff-46c4-8326-f0a2d0464933"]
}, Open  ]],

Cell[TextData[StyleBox["or on the surface, at the centre.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.9543049131146107`*^9, 3.954304917464912*^9}, {
  3.961302124480823*^9, 3.961302127883374*^9}, {3.9647777162757874`*^9, 
  3.964777719817505*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"eb80cf6f-693f-410f-8c74-b6107d13fdab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"displacement", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "[", 
  RowBox[{"3", ",", "2", ",", "0.2"}], "]"}]], "Input",
 CellChangeTimes->{
  3.9543048847107573`*^9, 3.954304938110594*^9, {3.9613021427280197`*^9, 
   3.961302149534666*^9}, {3.9613021936512423`*^9, 3.961302194483898*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"a2a756d9-136a-45e4-b4d5-e43b37ed5973"],

Cell[BoxData[
 RowBox[{"-", "0.0013985354682315297`"}]], "Output",
 CellChangeTimes->{{3.9543048634203987`*^9, 3.95430488683146*^9}, 
   3.954304943683052*^9, 3.9543071973167458`*^9, 3.954315770947879*^9, 
   3.954316088650532*^9, 3.95431614270954*^9, 3.961302150806429*^9, 
   3.961302199782988*^9, 3.961316152765067*^9, 3.96512284330571*^9, 
   3.973130278243325*^9},
 CellLabel->"Out[19]=",
 CellID->91933890,ExpressionUUID->"9e09f581-7bcc-4712-8a3a-08739c2e138f"]
}, Open  ]],

Cell[TextData[StyleBox["See below for a comparison with the analytical \
values.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.9541232815274067`*^9, 3.9541233349903383`*^9}, {
  3.954123385427793*^9, 3.954123409057774*^9}, {3.954315797901853*^9, 
  3.95431580113459*^9}, {3.961302215050949*^9, 3.961302252117505*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"6f65b34c-742d-4c18-89b7-03e4e93bb350"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Post Processing", "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.961302566611251*^9, 
  3.9613025710329647`*^9}},ExpressionUUID->"bc967066-d49e-453d-9db1-\
416b45cf73db"],

Cell["\<\
Whilst the displacement is useful, the bending moments are required to design \
the reinforcement. These can be found by differentiating the displacement.\
\>", "Text",
 CellChangeTimes->{{3.961302471194989*^9, 
  3.961302557836815*^9}},ExpressionUUID->"a30fbb23-2640-4a83-be85-\
6e4d48e687cb"],

Cell[CellGroupData[{

Cell["Calculating bending moments", "Subsubsection",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.954122184297015*^9, 3.954122211647698*^9}, {
  3.9613026175773563`*^9, 
  3.961302621748406*^9}},ExpressionUUID->"ffdf754d-bfba-4b86-bbf3-\
951c1cc4032e"],

Cell["\<\
A displacement function is defined. In this case the displacement in the w or \
z direction.\
\>", "Text",
 CellChangeTimes->{{3.9613026481399918`*^9, 3.961302680941544*^9}, {
  3.961302719133808*^9, 
  3.9613027254156733`*^9}},ExpressionUUID->"f130a35b-6963-4dea-9b49-\
cf32cc7b9978"],

Cell[BoxData[
 RowBox[{
  RowBox[{"displacementFunction", "=", 
   RowBox[{"displacement", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.954123106144519*^9, 3.954123111031472*^9}, 
   3.954305192942738*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"cabbab72-0ae8-4a66-aa27-f59d6c2e4daa"],

Cell["\<\
The second derivative of the displacement in the x, y and xy directions is \
then found to define the curvatures. The displacement function is applied at \
the centre of the slab thickness eg. 0.1m\
\>", "Text",
 CellChangeTimes->{{3.961302761344492*^9, 3.961302824856954*^9}, {
  3.961303230223197*^9, 3.961303280710352*^9}},
 FontWeight->"Regular",ExpressionUUID->"b6ff5a92-7608-4178-b106-f4a40cbc5412"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Functions", " ", "for", " ", "curvatures", " ", 
    RowBox[{"i", ".", "e", ".", " ", "the"}], " ", "2", "nd", " ", 
    "derivative", " ", "of", " ", "the", " ", "displacement"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Kappa]xx", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"displacementFunction", "[", 
        RowBox[{"x", ",", "y", ",", "0.1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Kappa]yy", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"displacementFunction", "[", 
        RowBox[{"x", ",", "y", ",", "0.1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Kappa]xy", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"displacementFunction", "[", 
        RowBox[{"x", ",", "y", ",", "0.1"}], "]"}], ",", "x", ",", "y"}], 
      "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9540878009309053`*^9, 3.954087882755715*^9}, 
   3.95412303871887*^9, {3.954123706777289*^9, 3.9541237247902822`*^9}, {
   3.954151504383272*^9, 3.9541515058516493`*^9}, 3.9542986811013517`*^9, {
   3.954305129281357*^9, 3.954305156806562*^9}, {3.954307234357646*^9, 
   3.9543072699601088`*^9}, {3.9543073015134983`*^9, 3.954307304365014*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"83177d0d-1144-4cdb-b128-feef372fa6e0"],

Cell["\<\
Then the bending moments can be found by applying the flexural rigidity of \
the slab to the curvatures\
\>", "Text",
 CellChangeTimes->{{3.954123184760318*^9, 3.9541232327124233`*^9}, {
  3.961302841525866*^9, 3.961302857269402*^9}},
 FontWeight->"Regular",ExpressionUUID->"f8e2dd9d-a48f-4569-880d-5bcc84c235ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Flexural", " ", "rigidity"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"Em", "=", 
     RowBox[{"30", "*", 
      SuperscriptBox["10", "9"]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Young", "'"}], "s", " ", "modulus", " ", "in", " ", "Pascals"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Nu]", "=", "0.3"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Poisson", "'"}], "s", " ", "ratio"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h", "=", "0.2"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Thickness", " ", "in", " ", "meters"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"flexuralRigidity", "=", 
     RowBox[{"Em", " ", 
      RowBox[{
       RowBox[{"h", "^", "3"}], "/", 
       RowBox[{"(", 
        RowBox[{"12", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Nu]", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.954300936360983*^9, 3.9543009374837713`*^9}, {
  3.954301012396118*^9, 3.954301020062132*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"eea758b0-17cb-477c-aad2-51b9bdeb9948"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Bending", " ", "moments"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Mxx", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"-", "flexuralRigidity"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Kappa]xx", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "+", 
        RowBox[{"\[Nu]", " ", 
         RowBox[{"\[Kappa]yy", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Myy", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"-", "flexuralRigidity"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Kappa]yy", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "+", 
        RowBox[{"\[Nu]", " ", 
         RowBox[{"\[Kappa]xx", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Mxy", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"-", "flexuralRigidity"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Nu]"}], ")"}], " ", 
      RowBox[{"\[Kappa]xy", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{3.954085640310902*^9, 3.954298857243775*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"5b8945cf-e024-42f0-9989-08aa6486c1ac"],

Cell["\<\
These functions allow the moments to be found anywhere on the slab. Note the \
results are in Joules (Nm) e.g. To find bending moment at a point (x0, y0)\
\>", "Text",
 CellChangeTimes->{{3.961303095999694*^9, 3.961303120747707*^9}, {
  3.961303198093869*^9, 3.96130319899723*^9}, {3.961303736857029*^9, 
  3.9613037761550407`*^9}, {3.9720926021720324`*^9, 3.972092623325679*^9}},
 FontWeight->"Regular",ExpressionUUID->"30ead202-d89e-48a1-85cc-cebddf75370c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x0", "=", "3"}], ";", " ", 
  RowBox[{"y0", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mxx", "[", 
    RowBox[{"x0", ",", "y0"}], "]"}], ",", 
   RowBox[{"Myy", "[", 
    RowBox[{"x0", ",", "y0"}], "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.9541235508048763`*^9, 3.954123589837035*^9}, {
   3.9542989116361713`*^9, 3.954298912720846*^9}, {3.954298945402831*^9, 
   3.954298966116686*^9}, {3.954299194115624*^9, 3.954299195422319*^9}, 
   3.954300873585805*^9, {3.954300988891026*^9, 3.954301000725515*^9}, {
   3.9543015867625628`*^9, 3.954301598834429*^9}, {3.961303204711218*^9, 
   3.961303208216424*^9}, 3.961304698394474*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"a441916f-5f47-4c15-a3ca-ec8c4d5274d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "12269.768214705748`"}], ",", 
   RowBox[{"-", "20063.32404079967`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9542989670778913`*^9, 3.9542989904215527`*^9}, 
   3.9542991406010303`*^9, 3.954299197041462*^9, 3.954300800926412*^9, 
   3.954300876973576*^9, 3.954300957637701*^9, 3.9543009934331408`*^9, 
   3.954301028446094*^9, 3.954301272064049*^9, 3.954301600571982*^9, 
   3.954301736868445*^9, 3.954301905321558*^9, 3.954302073437965*^9, 
   3.9543030491172447`*^9, 3.9543036167622337`*^9, 3.954303695750976*^9, 
   3.954305262550272*^9, 3.9543071974019823`*^9, 3.954307286294882*^9, 
   3.954315771041271*^9, 3.954316088758403*^9, 3.9543161428042803`*^9, 
   3.961303706889929*^9, 3.961304699133518*^9, 3.961316152856988*^9, 
   3.965122843511763*^9, 3.9731302783262453`*^9},
 CellLabel->"Out[32]=",
 CellID->1092147037,ExpressionUUID->"1c5284e0-1dc9-454f-abc3-1cb351b536c7"]
}, Open  ]],

Cell["\<\
Similarly, the maximum and minimum values can be found by finding the \
numerical maximum value  (NMaxValue of the required moment over the region \
described by the limits shown.\
\>", "Text",
 CellChangeTimes->{{3.961303467696272*^9, 3.961303506811718*^9}, {
  3.96130354339631*^9, 3.961303695318513*^9}},
 FontWeight->"Regular",ExpressionUUID->"e1c1c762-2cd4-4731-8d58-d76f95a30333"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"minMxy", "=", 
  RowBox[{"NMinValue", "[", 
   RowBox[{
    RowBox[{"Mxy", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "4"}], "}"}]}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"maxMxy", "=", 
  RowBox[{"NMaxValue", "[", 
   RowBox[{
    RowBox[{"Mxy", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "4"}], "}"}]}], "]"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.954319212027772*^9, 3.9543192171965303`*^9}, {
   3.9543196307667007`*^9, 3.95431964192148*^9}, 3.954321981322404*^9, {
   3.961303533930388*^9, 3.961303536155713*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"f496f9c9-7127-4672-998a-6e6e516a505e"],

Cell[BoxData[
 RowBox[{"-", "10186.703197408118`"}]], "Output",
 CellChangeTimes->{3.95431922035436*^9, 3.9543219827211018`*^9, 
  3.961303707419951*^9, 3.961316153109212*^9, 3.965122844034358*^9, 
  3.973130278875517*^9},
 CellLabel->"Out[33]=",
 CellID->1172519950,ExpressionUUID->"659207d9-62ff-46cd-8221-887115dfe448"],

Cell[BoxData["11137.252387374227`"], "Output",
 CellChangeTimes->{3.95431922035436*^9, 3.9543219827211018`*^9, 
  3.961303707419951*^9, 3.961316153109212*^9, 3.965122844034358*^9, 
  3.973130279119479*^9},
 CellLabel->"Out[34]=",
 CellID->1232854778,ExpressionUUID->"068cdec7-335e-4bc0-adab-8322b32a6dbd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.954301378525159*^9, 
  3.954301380097711*^9}},ExpressionUUID->"180b5b72-cde2-449c-a76a-\
4c30a2eb3d5f"],

Cell["\<\
These results may be plotted out, using Mathematica\[CloseCurlyQuote]s \
standard functions.\
\>", "Text",
 CellChangeTimes->{{3.9613041096884937`*^9, 3.9613041188638153`*^9}, 
   3.9613041529170427`*^9, {3.961304224241695*^9, 3.961304242380418*^9}},
 FontWeight->"Regular",ExpressionUUID->"82b3754c-3bcd-4d07-94bb-fcaad7fc8bd0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Mxx", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "4"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"ColorFunction", "->", "\"\<TemperatureMap\>\""}], ","}], "*)"}], 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"Contours", "->", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9543014951232443`*^9, 3.9543014960745087`*^9}, 
   3.954303782908725*^9, 3.954307576975218*^9, {3.954307665572596*^9, 
   3.954307666167288*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"72739246-5c1d-4ac8-9fb3-375d288f3bd8"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx0nQd4VkX2/980UiC9oS4WwLaKvevuXOuCbRW72HVdu2Jh7WJbu6uIZe2y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      "], {{{
         EdgeForm[], 
         LABColor[
         0.23745774548744952`, 0.4502326479674302, -0.2934475891990957], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmmeUVtUVhu/9GCC0acw3lWFmGJQOC4kVSIxxqcgPlwUEC02NGClijCII
SrVkYSKaKMZIMySiqCjDgPonyVpZAVRElA4qyjBYQBJFevI+7ncW+XE4e849
d99zdnl3+agZM/GaCZkkSRr0TzPNfTUv1Pit6GybJGnfJmjWoR8XfU4m/n4w
ibW+3g9d5D1TOgS9PpskbdsmSTuNa7Q+ozpJjuYmyUzN2wrjGev12vtWXpK0
0nx2Gt+A/0XaW2ieS7T+jEYXjev0fLPmao0/c4bWSfKm6EWZePch7T+iv+/T
6KxRr9FT4x6tD9HzraI7aRzUeECjl8aVRUkyWOMLPZ/SMknu1+iqcZ/uUqBv
/Et32aAzry+Mv+9P4xvwn6f7tND5H9f8dGXc6w+aB2vvVe3jfmUa5Rq/0xlK
xLdYY57oC9KgpyPnmiR5VIqoLtYdOsT+9/Tdh/R3n5wkeUo8Lxf9nvYMrYmz
rNPI174CfTNH83Xic21BkqzReXo2i28j195pyDLf8szT/mairxX9TRp7Htbc
TjJoqzFS63frDK21/vdsPG/tPZyXO5wn+juda4a+Uyr6Zsluu+auGjNbJMmO
HyXJONGby4K+uCRJXqwMPvD+VM++11mnpWFHnAu9VxWHHJDHRN1vsL7Vrrm+
qXef1LuLNe+1Tm/T/iLxba7n/9D+owXBs0LP2mts0fujtWdoJmjsjXmr6ebt
452snjcUBs27L7aKPfDAvhq1XpYJ3WK7PF+usxwoOPMcemYac6PX19lm0PUd
unOqd56sDD3wDP3fLr5fa75I40uNLzQu1HhMMliguZtlvs58XqsQfz0bJjnd
kQn9DdDYpedZzbdozyit7xbdPQ27vtJ6HaP1z7XWT+P8NPwNmS/Xuy9plGZC
fvyNXliDRj63auzX2rkal0nml0jml5eEPJEvckZeozRfrTE6EzpGT9u1Z7j+
HpOEjI9Z5uuyYZeTJZvn24VdcUfkt88yx7eZp2l9fBr3KEjDRgZKfzWif1wa
Z5+qeTW2LvpX2l9neqrmNdhEJnBglegC0XeLfsP0lDT4/UTj16Jzi8If8IW3
9XeF9x/JjWesr9R6vtbvEr3C7/PuKu9Hj+wpz4S83zLN/sHmD+YgG/SH7l4z
z8nGLs4MTi23ftDLXWlgVIl9cH3L8MOlev6CxgzxGWl6RCb2TvH+S6WzgdLd
/I6BcTy71di+yPjePw1e8EHPh+XPp/WdWZrf0f78NPiyB0xbIJvOlW88o7mF
ZHBKujuucYXPhZ++UBrnbNSddxbGfvDnQ2M6eI5dYB/v6p1taeA1WL3VdFEa
2M/+Qs2vauSJnpiEvZ9MQ+/o8Kft457En0yb8HfuVWYcBlvGas/jutOfdO5C
7XtOc73WVmvk5IUM8UN88I/4rfY8q3mZeCyRf8/Tsz2FsQ72VhjrnxA9vzL8
4EXd913ZeanWp8vO++dGfCVubsgGPVXrG7Px/gzRA3JjP+cs1lzi/dM6BP1O
NuRf7HX2Fnv/K5bJvZp/VhV+9aHml7HpTNgndng8PRPHoLHJCWByGnJmPmoa
XD+Rhv0f1nwqDTv81PQ99hH2THVsPen4usBY9pBtG57E5kb0nYadg2f4M768
R+dd0y5sboXPPCEJG2A/usZ28mw/HxeG7oYkoYcC62K28PFc2ewNZWEL2ATf
mFca8ZS4ip2eLoiYCk5vMMbucBzDH7HDTsa1pzNhE9jDfOcbYOhNmcAR3mEG
S8hVWrWOWDUJf/I67/asDb9tVhL+cSw3fAQd4Qfcl3jPOR/UOb+UPDoq5nRp
GbiIL67VvjvL447c9fpM5COj7VPwAaMaNM/SqNXYl4ZdQB/XN0/kxtnAU751
tX1noGX1bU6s83y89yEH7nTM766W3b1fEHe9UWe4IRN35y7YGljRuzLiZS/N
C9rFfbhLg97bXxAY84LxZITxZ2YSfjSoZeDIbNlDz1aRS5Bf8L2NBXGW7nre
Pyfwrd52V4YtGSuhwe3vcyMvOmqa/AT/3yCel6aRD4CzxEDi10bnA8zvm17k
PBmchMcR89nkbyDz5ZzTcZHYB32t7X+yfarpGTFxuGn2cGbiNpiMbBqcV+Cb
7a3fbf4bPi+3irh/nX0f/YKNb9sXe6TxnPjCHs6y09/CX8Cvl1pFTgN/bABZ
Izfk+ZXGHPNBzt1ahs3Bb7d58v5ux/hnjSvYIjnUNudadT5PsW3nuO0HvAP3
tlUFLvEuPrXQmAw2w3uPv8UaPs+9/1kQNL4/pzrseXb1mWfcu8G5BDKclR/f
xecO6O/ZGmel8bzBfoXvT/Q5yTt4ttZ4Ndn7J1qmt1rmnf4Pl5At+ie2coYh
vjs6JTYtK40Y+lwn+YXsrZfGv8ktWgf2gXufaO/HaeROD1dEPLysOHJ2ZI3u
dunZTvPdaRvju8Q6ZmROvole0SlYR01CLbDNOTDPqFFYBwO7GrfAvQ9s0+AI
9Rz1GDk68YcYRtyhRiFWEXeGZaJGQ+9raiL2kmtwL+6Ej//EMRlc2KLxkWVH
TCDeEBc2VwUGz3Kex9lH2W6326fILbgPdzltuoTYJjy8SjrcUB650gnXFwPT
wBIwZaExhvMvNdZwfuq69a6nLq6Kv6n/kNMW1wInnNfAkzznhL+Lfe6y/aNz
dI99gHFzWgQ2ETeP+8xZ1yyX6DuPWL/omXNyfs5Kvk/ef4G/e9Lfekx2MFZ4
NVpxrY/iSK74VIvfe1WRS76rubIkMG1pp7DfRtv/6KqIraOqol7ET/Cpctnk
b3TOtDZwbqPxnHqLGT/9CzVubtgq9yIeUfedXR3rtdXhi9wfvr/IRC5OXVPs
enG6a15qDmwJu+A8j2gem4kcnVqGO5H3g8m3ZSKHJn9enEY+AT6QY5NfE09v
yUQuSG3S2/Ui36stjzqjRzZqC3Ih5D7OcZP4iS3+JyfiVH1N0P+VjH9fGfEv
lSxnF4VOWkvmP3dORW5FbUoeyTm/K4nYNrAqZM8dWH9H33hDfM6qjjrsW8dT
MAW8IecBD4htxLW+5aHnntnAB94daBzDh3ine3nEnJbZwMXdxvDP0siZqO/I
bTkbssBeyDfQ10Ln+eRj1B/UMj1da853PlNVEufHvl5PA9MnJeHfz9rHr6+N
HHhvReDQLmMmtScxrMz4BY6R2xCTd3ud2LLH+HlOUfDBrvAT/KXEe4hDvFta
GTniRsnwdHHUIWulqzsqIh+gxzDIvsYdV9fEHvayNts8wTNkjOz+Wh2Yd25p
6Jz9+cbT3cZq4jnvjPN5Pvb5yTE+8f2ICeSmRemZWoVYQI1CHlbodbBulHPs
babpmeyw3IgpO4y91DrbzJOYud17xptPoectpl8xzXeIrXstc2wBm8DGNjqn
aeqdkLuTt5PrQJPb1FmP3T12WkfkFJv9rYleL7Y8PrFMao0DnavD7sirsP8l
nYKuLI1cAjwAhw+aRs7kF+DwjCTqJ+gnXGsM8DnJtefbbuem4RPwaVYaPo6v
UzvSxwFPD/ndWc7bLzT/jyxH5N+vNPaCwdR79FLocRGT5/pdbA7bo+9CXdhP
9lrXPr5D7sv7xIYJ5vm96dGi/5aNHlznmtjLO8iZGrN5XtSPn+ZH/5Dv0jMg
b+OsvVpG3g6OkXuca7vq7f4bOMYeZExvBAyZaRsGx8Hzg0WBrY2urcAO/obG
v9kDztKTIPcCY29yH49a74DXwGvO2NznJG8Cx8Fz+jHIk7yX2Mk62E6tAQ5R
y6w1zTmRMbJGtvDLMU9iI/omttIPbu3eZYPvzrf2+9vTzfMz80VO9LVq7S/E
nR62r9W2MfpAdabJF4jf4Cz2W28b7tM+MBcswpb7mJ5rmxjoubdparpladR1
J8yTe1Czvuy7g5n0r8HPKaa7+L2lXifnJbaBvQtMs77Ae4hx5GPwzDePZd6D
zVO34Md1zieRLXJZ4TNw3j6OJX2lr2V5kStQv9AvBv97ZUMexB/y3rXWF/2n
evsg/cm3LdsTprGTobXRE+lSeabPxV2Om6a3gJ2+aZ745RrzRId8C5sk19xk
W9rkO3Nf7HpT091bRy6CXp4qjnyJvK+4NDAc7H/A/OntdywN/AGHKk3frhhd
VhNyKK0JuX7g71P7rvB56KO8Yr8Do8AvMAe7+tr0osrIj8aURT8WGybHI//5
yrLCfvfbbrHVBtPH7NvwJ4dpsA0vLAlc6NMpcPc76/HR4oiR48sjXzrkO2Kf
0Oidvfu8n97yQe+hH3PQ9j/X52ed/s1h6wJ/+8bnR0ffmCd9430+22zfhTqI
nnCjaWwB+wC7yBHIG7Br4uNK70EOr/q+i72nyS9W2c6JP/gp8aXAfRVsrKm3
gu+Ak6u8fq95cjZs/nPbGDUF9TYxtNw5JHbI+eixz0hi/tI6muN1aHLOAz4z
94UGA8G5D22fxFtsg5g4vCzqvOcrw4Y2W/70cV/zdy8wL/jgh1c5r+vvb2NL
4C7423TXm9xzHu6+yhjjyY3usTBYJ2dgvtF7vrL9NeEfdA/fg7ud7/eG+11s
AVvBHsgjWafGpNairzQ6if7iCPd7sVPstUmf0Mif/OVmn5+88oj7Ldu9jk6H
mWfTXYaZZm2Ye1jQQ71+d37EPOIdca+3awly716m8fWxPj82ix/2tk+wPsC2
f7tlcth7WO/m3/p+6CG0iNqGHJL6rat74wvcr8L3qBu6ef8X1h22NMW9kRLz
7G66TVno+in7bnf3T8ABzo+tYiNTMmEn++1X2N4Rr1MXr8pGPc/vSPXZqN/G
dYga6hH351dno0dwp9brstEL+GWHiLMNzjdW2gZ+6Huk4dv4TVISeTA1EP2A
ev9uSNwgFr7hWoj6ZWNVxJk6x0dqRvIbchu+QyzgW33kDy9RT+vuQ2piz8DK
yKHOcR41zLHjUFH8PkCPhv7M1dnoHbxeEX9fYb0wDzKNvga5N0idM9j2gFwH
OzfC38n/wBZ6t9Doi99Qyf+pA0a4p0du2c2/laB7epacn9p5qn9jynGtzG/P
xDNyZ/LqCvMfYT70YLBh+jDUOtRFTbUFNPkGPc+RPs/n1gV+tNc8ydPpnY80
T37XXebfdrkzsrjNOSF+ggzQdb1/v/isIuIltVqnmni/tiby2DrnCbx3v99t
tO3h1+tqYn1Sx8gZ2rlORHe8j36Z603zvdXmyW+x+Ct9DmyXnBgMATvHGzOx
oyubfnM3TrKX/twx9+joxZLbkN9Ta1CDcV9+s4LGN/mdtel3ws7mMdrYi60T
f4hHYM0k5zPgBTlCpiTqYvrx1DQTzRMZ9/V9sUvskxyHHgx5HnaAj5zybwfI
GHtGDlnzAVfBY74LjtH3wr/oN6ysiFqe31HRO1gwzTkz8ZuYhn7giX+19W+4
9A3ILclP4JPnvgf7OxZHv4bfyckZF/i+1EzQ2E87/z8H+PE79XLbNvIHa+5y
/rDZPNnf1zo6z+ckbzlluydXpw9EfwF/PG7MIu4TU8gziGvco5/lU+DYTcwn
h11imnySOEH+Tl601bojR1hsniftP+iOfH619x/yt8D//wHKHF2r
            "]], 
           PolygonBox[CompressedData["
1:eJwllUtslVUUhXd7W6D39pa29L/3tr3PFiRRsTE+BkJjxSgTI0FDgo6kE1Cr
pgyM+AJ6MYraJkJ8IAR8IFLKRIFS40hGQh8MfMaBCZoo0cSJEJ9Rv+UanGSf
f5+zz9prr73/2vBj9zzaGBGjrCbWxd6I95dGvJOO+B67UIs4yn6G1Yd9OR9R
bon4ORtxoBIxUY1YhO9ie8RhfM39ET92RIw1RGSSiFb2f7CfT0XcUIgYIeb1
xH4vE3FTLqIN/z/484BYxfmVPRHXEn9uMe9y/gveuKUtoovzTxYjFnNmhNjf
LIl4kFiznF8P8JOsOey3SxH7ODvKmbdKxiAsU3wbKPlNvf3Sooge4g/l7DvO
ug7/CG80YXe0RtTxHeRbJ/YJME0T/ywcbCPX5mYwke8F8F3m7Z/Av4A92RWx
AR4H+DZO/JuJ8QP8NLNehqs7yHeqMyLhfAr/CuJ9jO8Mb34C1nXEXNtsDsXl
4+Bpx9fJOpcYk7C1sw6A7c2S7SnwnRZ3ibn8m/tZ7n/X61oe5f4m9mPcX8r5
NtZ+7m4n/jJ8CWuWuztyxq6cXsV/iLUxzMFh8QfmhZRrptpdkzgX1Vi1vr+b
M02+cx/2I2Ba3eRvI9hrwNOSdo3KvPUVnK2hvj3sd4JlvmIupbluuPmS/Wr8
efzP4E8T85VwzTPYD/GtEV8WfLuIdzcYZuG3g29D3P2Q97alzekH2IPkMJ0x
BmHZx74h45rtxX6jZG6Ow+cp8K6tuNaH0Pvt2M/yXiFjzMJ+Z87aVsyN4F1Z
MtequWr/NWd6M8a8G20sRwMTbe4x9dpJ3phsMYZTiTUirainxrGb4LvQaM1I
O8tr1sr6ZRFb2JfRSxZ829HkuZo1Kq1Kw2eIt5sYf/Hen6w69nC3e0PfnmN/
F3hfoBdmyG8zWEfLjiWNS+vnE/eeNCKtiBNxI85P4zvY516tEyMH1r3cHwTP
reAbBl8VfG3sZ+nXEvZZ7qQz1ry0X4WjPfB3iVUAy22cqfP2eWIeKThH5SrN
rePsMc483+AYk9ifJq61ekS9MkgO+7PW3B7O99c8u+5Fn/3E+7ziWo5Tj88q
7hn1Tor708RaVfIs0IzSrJpLrL0c6+miYyjWb/C3E/42w+fWJZ6Jmo3v9jnX
CfgoF6xJabOV9Tqxnyq616RpaVs1+b827c5dMRX7d9Yu7LGqbc28q8G6g/vd
GWvqAtgudZmrK+TbyP2Paq7Frxrmec8AzQJp6MaCc1Au0vA894fynqWauZq9
D1SshW/FEfYTRc8ezWDN4tdKzkWalXZTeb8tDl4k11+6PFtV80re/wj9K1ST
K+z/zRmbNDID1k05114alBa3VMzdVmo+0m8MwqIe3gDegT7/a6QBaUEak9ak
oUrOd3RXPaHeWFH1v0E9dxX2QuJZIw7F5cNF114zUbOx3mVtaIZolvwHxizt
Gw==
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.34630653647951587`, 0.561869783539885, -0.09300833321771652], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmWmUldWVhr8aoKiBqqK4Y9W9de+lQBSiNjJFG9CIgstG7SQKAmoLDsig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            "]], 
           PolygonBox[CompressedData["
1:eJwll3t01nUdx78waFcHjGfPs2d7nu33DBBNLsG4BGyLhG2eEj1iMK4GZrIN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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.40941435128816545`, 0.6265942110072337, 0.023201349329684044`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmgmQVtWVx5/0StONptfv+/p9a7MouKBGooICsopoVETQRCamlG5AmjGp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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy+EJYRFikle8vJe3ssLm4CAUMCy74sgoFU2leKWQEAodoa1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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.4725221660968151, 0.6913186384745824, 0.13941103187708465`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmgmUlNWVx78gTXfT0A3dVdVdVV919RKjxKiIC4rGpVnU0aBGMWgmmXNE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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHl01NUVx5+BhMBAApJkMpPfzGRxlyUCgtthDShqQSxuWOk5KCCogCIo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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.5344153984288833, 0.632414937764123, 0.22786845191165522`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJw1mgmUVdWVhq9SUAMFNb2h6tUb6r1SITKoDIJGRGQQFaISuztxSBvjGCeU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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHeUVUUSxi8yyLwZmADvzcwL8x5vRkQFkQyiBAEJghIWXQO6SHaRPCQ5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            "]]}]}, {
         EdgeForm[], 
         LABColor[0.5960698932050656, 0.5492109711359444, 0.3108709049510919], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmgeU1FWWxv8K3TQdq7urukJXVXcVoqCIokRXZwwYMcE4KhKarC7qKIqC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            "]], 
           PolygonBox[CompressedData["
1:eJw1mXl4lNUVxj8JW5LJTMCZTGYyM8kMIqhI1QJBW7SIFQUXwJWCsoMt4kLB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            "]], 
           
           PolygonBox[{{7775, 3266, 7774, 5775, 5776}, {5831, 2210, 6556, 
            6505, 6506}, {7771, 7770, 7776, 3266, 5905}, {6769, 6768, 7754, 
            3255, 5898}, {7763, 7762, 7769, 3263, 5903}, {5776, 5775, 6555, 
            2210, 6557}, {7768, 3263, 7767, 5772, 5773}, {5904, 3265, 7772, 
            7770, 7771}, {6506, 6505, 6857, 2488, 6856}, {5899, 3256, 7756, 
            6768, 6769}, {5902, 3262, 7765, 7762, 7763}, {5773, 5772, 7755, 
            3256, 7757}}]}]}, {
         EdgeForm[], 
         LABColor[0.657724387981248, 0.4660070045077658, 0.3938733579905286], 
         
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFm3e4lNW1xkfgcAqcc+aUOVPOzJyZwRgVaww2jCW5IWADpdmlSOxYSJQo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            "]], 
           PolygonBox[CompressedData["
1:eJwtmXeY1NX1xr/szi67y5ZZ2KnMzO4MSggWMAYVsZFYKBKQqigdVCICAiIq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            "]], 
           
           PolygonBox[{{6826, 6825, 6829, 2470, 6828}, {5551, 2808, 7261, 
            6825, 6826}}]}]}, {
         EdgeForm[], 
         LABColor[
         0.7193788827574303, 0.38280303787958725`, 0.4768758110299652], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFnHm812Pax3+dOtU5nTrrbzu//XcqiTHGYMYyzIxBRSQzlUiisrUoMTPP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            "]], 
           PolygonBox[CompressedData["
1:eJwtmndglVXSxt+QhIT0kOSW3JJ7A4q9oOJSbOuqNCGI0gQUwQJCQBBdlbKo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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.7837296673483027, 0.2734886832801492, 0.44202609628551404`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNm3eclcXVxx+WbSwssOXu3rt3b92gYMGGJUosUWNsSMBKEWPUNyaxS0wU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            "]], 
           PolygonBox[CompressedData["
1:eJwtmnmAzuUWx39mM4yXiXnnnXde7yqFQqpbWW7UrdtNWS7ZRftNN0posaZS
aSVum/ZS2cYSlUS2SlGWpEVdSkIIYxi7+/nerz+emXN+5zznnGc7zznnedM3
3NFpQFYQBG34k8P/11NBUK9WEGRorwEH6SAYBzyeVgV4VkkQbKgaBMND8CSD
4KdIEIROC4ICWo9MEDQMB0EDeI/DswHeXrEgqF8d2fB3gbdGPAjGFATBv7OD
oBTaTHi+hbcv9Gzk/QBPYZ5l9kLe19jQC3lnQf8yEQSP06c98tbQ/zHgUbTc
LNv8Brx/Rf9q+reoFgQXlgbBz9Eg2JofBK3pMxTeBuibC/1ndE5B/jf0+Sw3
CG6g/3rgw/SZDq0D8g8Bdwqb9i0yViNrEjL6IKslOltCa8iclMN/Pfw5xUEQ
41sJ/F3hbwf/IPhvyfW3F5D/PHhP+jen/0XwnkPLAC+H50loSfo0pu8ryLwb
W2tAn4K9Hfn2d2gnkPEUsp7UHANfB30HfZdCXwr9I2QMRf4w2gLgRbQRwD1q
B8FC4E9oI8FH0ZYAHy9CdpUgGI2MaejLY07mFgbBI+AzkT8C+QdkC2t2rC62
Ql8DfRb0z6GPhH6wqm2W7beyfkOhtQe/HHx1ielbWI/P0XUQGQORdS3zlRvz
HGmusth8tzB/Bcz5uiyP8STyK2hFjL8W+6Evui+HpwP8c5HRPG4d0rUeHTnY
shX5N0DrjvyjyOqTcd/7Ge8y9L2JfWuwrzn76VxojWg/FXoPaC8MQMYD6F6G
zGXI7oW+LsA1kdE74zXQWnyHvhC8PaFfI/sZ32FobWmd8z3nvaF/z/hPVvWe
bQpeG/xextMG/JmMz4jOypXgjaD/wBwd59gNwZ562Ds9Yfhu2gzgrfAXIL8h
rQRdT4SNn0urH/UZ1FmsQdvIWG+OuO/lyC+jfxfoVaFVo/0IrS86zoTWkz3w
Ff3LmYM6eZ6D/cArJRPavpqMCfwM9FfkeU+eCVxOq4PuVsiIY8tb8NyLvuXQ
JwOfwxrNYD2Wsx6XMlc90Hd6dcuU7I/ov7mq16Ahtr1f4rPZjPlszPp9Cb4H
vBM6/gH/MHTsq+o9/572Gvjeqt6Tafp/AP8waMNpHwIvjXmvj2C9N8N/P/il
1e0z5Dv+SUvBu5fxDcPeJfT5FLwc+5cCVwmb9jX6v0T/4HpBMLYOaw99A/IO
cP7fQHd/+kxlftemfJb3Q1+X8ppobaZh48PIO405OB98sRq0hvi8DLwJ1qM/
9h/l2/vYNoT530H/dvTJom8283EE2irsHSt/yreVwNtT5n2Qb5+BF8B/O/I+
RP5jyJuGfR2wbw7nK4R9dfn2BfhK2qPYPw79vzA3A9Hfgb7XMN5K+rdGX0vm
/wtkjqlum2Rbd+jHtH+ht4J+BP2Pof9+ZJyJrON17StuYL1r0fcV9F+Orgno
nwS8Bf474b8PmfOhT2Z/FMB/H3v+LeDPsWEnY3saeTuxrxKdU7Lc5zf6ltOn
jL5ZyB+B/lvRuRDejtifpO8+dLyGvttYg3cZ783Yew99q2FvFfh/i3iudafp
bvsKecdyzbMzZZ8m39YZfAXwVGSuln+jfxq4Xdi0Cub3D/ku5rNrFZ+pbsAL
6XM59MtoHwMf4jxvZ/+UYvNV6JokHwLv5BrsHfZCU9oVyLqMb89Da0M7gP0H
aR9h6xHG0JXxdactBv8cGQ9V95qsAI5jw9n074+OCehqEbdvXMn8PAT9NNrv
2D6QNSsETtD2gh9g+I9E7UPkS0K0bYwvDd4U+GLkJ7TWjOFxxlKCfWcw189i
39+Al8CzJOpvomkPHIX3a76th1YPHSex9zfwFlmek0XQOzCeBYy9AeP5DPg7
2YRtY6Efhp7N/lmE7jzsH8N6FTI/5yHvJ/oMh/8b+MdBX47M+cj+D/YMzbNN
zwHfhc2PImsyfV6F/hTf9jPWVtCfBv6W/pE88xxC343I/BTZZ2PPKuDBYdtS
G/uro394yr6vHjq76X6GZzz869jPW7Dt4Zh99yrZC3wO/mEwd21t+W/GP51v
C4AbIf8L+rYPG1ZMo9hGMZFiI925ubIVng8YW3u+VQiOGNaaa+13ofMV9L9M
Owv6bvBXgfdgbwz6jeDHs/3t7ITnWHPdkPY58IWs1zPA3Zif9lGPWWNvTPsK
eA2tKfAA9HXA1iqshwJDrceL4GsTjhUO4wOHM9YE7ZzajnEU68wvse+XD5Yv
bkafOsgbAz6Yscyif1HId0B3xX+0xdCa8G219kPEvrUVe/lBZO+FfjTb5/1p
ZHUMm1c2ytYLGM+FeR7TRcAtaROB32b85yXsQ+RLbgOv5Gyk+TYR+CPWdC06
SsEfA38P/AvwKPjKHH+LAae053LcJ5Owj5Ovm4D9G7DtmpjvhrR8hu4S6END
3qPrYr5zdPfIh7dnPmKMqR7zNR56OmmfLN88Cvm1gGsmDL8F/wj4X5D8XJ+h
5ox9WYnvFt1Ruqt2sj5P0L+n4lXdjeBPg/cGPwH+NvvhSuT9g/Yt4/8T+lPQ
eyk+gv4qMprk+oysl6+C/jj0HtAPaO1oC/FvWax3b2zfmPLdIpt+BG6U8F7U
/quLra3Zw+vwP3t1/zL2j+PuW4XWi/5HGPM9Id+huksPyP+iK5s2Hl2f0Kdb
yD5Pvq8v9lyNbZXM13XA5afs1/hOwt8KfGt1r7nW/nz0byt0jPcD/QPdNwWe
k5PQy6FPwRf0gzSI8c7g26GQY6A+2PKx7nT6/sq38dB28W1qde/hPti7B31P
npq/Y9qPJebVHaq79ArdH8B/MB/FMfso+aoZfOuctA+WL56pMYJ3SRpWjK1Y
uy3ztazAMa5i3Rnwb8v2t6ugjU5YfyV9piftg+SLpLMbeAfdoQW+I/fR93nG
uLbAa9Izbp+qs6xvPeK+Q3W2VoB3BO9Pn1fz7MPkyz6Mem9fwx74QLFMxLo1
Z5q7SdhcNds+QL5gCfQeIa/hUWw9HLM/yqFNhLcf83VUa0ubqXgB+knlArTn
lGvF7Ju0J68Hboq8zTXsf7uCn4GOtuj6Bf4p4A+g49cavnOawTu12OdBfe6H
tuvUftb5OKz5ZbxlzHV95ZzYsgP6Y6f2+0HoPxXbtsO0MuxbDr1tgWNsxdqK
uRR7bZEPkC9NGtaYNfbKUueO6vMpffvT59Msn3md/S7yZ3mOGbKg3QlPPrxv
KqfGnt/Bx+Y4f9kPfTD4o4FjpCF1bZNse5Tx/Yyt94I3pe/timGAF/BtELTZ
7L9F2NIKnRPR3UzjYW8eYI371fCdqrtVOZlys/3IWIX+W2m9qzmHuYr1bsKY
1ubbZ8t3/zPuvSKffD39h8WcyyimPUO5T9SyNjHmTsr/inwW3oNeBt4O/lh1
x0SKjZSTKzffhfyXsP889G2Aty99epU651bu3Ykz+45iV/CvwCPcn9GwczTl
amPA7wg7JlNs1gb+CfIF4PvA+6HjMujXZpzLKcdRrtM941xINQfVHhTzKPZR
TF9BfNig1LHf35nfthHHPIp9UuirH3aMq1h3NuO5JOUcXLn4f1nDP4sd4yvW
X86cvMbcrigyr3Ji5cY9M87VtEe0V+Qj5SubsUYLmes5ijdyXDN4D7jylH9X
/hxIfsaxu3zk03H7NPm289GxhvlcA70fto+GZy3wS4zpskLH5C8DP4C8Z+Ff
zBgfBD5EG4f8PsivUuycTrmdYuq9aefQyqWV817N2EqhX1Tda6K1+T7iu013
oO7CpHIUxlqJjg1FjlEVq6oGcABdy5jfueh+F/v2KhePOhY9znxs1P7J2PZJ
2NSN+Yoibzf8u2hrkDWXOdmY5ZrMPOU3tCeYu6/g31TsnFa57RnQr6Vv75hh
+Qz5jv7Y0DOwDQPq2gbZojtiH/DF9L8512O8i741SuzLp9M6Mb409ufSdx88
yVLH1IqttzGGTcAvqmaBrE3Ysxd7Xsg41lfMqthVMaZiTcXYQ5jLZxnTw9Wc
8yr3fSvj3EY+YCrr+27GZ2Ei/QegfwA8N8I/D31z0Dc+41j3e/SN096KeC/c
wfp9wvr1pD2EretZ36ux5wR98uj/F/qfGXWOqVwzhvxBYdc0VNtQTvaZcktk
xpF/kjl/BPyJqNdGNYvHgWcXO9ZSjWkx81UEz1n0H4m8MPDEjM/mfeC9kq7R
qVa3BvzisHNK5Zbykd3CztmUuynnvSnsnEK5hXzSKvT9K23ZmxlP52LnrMpd
tec6w39jxGtxgLYT/oXoH3CaaxiqZSzQt3znSF8WOQZULDiHdinn+UnoE6Hf
yZhOMP/v6X7J95ofi5pHvFPYz2dBb1Lq2sU85BcD/wv92/NdE+sH/At9dub7
DpqIrs3gf4A3Z/3Px96B8OzI9xoNAr4k41xQOYFyA/lQ+dK5tJlRx7CKZXUm
dDa+Af+4pu8r1Yo2g39W02PQWF5UTY3zsIxvk1LOkZQrqUYwVf5O5zXHfTpD
/zjjWojmbJHypyKf5U+gt1etKOazNhf8b+Czo96LUxjfg+jfyHx9kO8cNQFt
ZZF5Neeae9WAVQuWzVfT/yLGeCn6diHzEH3HymcVuqah2sYJ+E+cihee1/7E
5rcLXQNSLegVZAzO9bcj0DqlPNYT2Pwjul9N2XeLR7zP0W7KtY7d8F8dc64+
DLwt8EToNWs5Bi5C/vMp3z3qo74v0+rW8pyeDr087bv4CfrvB56ZcS1dNbEy
4CER50JaY611C87AhJBzGOUyXeMem2KibsATwo6dFCMfUr4RN66YqgvwU2HH
b0doe2I+kzqbUeW4wOsTvvunq74B/ey49+o88Jby/WHr05weg/5k2L73dfDf
VQ/CprKQY5J3in0H6i5UjLgh6jnSXC2Gpx+8K5RTMrZF8v8lzgmUG7zE+dmp
88m3H/LsE+QbjjFH0wp9RnRWZjOfjyJ/Ht/yVavMGFaNULXC60ocu2lPXcX5
Oh52LqCcYC/j+TNuXHfkHuAjYcfqipl3Q5+T8lmTDuk6i/ZMTd+Bo9gfcfBH
avpOuBN8fsS5jM58ecI+VL5UNYwQtOv5tqyGawh1wI+mXXvUmI4Df8CYX8vx
ng7gHRd2rqP4qYK5eTnp2EcxnGK5GxKuhQ2k/xL6j2c+n8t3TKfYTjUIxcKb
wBujr3bEvLJBtjQp9trpztLd1Slufdo/nYFfCDv+1/4KmI+cpN9eVANTLUx3
mu42rXmIuW5Nnw/ZL6vhHxtzTqrcdKRyeHg3RbzXlGPeknENUrXIdtDfj/iN
Qm8VujO2gN9V4thQOcMg4F8ivmtU01Vt921kLA35TWJyxjGxYmPZcDG2lMVc
m1BOpNxIPka+Rm9KBdDHgs+q6jPVPOk3DL1lXIANs1K+o3VXz4YnVeoamWpl
erN6R/4u5rcT1RxVe5yRdq7fmTkuAz4vbFny2fLdLxRZlu5Q3aVNoJ9dyzV/
1f41Z5o7fZuC/HdjjkXXM+Z3gL9L21e0w6aOEcfsit21B+vCPx16x0Lv0Ubg
q4pti76JNjztt5MG4COBVyb8VjZf8TDrWz/ptVKNTbW27XHnOsqJdgBXhI0r
B9oG/x9x50rKoXYC/x53LvJ/OvCuuM+Tzttu4Mqw+SXvD/qvK3UsuYT2DfCB
lGNzveHoLWdE2rbqjU5vdfWSfktUTU61Oflo+eq+8MyFt0/EtVy92U1JOKZQ
bPFv9tsc5uL6iGvveuOblnDNSLUj1dSTyK4otizVXFV7HYrMeuD1adcVuwat
WnRrbJiKrHPg2QJtK+0N8ArGeEmhc6aDcdd0VdtdyLdh0EsSzsXkX6Yhbxrf
dhf6DU5vcb8m7Jv1rQWyW8NztJbvjJeQ1Qp8dy3fMRPAh6OjvMAx7Ghs7c0Y
5oVc81PtTz5VvlU1b9W+76B9GnLOpNzpNvAlIdesK5iH25PeWzpT/ZOOGRU7
qs+dwFdG/bainE+53+slzlX05qW3r17YkFPomr9q/z3Sjh31rTdwi7DfQr8E
jzO+9aVee9VIE4x9RcK1R9VAVQvVm4PeHpSTbUf3wSLfHbJZto9K2Ldp/40E
fpOWFXIN7jfsubnYvks14u6qXyRcG9Ybjt5yVJNUbXIp+Dpoj0Rsm9489Pax
J2HfpJrmnwnHaIrVlCOFS/2mrLfl+azBJch/XfkXvmgFfQZh32DaFyHb1Dni
N1W9rSqnUm51hDMwpMD5nd5GD9f127C+HQVuE7dsvaHrLf3gqfqmfPQz8B85
VQ/THf8f8ENpx656M6xM+81UuZ9qWhXI+1XyC1xTO5zxm6fOq75tgXYFMr4L
+c5tgb5LmL/pGhvzNzzmGFyxuPbYtUnXsFXLngdPK2ztFPHYNWaNvWXcNL3Z
6+1ePky+bINqvKo/lDiWb8WeaBV2jUa1GtnwMPQI+OgC1wDa6y0j6b7y2fLd
eiPUW6FqPKr1PBfxWqqGoVpGVtq/RdAbsd6Ky+POVZUj7wduqBw+12/4w1i7
eVHXrvTt/ahrSLo/9ZuEnjHnZMrNKlm/S5m/HcXOnfSmfyb9tyccG5VDvxh6
Snd6LZ/RsrBrkqpN6ls67Rq84h29scSB30g4l9ce0l4anPLbgGKkIaoVRh3L
K4dTLiefI9+jGuZ56KuS8tuZanpZwCfjzkUUUzRE/qG4faFsvEl3v95cCu3D
5MvmRGy7fKbe/hsmHIspfmyQcE1YteE28EyWb0ra1+sN/Rjwjqh/qyCZzZC3
MeG3c/lE+cZzE37LUs38v/RvnPHanw69CXDvUtdyVPNT7a9dyrmDcuI64GUl
fruXT5Rv/Drhtwi9Ceht4Ja0c7tC+WDgPcWurejNTG9nxxJ+G1PNVrXbkphr
A9pj2mvy8fL1yqmHY0uDqHPd/58B3Q3FtlV3gu6GB2J+K9eb9eiYz4jOit6M
R2gvJ3xXqOYwsMR3gO4C5XS/IvuCmHMXxWwX6u0n4r2lNz297SnmVuytmvVf
6zomV2yuGvPumO9s3d2qCQ4EPj/htwzlZMrN7laNOttv7vcAzy7xbxF0h+gu
uTXtudIbrt5y74VnUbbf9O7Tfo/bf6jGsw/4xbTXXr9BGYP9/wNq5W1s
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.8482323990363376, 0.16270290018797348`, 0.40053492382703043`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmgmUlNWVx79u6G5ourrppbqquuiq7jIwGseoQSOKGHU8yYyKCsqiKCru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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHl01NUVxx8JhExICEQnM0nITGZoKUsVECyBHKlYBEWWshUk7JsLUlTq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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.9735241229755421, -0.05249018370661607, 0.31994142972937545`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJw1lk1slVUQhs9ttT/U0t7e3ns/S+LX9q6sKEpAqP9G0NLSRGuMGk3Eoi6E
qFt/twp1byItdiExEYlaIIZGgyXRBRv/EoJtoyklUdRQoG40Jvg+fadJv5y5
c+acmXln5j3tGX155KW6lNIP+ur1tXSk1Nye0rCUpxtSmm1M6UmtRzPL5XJK
0/r9s+TjOvC57G+XPCfdjL45ydPST8n+rOR22Z9qsNyv9Y+2lP7U9498LUq3
S7aPytcl6c5IfryQ0rnQ/Subb7pTWtC5+3XfjpLPc7ZDMRb1PV3wyu9XdOai
9j+U7qC+h2o+e5/OjlVTOnJtSjf0prQkm6GSbQdLlvH7q2zvarZvYvyi3r7I
cV57I9LPhL8DWkeLirXRe/1d9r9T+U7qvtlW6/9qc8zfy/6y7C9Inig4l4GS
fy/K7rzuWZS/o/oK16R0uOBYwIh4HpE81WiszzU4rz3SH1Buz+hMf2Z839P+
VZ39Tv436swJ6dau8z1fymacPX1/J+NxpSmlvbrnl+slS9+j+O/O7Pvd3DmQ
IzUZyy0PlB0v54mZOFifKHgfHLEn3v9a3RttNdd3uJLSw5EzOXyW2+bFzH3T
p7ue0j15r30Mytcx6YeajE1/5Fune7bom5K8PXNt8EnPPFs0/nPRj1ua3cv4
XI2XO8ABPKgp9VzQ2aGy60g9F+IM9vQw+IJtY829caf87+lJqVP98Jjk9cKj
FD2JX3ySUyn6Ez21p7bEST6HQ8d+Z/TwcsHnwOGIcNik+G9Rjvuqrle3dH2Z
azseK7Umn48iJ/2tYLMcuYEHfQkmG3Tma2ZKNd/Q5d7My9bhizP4Od/g3jjc
6/tvzDz3m5uNBzyBvyvJPg4FhsweM/iT5LUdjoN9akhvk/fvwuuM5N+0Thas
A4edTbaj5q/l7uPXtb6p70fJb2ndn7vH7lE87+TObV/u+qNnXpi5HTFfhwID
8OQ3c4dPVmyY8VUuIG7mHazo/c1V13VTzTERJ2dPBseQI3h/EJhv7TJ3Pig8
D2bG8IHMPTgbPbG9bBtsdxdj9htcPziV2ewou8foNTAHb/bWtBt3MIfHiJu5
RX9d8Patmbn4E9Wtu+z6Uufesm2Z9Y97zePr4dWyZ/LbbmM3Ef2JvCvqsq3m
d6Ag+5RZRnex6rlYqpo7VmKpOWdyH6g5Xt4VcJoPbmBe6a299cZxtGp5Qufa
KpZXdHXeh1uIEbwW4z1gPuF4ehAf3A+/w0v7q67JeHDdzZlzaV3n2T8ReIMR
WN2m/TdyzwDzAcfTu/QNvAl/fqX1psy4gV9HzXhTT3gFv6s5LRcdN3njjzjg
bnqL3OlZ3o/5eDenY1Y3ls2T8CU9iD0zm0cdm6TvrJkn4Cr6eTI45NXcefVF
jMeD4+orzh0M6Bdio07Uhhpty/wG0k+8g+xjR/zoB+OtLETdn8ucL7lSlxWe
iN/sf9poHh/L/Aa836lZVQyXdcdwj+f7hWZzwb2ZZ5aZZmYvxFtJPddEP1OH
YnDj8z3u85GK4zsZvQHHUDswZMaIgxha4h7mBb5pCZn74H04mbiWYo7A7Gr0
DPWaiv9tlqLPdyvet3O/Mcd6/fbge2vFsfPGEz98scIbVWOPfiJ4/XTERm8t
By/h91S8L/Dr2Zh5OA9OJjdivBQ1QjcT+cLN09HPd1T8P8eQcPofmT12Qg==

            "]], 
           PolygonBox[CompressedData["
1:eJwtk8tvjGEUxh8d2k5HO5fO9/mqi286sxKNVKOp0gslgs6gTS2s0JZFCbau
W6q2InH7B6Qh4xYSCQu2xKKhXYiyEBW0thZ+J8fiJOf2nstznrdt7PTIqRpJ
A8hK5EUkfamTepNSH/pO5GuttFwvTa2RekJpMS19R/a2SUEgzZHfTX7nWmkX
doWCqzPSMeKpkvQnK51MSGneno+lt43SM2qeRR/GlyJ3lubf0B8VpaPkzxPv
pff2FuklepX33cQnqZkjvxkZxZ7Absh4Das1SP4Qs5aRHS1ew2r9pecD+iWZ
Z4n6R6iXIL8P+c0uv5AytUZCn91qWu3JyN9W2XEa/THzjfF+Dt8V6mXZ9yOx
5/RYT3xz6LM25cCGXuvwdSZ953Pkb8P+TO4CMoi+AdlE/D3xi8SvxY79J+ID
xDrAtCvpPaxXf+SxBZsndswN+3nskPhVbjSzipthx8x6KfbahuEF9PbIZ7WZ
7hGvsOMSuy+vkIq8H8L+gf0OuxD4je3W5tsSOkaGlb3px35TkA6kfafX6DX4
DrN/iv2b2X9/Xjqe9JvYbTbS/1Wt7zxD/4aS9zaOGFemYsfWOHAZ/U7k3DEO
3kW/Tr377HYIW5FjbFifgXN59HF8PcQ+kFNFn4g81zj6EH134NjZDe2WFead
TTgHjAtbkacJ57hx3TA1bG3mDt6Xg/+94McJsLgdOZdt51voN/POlWH2q3Cb
fdg36nymn9ymvuTYGgeNi42tzkX7c02tjplhZ38oh54JfBfjgHHhCTOPZx3z
PXafwG9tPosdDH02+yP2V+yP2F9phxNd9C8U/S8bR6ax/wF5eIbJ
            "]]}]}}, {{}, 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{5198, 6126, 6127, 6243, 6322, 5392, 6704, 5393, 6187, 
            8874, 6188, 8875, 6185, 8058, 8059, 8057, 6186, 6300, 6299, 6201, 
            5634, 8979, 8978, 5445, 6712, 5446, 8549, 5714, 8548, 5713, 5864, 
            5863}], 
           LineBox[{5199, 6466, 6467}], 
           
           LineBox[{5269, 6144, 9028, 6145, 6244, 6323, 5397, 6706, 5398, 
            6192, 8876, 6193, 8877, 6190, 8061, 8062, 8060, 6191, 6465, 5687, 
            6213, 5688, 8981, 8980, 5451, 6713, 5452, 8555, 5717, 8554, 5716, 
            5941, 9012, 5940}], 
           
           LineBox[{5394, 8967, 5691, 5689, 8522, 5690, 8523, 5408, 6703, 
            5407, 8968, 8969, 5635, 6189, 6925, 6926, 6332, 6333, 6205, 8076, 
            6207, 8074, 6206, 8075, 5448, 8885, 8072, 8073, 8071, 8884, 6204, 
            8112, 6250, 6283, 5274, 6733}], 
           
           LineBox[{5426, 8975, 5709, 5693, 8524, 5694, 8525, 5410, 6622, 
            5409, 8970, 8971, 5647, 5986, 6301, 6302, 6211, 9032, 6212, 6025, 
            8736, 6027, 8734, 6026, 8735, 5450, 8886, 5449, 8390, 8389, 6209, 
            9031, 6208, 6210}]}, "0"], Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwV0ttPz3Ecx/F3m/9ARZRUQ2UOV6G2RmvMhS5kc+HcHG+YmWxsNmeGyoqU
TZfK6ULJxGaZkbnA5jB3cpiKVZSlcnr8Lp57fV/vz/vz+rw/n98vq2LXyp1J
EdGDyskRmWkRB1MixtIjxjGKCakReVkRz6zPmhbRy8+kfbQmO+IczqIaVXiV
HNGkt2BSxMapEZtQgTLZCzIjFqIAhViEU3qP0mO4oq8ZpWb4or8HJ+Wkyz1B
M2ihtc/qRfSS3kbcNk8bdsvqplf13lX/OD3iE0b03+fvoQPXrBfK+qB3gK+S
1U+r6SC9ZZZhWsMP0XP0J21V/0Vr+RFaR0dprpw8fPUm6Xy+79n4xq+1Zx3W
oM6Ztegzzwp7u8z2BNlqWdifyPPWY7is3oQZap36L1ivx3k04CLmyR9Afo75
6UN9G/Wn8a3ueMB3d+L9+D2J3zVxrjdazpfR99YemrcTDxL35ovl9pj9N3/B
nnFaT//QNncI/4kG/l/i7WkS3594R7Tb/1i9x9y9GHfeU74LT3DH+qC+YQxh
ibM61BbTe7SEDrpHI51ovhUyyvDaf6pU1huaKeeRtXJnF02JWEW3e68d2Ipy
+7fRt3r/yknRm4wiLHXvQrrMng2+j7tPi7yZvkvsm58RcYg/nKjpuWnGLea6
Qa/jiPpmPoe+k3/aTGfQbm+xWVbLfu7Ml3iBvXyKeirmYg7a1Vqs5dJ+cw6g
RfZ6uc30Oz+IDOf/0LPPWZX4D9JdnUg=
            "]], 
           LineBox[CompressedData["
1:eJwV0ktQiFEYxvE3MypkxsIlIsVYlIVLzWjRxsqmhe43952h5DZSzFhZtbHK
ggWGUhQZt9ZsbIxqRtdhFalE92YYfi3+85z3Oe95zvud+TJPnSuqTYiIL7iZ
GrFrc0TThoh3WyPeY2FLxCKWcGt9RGN6RNamiAaaTV/pf4nXeIPdvKK0iGKU
4AMvQV5jRkSh+rpz17BuY8Tctoh5zGKIN4j9OyIeyBiwzrXOwX31XnqP7qNj
MruRJ/e2zGa80N+FTrkz8qaRwk9QL/qODvqb9wtr+KFe4D+lU7yfWM3/J3Oa
/4Q/yZvAKv4f/hS/nZ/qnhHasT1imHbS097uiDeqRo45z/HqUItWM7fgo5mL
5PR5i15k87LQ7WwSTcZzfhdy9X3Vn0OfqTuRaH8lSuVXm6kKZdijvmGmNrOM
m/cHkvlLzk6Y+TF/jPcdSfx5/hi/lf+NN4pE/gx/lN/CLzH3WnMV0RRaTN+a
p1dfDzLU/e49uNP3qDPVadY1MqrMOGSvkg4vz0oHaAUdpKW0HGU4JHOFM6Uy
CtyTKqNcne8dK2h1pndFJQrMVUUvyDig7yI9j8vIU19a/j+cOWY9Ie8onaTj
6PM+vejwjvn8Zr09y/+i9SfapKeO126Gv/7zh2Z7hDO+qwZnUWi/3/2H6Wc6
g2mcUF+xX4+7uIMGeSO+7fhypvyTtI3O6Z9Fujkz7V/VV4//gy6S8A==
            "]]}, 
          RowBox[{"-", "1200"}]], Annotation[#, -1200, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1nmQz3Ucx/GPo6YJSeRae9lyFJJMcivTtcqxkhxZ5UhNVrXrn7I2u0k0
phwVoSJqklyZkWEdmXEuFlmVhoqOSZqwWGuPHp/pj+e8vu/j836/P5/v8ful
PjspI6tGCCG/ZggXEkLIbR7CwMQQaqWE8EGjEAa5fqZxCJfF5t4aQp54Bt9g
PMtfzv8e/zT+J/iGYAx/u6QQztEE8UQkYUazEE5hTJMQztKy1BCu4DJuaap+
yxBek9dKbEZaCA2s3+76E7GlGMEeKedpXDDfRWTpvVPOJHqJXYpM8VHYqdZj
YvlqDbf2qutd6uzGWTNcMeu62EPeelrGHkur2AvUK7CnJ/mGYhz/U7RmC2eD
6WLD2Dfot8A5DXfdW89v1D1v75voBfq1dRX6ViLVmmSkYJYZFlpXxd8abXC/
3CnxHqCNmafS15GHZfosxSdYo89qjNfjU/ZyrEAnNTdhI77BC+LXnG0lKvAc
+3ncq/YE+qCete1ztdzeei9WYwlu40tTP41+yF6EQcjAj2beoFap/EVyLtFO
9nmSNqMJaI698h6Qf6dzaYfuzqwneqB7cgj3yOmMNvY2WN7P8mebp0puNdry
b1QzyLlo1vtoGbsz/73ognflz8Fm/q3OtIU6iXhJrYn6ZOFb/p3416zn43OD
bPFiM2y3j7pqb6P16AA9dmE39mCVHntpY+fV31kcVHsfez8mqf0yXsIU59cr
3n/MtOYLeR3kf89/F32bbxbuF++Dtfwt9U/DMf4y+a/I+9heVprlyziPHvVx
E3Ll3yb3dhyXf1V+jvwb7WsyrWC3ErsW92/WctqaXSL3K7VWo8gZraJ3xHuC
PGeQb/YCHFHnKL5Dkn7JOC1/qBr19X5YfmO1hrEPWbfanGuwFlni6+k6FLiu
Y3910Ty+e9Ydlf8bf1PxP+if+Mn1Ccw2++/s9nr11bsD7cX/irXNxfa6bkYX
xG8Rzpn/b8x0D+tYN4tuiLXic4kf4vvhPi60vqt1Z8S28hViC14T+5XvF8w3
V7qemeoMoqNpP3rCDEniiZgn55Lz6WPtZXqduqX0IgJftfM477pKr1pilfTf
aPP/Q6+xa/CX03PsafGZis++e9TJLF+5HiWeiQP6PU1HIl/e3eIH+appEe1A
1/I/Fe8D9vPlmmEKhrLbi+eJT8VZvcr0rLafK/QvdqVef9JL7Er+UvpHnJG/
Amdcd1Prt+gTPx1rON9f6VU611mUy8sxe4leT/AdpwXsZP62mMh3hi+4RzVQ
E3XUqla3CpU4Lf6ivBnO+y2cZI9jn6Lj6WfO/5jnZwX90Prp9tnRrLPjN1lO
sRqHcQT9rN+JHfgW6diixlYUohW7Na43Y101HlKrHl3H10P9eWrMRyO+2vIb
0pFyt+g/ghbSzVjmTJci2x6z+DPMkeN6cPz+8p9RK4W2RCoOO6tm5i2mTWkT
9Mfj8V3n6xffDaTjeXVqqXmZ/wXXpXSl+VLRxtml61ES3zO5E9FRbhrfPmeT
Y/bJ2C2+BynWTFAjmS63n5Vmz3H/JiMbK9jL4++2GXfE31x1nnHdkI6hRTiA
g1ij1yHaRL+BzqXY9YD4WxG/KeinTjoetPeutBve4P/cPG3llZjhDvom33T0
iL8BWMNfy4y1cYD/rPxx8T2x17G0KD7bmCc+Fzvib5je22g53U4r6BY6R3yg
eu/SAXS7Pb+jR6a9jkaqPabE75+6SXSK2DT6qplbqHGKNtSrrxn2O/fNznAf
bcB3M55Udwhy4zc2vkOoH7/j8vfIOxT/S9AiegCDrc+I3y/X2ZhhT7WtWRT7
O8dsaxdam8B+XN74+HtvnqnIRU/+Ltb0og3kd1Fjc3xW2e3trUP8fyQv07pX
6ei4Xv77Ztgn7xE1H8WE+C2j6Rhp7VZ9C7HYmiX4CIviO2qWmhjgXM6Ln2z5
/3/A/wD4D5NL
            "]]}, 
          RowBox[{"-", "2400"}]], Annotation[#, -2400, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1nds10UYx/Gj0JZZWvYoGwvBhUGICMhWKlg2bVBkIwi2IDPGACIQE1Gk
UIjGFUBQhqiAJqCWaUSGQBgtu8ww1BijIiD4uvjHO5975j133+9vNBqR1y+3
VAghKyGEmU1COFE7hKUNQ7jcKIScmiFM4tvEblM9hEV1Q2jGzqoRwhDx5/FM
vRBS+VqLZ1kfqBVCqzohPIrh1m1oa6zX61L9EC6iDf8XjUPYqO8F9jqxd/Re
iLcxjf0l/+YGIfSpFsI5uYnpIZylSXSmfmVpGfXJtK+cCrQiZoul0ESxSrSf
WCpNwxyxqjRJrArtL3bVLNfiPM7UXfw56yz6LO1GB8i5ZpZNZroaZ6LXaUuz
5ZnnCjvJPSSjLCqqSaRlUBqD9Dkgbwp9md6QX5G/ElJQTX4aTUVl/CI+WV5r
/Vtgrru9zJfLd4nOYH/NP9Bc5/lqOEcJrUnn6lWbJjtfLTpITl2ajvli9Wk5
sXr0gpps8W/0etB5fnf+hu6+t3gfvOE9KBJvzNcID8t5CKfi81Nb2vOeJW8m
Wqpta/blzjghnpm9h/8nvMTOxT7r/diLbPG8+P7o0cFcQ+ll/iv4zBkL9V9o
rnP2+pR9hq6mZ+lAc502V/CulcLd+Kz1u0cfoWl81WkKrUGPmukIStQM0L+F
s4zCSCTadzQdg1ZojYvyFtrjEs2W/xhfe/u2wzz9buq1Rd0yOVvpcvuswC7n
yJLTB33RSd1ies9Zruu1xLpHrGVn0q10kTM1p4tpBs2nzehx8QSayy5F82jp
+KzpR7SueJ7ZJmISOpllAN8+sYF0Pz0tdyQdhWEYgeEoFh9Lx+EFjMeL2C+/
qjvvZd0TY52tgD2O1vHOLbH+2ZlSaWUscxeV7HtQfA09RNPo+/yv0TlIsddg
uak0h/Ywaya+FfsOE/kL6feoqG6tnArxPWTnifVxp70xxrpx7CfWid0ZTdlN
UMu+U9VNw2Z5m9BfvBzNoOXjZ9u7VqR2Az1Or9MhznvEc1vJ3si+TL+il+ib
zr8Ax3AUaXrs8vzmq1nlDnY5Q1f7XrB/F7pDbCcKsR3bsFHsE7krsQLz4vef
/S7iB+9Dx/jdZ11GrMS7ew7n2bvFnhArsU4QO81/KsbjOybWQeysdRAr5r9j
viJ6hm+n+G32e+Ztab90M9TFfOwQe5f/Af467FvyasfPkrrtYu31PRU/T+7s
kH4HcZK9Tayd2AnrO2L7+fehmF0o1lasyPqW2B7+v/X9kR7jO44T7rOG+yim
U71HNa2n0fPmmE5fUR/c4WDr5p5hUzUZ8V7Y99EUsbnmrEzz5S7CRc/pAtY5
z3pk6t1F7tO0K10vZx16snPkrbVegx7sbPb9dC/NMMM0/umYgdftc8eZyulR
HsmoJLcsPWm2Imc8jqM4bJ5z8XNqzrP0T3WZnklj63b6PI5uaqo6b7X42RdL
o6n4WOwP+ZPt+RT/VL4pEX2XqM/Hbjk77bHK3qvxlnkXYJF5Rskdjc5qC2gw
ww39llrnxu9cTEBtfT70PJY452/xd532skcB/ZXdXP97eo5n36UTaIi/sfSD
+JuifoQ+IzEKHdUMp8MwFInytsTfuvg95awJuBvnoffoyNhfTbDnDjn/8j2p
b/c4E38+Rsi5Fn8rnOUf8Zv4C5+rWYc12CCnQfy9iO97/L61Xokqam7Hdw+H
zHoYye4ngZ1Ey9Ac97JYj3w0UF9PXUM6Ve0UpOvd1xy58meJ5dHZtCN/oble
NfdE95uH7PgZFivgL1YzqOb//5n+A8J/WFY=
            "]]}, 
          RowBox[{"-", "3600"}]], Annotation[#, -3600, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1XtMV3UcxvFvNZ0iiCEKeEsuLpvadeVlq7Zq81azSbUICUHN8pKhm6hQ
qECpqXPTWluZ1NLWlq3VWppK/VF51wWIKCnaRRABQQ2CLut11h9vn/N5vp/b
Oed3MDV/ycyXbwoh1PknZlgI64aEMGt4CDmYPziEeN57g0LYwH+el4sX+Yn8
7fyN/Nm8PLzEH8R/n7+Zn8+bgwX8lhEhtOL7oSH8gDw561NCGHtbCOMwBnfh
ThQ6OyunHnU4g+XRDvKnOJ+KyZiOaVio/xBzd8jZYu5cM+dhEf9KcggV/Ha1
HdgovpQWwruJIcwQL5bzJL1G77bfdXoPLVaTG90bRqbbl76AeZijttLcA9Gu
ei1HoboydeUoxYnUEI7jZ7lviMcnhfA6XY91WCG/yI4r6Sr6rV7xdKA4jibS
AXStPbLtt4ZW231c9MxwUu9N+mzGA/hK3KVmvOu9dBLtofvs200ninPVdenx
kOtu+h3/r0jl9NB5zqc6i7FrAa8ffUK8Sd6zNF6cSfvTZ+hietC9H0LbyBCu
YqE9+6pdRDvE7ch0PhM/eY/3m5GmXx85qfQ+cabZb7v/Bz3no3pOk3uMJkTv
2nV/ekQcSw/TOLpcXSz2RvvQquh50Vf1iKfFKMFq/K1mjHljMQLDUcRPsmOB
nVY532vPb7APnzr7h1dk9r+0mK614yPqas3Z7Xyr570NGeaPQjqmq52GKu98
sJokDEIKkqMeeq21eynW4EveF6iU/47+5ShDjjlv2q1SzzI1Q+WU0knu7QBv
It1PG/zmr8nrlN9Bz4u79a2n7eIb/KvRtyT+k3+atomv8VtprbiLf4q2RN8I
/wqtEXfyq2mzuI1/mVaJ/+CfpE3iFn4jPSG+wT9KL4mb+b/TI+Lr/IP0N3ET
/1f6o7jQ/ve6jxXR74je7v6OeZ6j6UreBnnDxOtphvN038JO/kc4y6/HGZyL
vjE8pe4i/QXncQEN6PFsq2kNqlCLU5ghf6ndRnneBTSDppox2vuttecdNE28
zvw67/s15yWY6HpC9LvS93OckHscJ+Un2O04XUbT9F9CU6M5tEjuZ1joeqs+
Sfze+uSb3YuucHZEn0NYID6oz3a6heaquVV+Nh1Ac+jj6sr8LspRgjVYjZvV
z7dzq99hC6bwJkffqJlL3fcydPK7UCDvqLNX6GHn+RiiPgWFrqud1aAKWeKH
+ZX2ecte+2mXPSrt86jzA/SxaE7099i9tLluxRXsVvcJcrz3RvFlNGGuvAqk
2CUZg+1WYpckupr29vz7mnML7UN70efM2WVuNv2YZtHL8pvRiFniJhqnfyxm
u85DLuYgH0/rfdq8OgwUJyARe+yeZZ/x6nbpcy761lxPwE5xg/wLuIhOzyBL
nz3+fnyNCvUf4EPsQIycfsiO7mHY//+3/gcihSvZ
            "]]}, 
          RowBox[{"-", "4800"}]], Annotation[#, -4800, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1XtM12UUx/HH2VXzxiQRpAIvhDILEkSLRCuzFENmN4empqZlSgxnudLW
bcsrdkODVtjWQmdGaXERTQUUL5SR9kdbUmnl0gybNbewXt/1x9vPc87nPOd5
vuf75WfS7MUFi7qEELb45/nEENoTQnj22hBmDQjh41j5+BDmWp9JDmEOLVWT
fn0Iv/YL4cJ1IZymGeIGe3qp7Y2H4kLoSXugD2JQ0jeEZfJx1v3wkt4lSSEs
wVMotH+eXFfeZZiu9gp6OfY74wXnv4ikG0JIxhb9lmDSwBDyMBGF7jMNMzED
6/Qs7x9CBRagRa/5tCsW4j39KvGo+8/DXMQ5a5G98XQh7U+fpBNoGX3COQnW
je48gBbJtTqnUr9i92qSP4D9aMZi8xxuTxH9Vs0r0V3te8e+PFpOJ9EK+rfn
uceeVDMeihutU9BmLqV0PU64YzteVpuj3xr6s/gU3uK/iTT3yXfeM+5zif+T
Wf5Ld+v5BXZhk5oPvM/jev9iLnvkMtR/rm6vdRVvM07z9olv4dXwGq23yn+E
33hN4hG8Wl6zdbX8JzgbvTdxJq+Od8B6h/xnOMdrEWfx6nkHrWvl69DBOyQe
ydvJO2zdIL8Lf/KOiLN5DbxW673y+3CB96U41Xy/ovPp+56xzDyOitvwNXI9
70nzGEs3mVEl8tVtULcRHeZ4HqX6x/s27pPLx2QUYAq6qY+1b4J+nWpao/dm
fYSOd7e7sMD5P6irVv8jTYy+R+u1yHZ+tX0XvfdY+W/47+rXRqu806O0Xn45
v4Y+R+uiWP9t6B69az0OyF+lvo/4SrqMtzW6tzgBGXJtarLoCDzumSdHz4Q8
TEE+jqlpoQfRiGY0YZszp+J+FOBhPIjV7jcx+m5RZO730qXOveROxXQz9sjv
jv6WeV2x255c2klz6D90DD0U/Xao24m6CPku8jV0rTunR38/+EucKX/eXQvl
l4tXi0eJV9JsuoqecHaMd/E9TbFvCGLUjjP3OzAGY5GLofrcSm/DaNyOHFSZ
0yjf1Id0NM2MvnF8p+cg/QZjjrvGqj3uzDSzqnD+p/LbcV7fjeJjvHI6jP82
LfZN7PS8s/U5KXcKvX0rI52xXr+s6CzM4v9hlh3Y4e7n6Dh7f6czeWV6bIh+
r8R32zce29WdFZ/BI2pu1qeX3ul0Hf8mOhwzeMNoT14aXcMbSlMxnTeE9uCl
0FW8wXQQCnnJ9BreQPoqr9J8VrhXkrg+eq7o99WcHsNFTDWHN8zjdbyGpWbQ
zTN3x9V4Ovrd03ca6uyvxRL5ErR7nr723Om8w/wH9OrUc0Xi//9P/QfdSgJh

            "]]}, 
          RowBox[{"-", "6000"}]], Annotation[#, -6000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1FtM13UYx/EvrjLMlQqCIHjIQwdzKqB54aKluelF5qE2x9QNFSuTo5jO
WdJmN21BlsycIGLgcTM7iJvMABdtuRm2TDMO+sd5oBNd1FY3+frOi7ef5/n8
nuf5Hvz+mVhYsqw4KYSwxj+No0OozQxhU3YIxShLC2F6VgiH+Hv5JbxSlPNz
+J/y9/HLoocKfi6/ib+fX8HbHOHn8Zv59fxK3hZU8ufyD/Mb+G/xtsZv/G20
Lj2EK+P00F2TQrgqvjwhhPHin+hXY0M4jUa96fIDqSF0jQnhqYwQlk8MYQVm
mZOLHDxhnWZ1c8ULrDGHzqfP0n69h/RmyF9R8ypK9a+UJ8QFep+Rj5E/TdPp
NDrNWjniBeKFeBGZ8d7sawZmIkueao0UTPc9h/caNuAhc7vMuIR856x2xg9R
gwF7quU36WnGEF67WQ/SYmf+335b9RepqRbXoJyfNt5Ms7ri2uLn3Fc2raA/
8p+n4+T59Dvzjpp9gQ43t0J/snmd5g4V7zFzs7wSU+STUav2tNoW7LdGHerR
rKbdXbWhQf6OtUY+HsIoPIoReAwpSMVNe+hHAgfN3G0fDfRtc86b0YEqM5ri
W8NdMwdwC3dwG4N6q93T3+b9g1l62tXess82+jX+VPMHWsUJ57rp2w16Vv47
/wy9Lk/w+2iL/Df+l7RXfp3fQ7+Q/8r/jHbLe/m/0JPyAf4Jek3ezf+ZHo97
5h+hV+XX+FfoYflt/h2kOWs6Ljv3aJqKD5xni7t9j+50/xuQwA38y1vi3C/F
t+KsNdihpy7+Zpz/P363uT3oxTzfqvT8IL5k/S58j2/tI9t7nKpvtnufQtd7
D0VYh6z4G7FOJs3A8fjbN6sMi6yx1/724RP8ZX4nf5DO1/NCfHf2us6au819
wLc2622k52gSfZ//sO/fmHVRfbJ4GDrl551jmf52upR2xDdjz4/Y5zD0xXeg
Li+eUdyDXHGZulJ0x3nqtlnrI2ttpavoajSoO4B6fG7mKZzEWv8nhVjvDAeR
6V7Hxrt17nfN2h7fpfiYWa/TN7BW38dY7L4K9NShiP+yfCmWoAo7sUfdRt9G
mlmv7s14n2Y+mXX/7+49i2zaTA==
            "]]}, 
          RowBox[{"-", "7200"}]], Annotation[#, -7200, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1Fds12UUxvEjCYVraFktHRQCMkuCQDRBVkvRyAqzEC6A9M8QGm/QQiBI
B4mySmK0GEGgzLLKakuijBYwxigQDKMtBBFJiMYL5ApN+PzixbfPe85z3vM7
79u3zVtSNmvNGxExy4/6jIgDfSKq+kZczYl43i+ihVbmRVSg1frdrIh1+RHH
1X6pdoK4W27EeFqaHjGRTkItr5B2502mKV4xnYqvee/TdN57dDlvGp2Ob3gz
aQZvBl3Bm03nYC9vHu3Bm0tX8kroQuzjnTDTIusb5qwybzWGZkasN+8Q+pv6
a9kR23tGvCO3g/7VO+JP1POP4S1nrpNv940OPMQL/ly9/6EvMce3ZuNyr4gp
2Kn+bfH31pdQhEZ9mtGEbfz+dCsdQJ+ZI7NHxHDzFWAEmvRv1KMJzfjRGcrU
jfC9ApTr+QluW1eonewchZiASZiIZbx/1fyHVv13i79TG3S7OEV/NkO63r/Q
DPqDfG96W9yT3qK96Gq1C8xRgtX6tZu7A/fRhgf4wt679B6O2HMMR5Gmvlqu
My13zwPd4SC8iQ3OdEvNM/Oe9K0/6Cl60PfqcBg39T1CO+x/iKlmKMYWZ2kX
b0r28bfq9al4MXbrWYuL3u5Ttb8mbzl5M3o1yzXhifz+5K2gUXzB/gIzXbB+
zPs2qcd58fnk7nnnrB/xauW/wlnxOd5w3hnrDt4u+Ro0iM/yhvFOW7fxPpf/
DKfEZ3hDeSet7/PumLGSt8eMM8w+Ex9gOqah3hlf2VNoXYQS58yyLzOZ1b3t
xZ7k9++OX7mTde78sbr1/Dy5wfrm04/F/eha+rs33sd7e0qLsEC+kOaaKRs5
GGjfaDVjMQb9xaNoPl2qfpCaYvEUjDTjA3O1ocx6Daqca4W5VqIUy5FCubMc
T+5Hjxr1Xc3cqv6S+k60zHxr+TfodVxDi2+m2XuVdnG2Vns60xaaRn/CR/bk
utccZGOje9iATr5Rxz+IfTiA/ajWa77ei7FKTYPch/QwPYQa5yv1e/lbjxQ9
ra7BjBXylUglf/vqriT9kjcotxnjsv7/H/oaB3/QtQ==
            "]]}, 
          RowBox[{"-", "8400"}]], Annotation[#, -8400, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1ElsjWEUxvHXqi07Q5WaqUQkElMaqpUYyoJIaqqhxqCuKSHhXiFE4o7t
JSmtsQta90pIDDHFsHKb2JGwYE9iIUFNiY3fF4t/n+89zznnPd/5bjp+24Gm
/QNCCIP8WTIqhN6RIaRGh9A0MYSeoSGkPS8TX44bvIzzSl4vLxvlia9EgZdz
XsW7wWvz3Cy+DkVeu/NqXoGX99xfFUJ8Qghfh4cwb2wI32jziBDWYr+cmJq/
lWLj9MBUtevpRmzAJzn1al6PD6GBvqFzo16YLbeOTtNrph41zrPoaMyploc6
VJpjGD7r1WueBWqSeqdQPiyE7eobzNY4xm5Qr6aFtwkXeQV3lvQs4/XRcvpL
j6W0gs6XH5O7B93yi/JfyavgD8JAzNc/j/XuK5lhrfdeg9/qT4ifxHl9HuhR
K6fRvEuwGIvQyVuhZ1zvBA6jxfkI3UQ/qH+Pauek+i128VGvFs/19n/XPXX0
TrQ7+sec1/FYziM8RIJ3VCyBu3bVZc7Let9y/yV6mw7h5XhXfe9uXMIVXEZW
vJN2oQPncQ4Z8TP0LNqQRzvS0e8u8nEaKSQjFR/snqP2k0AcF91/SOwgjiCO
cvOlvEsZTdNrYt/VTvIe071/Db2g7g/9wT/Fq5VzjPY7d/BK9jPZzl7SrWqq
veNM5xn4Iu+m3ovVZ+0nh4Hy3ulRQWO+yR404EX0Hex/M6rUFFFAk9kXqn+r
JqM+jZh7ysSeq2l13o0L/F10J3bgGe8pUmacoEeabpGT13OK8xP3//K82/Ne
cxajXcrPRDXIIYt78nrk3KetdvvKfPvk/lD7E8f1beWXxPtwnZe0g8ZR//9P
/AMeMp0t
            "]]}, 
          RowBox[{"-", "9600"}]], Annotation[#, -9600, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl0zdM1mEQx/HDEhNRJ7rSQRIFCVGcJAEbizHRRCyTsBAFNZpYUanGEnFA
rKDYYnCzUHQUF5U2YFvRxUkXXdXPG4dvfs/97rl77n9v3vyGQ9sPJkXELNrS
InqzI1rpNZqUHjGdGzGFSWTmR2SgAIUJMtTkRbSjAyuyIhakRuxbGjGTGVGt
voT32L3+gog0OqLuj/6vaMiP0r/il3SjuCcnoqEwIpdXwcujGWaZ1v+pvrvE
W8T15tmLbmzz5nO5Z9isRy3m65HML3e3Ws0qWoZmdyrFWWZJcudHirfcL3fO
o9l4aNYc+Qc0mzZ6o1k+R+6dmQ6bcYymiN/QVLrenQ2owQfMoFPvreqqnY8v
i3hrnmP0HT1BP/JP0ffik3ScttBP/DN0QnyaTtKz9DO/jU6JW+k0badf+F3e
Wmjnyej1fUftfRwTKLa75ShEEWbt4Bt2mu1rYqf0p/o6WmJHa9Vfdq8bVzCQ
2I9dDMo9wRFvjnm72Le/pkW0UW2tujrnQTWV9raEVyZfYYZSuli8ht+Cedgk
nksL5VfKLxKvFl8w0/nEb6nfDv2qvLlOnCNOd76Pe2jwree81YVO1Jjzkfrv
vmWOc2miP72krt7dX859dvWbVtGL/APebkYTusR73NuNu/oP4A76MSI/asZm
397pXh/vNob5I/wmfgf/Fu8mhvjD/P38dv4N3nW84A8l/iP8q+KexE7N253x
///3DzVzfuA=
            "]]}, 
          RowBox[{"-", "10800"}]], 
         Annotation[#, -10800, "Tooltip"]& ], {}, {}}}], {}}, {
    DisplayFunction -> Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, 
     FrameLabel -> {{None, None}, {None, None}}, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotRange -> {{0., 6.}, {0., 4.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             
             RasterBox[{{{0.39919122760657544`, 0.0492162102994634, 
              0.39919060066481604`}}, {{0.6008640049372812, 
              0.07367992543601588, 0.385710063872717}}, {{0.7160680049627693, 
              0.09237595840634717, 0.37622222243605}}, {{0.8319666965826263, 
              0.11338012369790984`, 0.3651799276804301}}, {{0.885580557915976,
               0.25862978103944545`, 0.3645646572061978}}, {{
              0.9250377657059737, 0.37651449268748916`, 
              0.3640375657640502}}, {{0.9625625712365699, 0.4789019150488132, 
              0.3608696653766059}}, {{0.9981555488096214, 0.574819514362137, 
              0.35468573874197423`}}, {{1., 0.6798414518090715, 
              0.44090544936354603`}}, {{1., 0.7824529512706571, 
              0.5346816300028698}}, {{1., 0.9779017301455748, 
              0.7232824566953436}}}, {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {{
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -61.36363636363636}, {
                    Rational[
                    15, 2], -61.36363636363636}}, {{-7.5, \
-61.36363636363636}, {7.5, -61.36363636363636}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -47.727272727272734`}, {
                    Rational[
                    15, 2], -47.727272727272734`}}, {{-7.5, \
-47.727272727272734`}, {7.5, -47.727272727272734`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -34.09090909090908}, {
                    Rational[
                    15, 2], -34.09090909090908}}, {{-7.5, \
-34.09090909090908}, {7.5, -34.09090909090908}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -20.45454545454544}, {
                    Rational[
                    15, 2], -20.45454545454544}}, {{-7.5, \
-20.45454545454544}, {7.5, -20.45454545454544}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -6.818181818181813}, {
                    Rational[
                    15, 2], -6.818181818181813}}, {{-7.5, \
-6.818181818181813}, {7.5, -6.818181818181813}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 6.81818181818182}, {
                    Rational[15, 2], 6.81818181818182}}, {{-7.5, 
                  6.81818181818182}, {7.5, 6.81818181818182}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 20.45454545454546}, {
                    Rational[15, 2], 20.45454545454546}}, {{-7.5, 
                  20.45454545454546}, {7.5, 20.45454545454546}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 34.09090909090909}, {
                    Rational[15, 2], 34.09090909090909}}, {{-7.5, 
                  34.09090909090909}, {7.5, 34.09090909090909}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 47.727272727272734`}, {
                    Rational[15, 2], 47.727272727272734`}}, {{-7.5, 
                  47.727272727272734`}, {7.5, 47.727272727272734`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 61.36363636363636}, {
                    Rational[15, 2], 61.36363636363636}}, {{-7.5, 
                  61.36363636363636}, {7.5, 61.36363636363636}}]]}}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.499999999999999, -61.363636363636374`}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -61.363636363636374`}]}, {{
                    7.499999999999999, -47.72727272727273}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -47.72727272727273}]}, {{
                    7.499999999999999, -34.090909090909086`}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -34.090909090909086`}]}, {{
                    7.499999999999999, -20.45454545454544}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -20.45454545454544}]}, {{
                    7.499999999999999, -6.818181818181814}, 
                    Offset[{4., 0}, {
                    7.499999999999999, -6.818181818181814}]}, {{
                    7.499999999999999, 6.818181818181814}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    6.818181818181814}]}, {{7.499999999999999, 
                    20.454545454545457`}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    20.454545454545457`}]}, {{7.499999999999999, 
                    34.0909090909091}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    34.0909090909091}]}, {{7.499999999999999, 
                    47.727272727272734`}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    47.727272727272734`}]}, {{7.499999999999999, 
                    61.36363636363637}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    61.36363636363637}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.3999633796890805]]}, StripOnInput -> False]}, 
                  
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "10800"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.499999999999999, -61.363636363636374`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "9600"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -47.72727272727273}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "8400"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {
                    7.499999999999999, -34.090909090909086`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "7200"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -20.45454545454544}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "6000"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -6.818181818181814}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "4800"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 6.818181818181814}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "3600"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.499999999999999, 
                    20.454545454545457`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "2400"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 34.0909090909091}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "1200"}], TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.499999999999999, 
                    47.727272727272734`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 61.36363636363637}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.3999633796890805]], {
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.5], 
                   GrayLevel[0.3999633796890805]]}}, StripOnInput -> 
                False]}, {"GraphicsAxes"}, StripOnInput -> False]}, 
            PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> True,
             FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}, 
            DefaultBaseStyle -> {"PlotGraphics", "Graphics"}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"WL14DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "12269.768214705748`"}], ",", 
                   "1730.9100993459997`"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "10800.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "9600.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "8400.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "7200.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "6000.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "4800.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "3600.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "2400.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "1200.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.`", ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.954301396262643*^9, 3.9543014991356916`*^9, 
  3.954303749602889*^9, 3.954303786279399*^9, 3.954307578633956*^9, 
  3.954307667937016*^9, 3.961304097137829*^9, 3.961316153800027*^9, 
  3.965122845006301*^9, 3.973130279788199*^9},
 CellLabel->"Out[35]=",
 CellID->1668027590,ExpressionUUID->"22a90b5c-78db-41b6-9f91-d27869d020b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Myy", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "4"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"Contours", "->", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9543014785719633`*^9, 3.9543014814143953`*^9}, {
  3.9543076457439117`*^9, 3.9543076738022327`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"a5515605-ff8b-487e-9bba-1fd7de951b73"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx0nQmc1lX1/5/Zh2X2jXJPtEWxcsvcvt8yF0xLy8rEJZdcStRS0VIDy1xT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      "], {{{
         EdgeForm[], 
         LABColor[
         0.2374577454874495, 0.4502326479674301, -0.29344758919909575`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmXtwlOUVxr9dczGJGDaX3U12l01IsrTTQqA6FvGGYwuaICgq2tqLQqy1
f9TaPzoVIUgT7NQq6uhM66UXL+BIqDM6IzMUBakIGG6FoKNVGP1PQNR6aatV
2/PjeTLtH1/ed9/vvZz3nOc855wvnYtvXPjjdJIkF8Sfk6LdW5ckz1YnybRU
kpRPTZLOeDI1SbIhmyQjrUmyJOaMxO/rTk6SdTFvfbXGR6Ktrk+SDs9nbL3n
D9YmyfJ4ro3+NYUkORL9M8va84541sW8Z+J5NMYfiWdfPHvj+SBkWjRZMtzZ
mSST0hpbGfs0RDsQMnSk1F7nPmdfGv13qpJkbtxlm89+OSs5kOGOkHNX9D8P
md+NecertOdlXUlyNN4dL+ndG7FmU7XWMc4+d8XY0jh7U5z1Xq3e/Sx+z63R
XuxzS0r3WBz9oZYk+UWLzngw1j4Uz1DM/6RNes70xJp4PzPG+1KS/RLLf2ZW
4+fF+GWht+2x50WVJGmJ9dfGebfF+ElTkuQ3Mf/peP9FJkmeDD1+Hu19J0uf
S2POY7Xql6OfLslOJ5Wk8w2tGudO3A39TGvSO+5QFc+zE5PklyHP/Hi/ImRd
ndJ+z3jtCDaMJxfP3Vntg35Ksede24t7cE/ucldK/VsT7Xdri+7bEXP3xXNu
Srbe6/5ZGY2fFv3eJsmMjO/HHSYFaB+Oux/ukpyHon3Ccg5ar+ixKfaf5T4y
gF1wszn6Pwkb3Bj73dQjLP7JeKZ90n10yu9lKcnL/udE/3Lb5bcV6WqW9x9M
C9vgnz3pb0sJe0dOFf6wf39WvvbNGvkL/oSM7IPOOXOdz8Ue954sXB3ICp9D
KbWHjNXlce4LMTYcz0XRnxjPquiviHZHSv226M+PZ3r0s+6vtr0WxPO16M+J
9pS09sEu89LCG/3N1bLFkZDr7Xg+rBVms96HuS2eD+5P2DsRfi7Oyi7I0m/Z
2tOaAx4WVcnHsf+o78CcP3aHPsIGD0f7RYP1FXLsiLPPqxJ/bY1550fbndK9
WXtTIt2gI3SGbi70vY7WisvAwpIa3QuZn49ndlp+DK8MmOs4k3NOcKDtAjae
8/zJKdlwxHbcZnmw3WfV2gN7fRb3eL0x3jfojv3WOTL3+b7bU+pzl+dymvvx
JMnOHbAd8nE2PvtG7Nca7170mZzN2ua09qJ/gd8j/wqP/zT6HzTH+YH/Vxsl
G/pF/qPx+1ij8JnOC9/bA+djxhv6PNKoeczJpfWb/syy9jkj2t4qje+EZzrC
b2P8Dzn59g7LwHvW77QusQH6zET/L+4v8zj4b7K9uRf4A4dDxh34Y0/0vtXz
HzDvsv/BrO7QF88taXNAIjsgD7bAXwetR+zf4HnD1j+4Wm7Z6M+Kdov3mZCW
XZB5XlY+jq+vsf/Cyb/uVHy9PdrmYvh8xKrWaHelJStygvdzYvy20N+0Lum5
uUd6xU5gon6K9qmLdkuXOOOR8JHfhX7rJoStO8QnjMOBM82FxBo4C+76Spzb
E2sPxf6n9CgmIe+nEaMGYv0VIcOMouILPNgZa++PtR/E2p6iuHmSuXp3WjyA
Popp+fbZYLRDvnp/yPXviuLypQXFM2SAR4mvjH9YLY7MmycP1CmGEWuYyz5g
uSHknBp3OZwXzrHVDGMGnPSmhAvkx/ZjddIz8jc4hk9NKbcgx2iYot/wHnZ8
xfGM+P66fQO/QA//ycj3iQ9fuD8n+GFhnXKH6eFPM+skc6ao/sRo19YKB2AA
nSLb9yryv3scN9f0iJcea9f5jJ9bpbH1Ncpz0Ose6xZ97zafkwuQ96DLVvsD
Onkz9L4z+mu75DtwDfpZ264934r3LcYheJxg/kcff4u7F+OOrzVq3ajXNtUo
p1mBP/bIz98MW2zuEmbvLOj9A57DvcEPftlWFLbz0U4tSm9bclrHOLEV3xo1
h3fGvW6ok97afPdb7df4DPujh13G3ksRY/patc9E67+pKD4fsQ45iznkEHnr
kLX95gZ4jDMn22e/3i09nBHtz8nDYnww7rgx5r77f3ng0xnlguSwzCGeETuO
GLdvxdqnYs7WuG8lZDoaMnw5sPfVouaQI3875lwVvPytaI+1Sk7utCTeHY85
V8f4nm7tw35nZ5QnEZffKyk3va6gPOXpVsXlPXGX92O84nhE/Ftn3M4zR6Fb
YvRqx25yV2Izfog/so6xIedyl3YJcwu7xG33WVdwOTqEE1c6B2b+qlbJOr1K
OSTzyWvusa+B/9QpujvyYYt5zm1WdUqG4Wi/U5HOBwrSBTpZXJAMa5x7HzT3
shaOQj/wFHpBP4u6tJ59XrRvPl4rfiCfIRcfx9Ul7p9f0JzZBWF5jefTrnW/
7DgCH4KdtfZ37MA+q60fdAPe5lVU8/w+J+5A1+QJBccafLy/IjwtinP/US9/
eNTxmLj8Zrtyp32um/6VE67Jkb8Ra9aDvWg/yQsHO4uqRYidcCP6e88YppbA
ptj2u+b5HxpL852/XV/QOO/By3xjhhyKs8DhP+ulq7Vez3zixqd51ZkvFRW3
iF/Ew3XOD/Hr/dHms8I89+w0rtAfeqRe+FVB4x/l5L8XmgMPOK5vMZfPMZ+3
eU9i3w2hr8WB+7/G2oEa5X/kfuhidpXiLzXWYo9/nJMtby8oD2gwN5LLoHfw
jC7RKbz4SMxri7GX465PWZ/UasTeNsffsbx+906SXG2+72iL+szBX5EDn92X
0+8fFFRz5W0LYuaMJsXN3nbx/MqSaqVpHr+iSza+vEuxgTHyxhsKkvvKyfK/
jY531ARtzufRa945M/oYsE7gMnJvckrsPObYek2Hxt+J+60qqea5raT8bavj
Mv5OzCOuISsyE6PQF/r5c2Dj6k7hBLyAhyd83/O9zzLHiOWWjXx2hfPnHe6T
Bz7v3JFz+5z3Mgfew9/gh1HncszBvuBnyDndLcYP3LTUdt/s3IHxpc73+A12
eo0fdDDV+nm4XrrDlvwedB0BPueO1yONyoNZT97N3U/k0nXKgcglruoWfy6K
9nCjfBls9JR11vc75H+76uSD24vq/z0vLlnueArXwBU3dyjvo35g/TbLNsO8
nbM/Lu5QPrmxIgyBJWIRNQN2RDd8N+E7ybslcepG5y1wQofrwSll+cpbIc+V
BXEa3PZ8Tv1N0X+0W7U8Nf2gaxbk2WQOZF2/60PsSE5JTthXUZxZ6ZjV4ZwU
DPAtoeTfecd5bMf3qrK/WS3wHNaS+73sbxnc5fg4N2YUc4nvOX/3QD+0I8Yn
+Si6xCbkQ9izUpa/jvg7ycVey3x0gU6u7BbHgnPyFr7TIBdcd25BOfB5Ba3n
jn2OKSv8/YSc9Pp65aKsg4eIWbvGOaVKMS3j8WHrkPiyx/5Of5frJHREHbTB
3zFOa5Ktd9qHZli3syL3Oz3Gp7crnt/rmA7/kAeDW+rvz13/Uh9v8Hc/vuX0
eg5x7zPP2ZxTHnBWWTi621hi7KjnbfB3QzgO/us11/EwNl4f459wHdiEh8f5
j/eMc6fTzEWbiqqVqKX4BkNs5fdwq3ie/IFYcWO9cE1OTP2MHzznvJf8lz0Z
R1fkbify2pS4iHPJT8j1tjsnpB4mlnypLL1sM781N4g/0R0ynm45yTeWeZ+t
5rfxOvfB7P/iGD4L/pjTZA5c4LqMOvcF5xnEzaLxwDj4hRPwPXJ+1lJrU1Mw
Dufsdv5JHoqvvOLYAadRP1D/gjvwRy4Cv2YsA/dr9p53ey2+trdbPnZzRecc
8ll5+w2YB+PUY9RixGTyDHIMeJH8kjyPeoa65vEe2Y7x6Y69o/adJxxvsQu+
RV5FrkHsZQ7v1rSrXqAmYz9qIWoH6kq+f5HTzPWduS/13NseR/bDlp91r3kt
8iHTie/ZzRoHJ2CIvII5fOuhvv9okr61jDmPpT3ofr/75Nn4YovjHTGGfsVj
re4P+js4Nhrz95st9vesa6i886Vhx9a5vhf1MXwCd1xknBBHlpRkj4GS5Bjz
ni8aK8g13/uDMeaQ+xLX7jLH4oMLC8pj+DYw6vqU/fvc77bvZCzPduOH/ec4
P4HPidUH/F0UDsuZ6+HbNteMe4x/+vDDBMd0MLbfnFwwHyLzbu8/3ZjZb9xg
t1dt00XmCDDGt2Tq2fG6ina8BiEmEZcbbG/i5v6cOOVH7Yo/ZccpZCzaT0ft
n/Az9eCofYo4VFOvWg15C56DTU78b6Za9QB16cpE9R65C/pBRvgFboGjjrkW
hjvhb3hqtnMb+keNefLFJ/2dnBqInACe4ZsTuSw57cG87lGy/NUlyVlV0jdS
6mFiCnla2XPw0WH7L/Ea/0Bm7nrM9S+8S34D9+JrcNyQ8ThszLzgPnqYZ53j
F+hzgeP7XOd74JycmvwMv3nI/AnWmVeyDNTx6BBd/hej1p2u
            "]], 
           PolygonBox[CompressedData["
1:eJwllU1s1FUUxW/LTKEttnbaph/zLzNDp1OIlpZgoEWlGD9IjDER0oIfUWwb
oSworBAXxETBSHStG6NFbBeygaWCQIKIAaqCGzQYd1qg5VMFNcrvcBYvue//
7r3vvnvPOf/C0NjareURsY2VYk1kI+qrI9ZWRnQlEStyEU9WRPzHt17sZr49
ytk7dRGfFCPWs3oIfIT9Buzxos/28O1Ie8T7WdsL5kTcborYy37hvIhR5W+O
qOogN/6FsojZloglrRFLMxEn5lIDvhfJcfh+amNfjv9y8if4/1QbUeSsC/8e
/LtZveTaW4jI1UTkWe9hT+JzodYxK4idwOcSuTbUR7xQiqju5O4ax1RhP1/y
Wdn8iK+o92iTezFG/m3EDlLTFPHfsZ7Bd4j9DPYs6yX2q9lPYv9VFXGnLWIO
K419hR5UUOsV3tCP/Q0+r+bp38KIm9gZejyA/SH3reG+D+jRQXI9zjrA+Rg5
NpNrkhoO4Ps56zPyPUvMtN7K+W7OL5N/Ffkfot6V+H5ED57C93CaeuhvCp8K
fGfx2ch+HjlmUv6W5uzvFvtOUcOLxP7Gm95sYObMJ41vGT06zb6FmH3Utk/z
TnlGn2JfJf7/Os9Us1WMYoWZFrDzMXeMc9c19ZC3dpJjF/ZVLc7+of5B8l0D
b2/kjQlho4/4BuJfyzr2LPs7+M6wVuM/wH4E/7nc14//W9T4O7XvYK3h/Q30
83XsfuL3E39O+cj9ADlPsp9mPYi9hfhh/EdY56hvmJyV9/kO3fU934Yq/Aa9
5TrfTld6Rk+Q+wb7ZWX+dpJ8jdxxvtKYeIzzxsRv0TedzadHF8FnF/mrsd+m
5801nqlmuxLO/Zv2t90FY0BYUI0/UMueNs9enBV372Es5ZlpdvXCO/m7+ZYR
fovmqmpUrYty7rU43In9csm9vEG9m7LmmLgmzE2Qe4T7NlV5xpr1IvAw3cgd
rBJvu0VNBXr9Jz638d3B/udaxwyzL5Hvl1q/uQP7R2rIpIyhLxPPRLPpZdWx
/zoxt4RpYXt/q7EvDovLE+Q4VW6Oi+u7sp61OHpM3G03ly5x/zrsV/LutTi4
EXt7h7ktjogr41lrlTAurEujpFV607ucfZuYG5fV03ZrjrRHmiXtEufFfWnc
H03ugXohzK0i/tYCtK3aPVFvdtLvQ3XGqLBaynlWwtwQ9T2XtRZKE6QNO/PW
HnFEXOnLGbvSaGm1alJtmvkS7C8Sc1U9Po//wzlrmzAlbGUS91oaKi2VJkgb
DlLTGbAy2G5uSuMGsI83+Uw1TxWtWdIuaegg9mybey1Oi9t99GdZxjPqJn9H
YmwJM8LO4k5jRxo4mrVmS7ulmeXk+rXV2i9Oi9vLc/4XqYdHqKWn1VqnO3SX
OCvuiqOjnD1dstaK4+vIfyqxdgiDwqI0QlohDZQW3gUZyP3V
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.30515231631123024`, 0.519661328908171, -0.16879163954425425`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmgmQldWVx79e6JVuoLsfr7tfP7qbfu81KiajgMoYUXYNGhWDiCuCE0Z0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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHlw1OUZx19IyLFLZHOxm90NOTfIYS2HAlVQwiEFbAk3IogcbYFKYaYq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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.3690365604561008, 0.5851820752531124, -0.051152203693616866`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmgmQVeWVxy/0QtM09N6vt9cL773GgJQQFkHFKIoao2JMlRlpEHVEZVUE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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHlw1dUVx2/ISgJkA16Sl+UleS9QlimURUJFJaxtp8XiaFsWQSrIJtgZ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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.4329208046009713, 0.6507028215980537, 0.06648723215702058], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmglwlVWWxz9C2BJCXhLy3kveS/KSt2APljOKS7uxtDoqVXa1LO3Wbihg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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHlw1dUVx6+QhS2SDd4LCXkvyXsJLYyVXUAEAUt1pk4VUpdpUcIiZR1B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            "]]}]}, {
         EdgeForm[], 
         LABColor[0.4964845718857812, 0.6836033423942862, 0.1768040216487851], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmgmU1NWVxv9AQ9PddDfdDV1VXV1LV3UXanJ0xInRIQpqMgEDLogi6hgF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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHl01NUVxx8kJCYkhLDNJJPMTDKZAbQHBQtqURaXVpSisi/WKmjZUrTK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            "]]}]}, {
         EdgeForm[], 
         LABColor[0.5588976154819355, 0.5993756990506969, 0.2608276721375951], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJw1mgmUlNWVxz+gu6HpjaWhq7uqq6q7qhvJHE0co2aMJgFFgwgoCCIO4oIj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            "]], 
           PolygonBox[CompressedData["
1:eJwtmXl01dURxy+FgCELAdS8l7cmLwS1p+JSxKO1loPsEhAQWaq4gLKlQlhC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            "]]}]}, {
         EdgeForm[], 
         LABColor[0.6213106590780897, 0.5151480557071075, 0.3448513226264051], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNm3eY1sW1x38ii5Rd2F22vL3t7otGiRoLiUExxqgoHUtA0agoqFSlaJ4b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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHeU1EUSx38KEpZdMuzEndnZ2QEMp+9A9Hh4KCJIXGABAUEORVCRsGR8
eiIGOBQ8oiw5I1HBU1HkBIygopKVYODxQODEkwcq8T7f+/JHz1T/qrpSd1dV
V/6DgzoOvDYIggnXBEFZ/u+NBEGsXBDUrBEE0UwQ/BIKgqo5QdCoWhB0TgfB
IubflwmCutcFQTwZBPPzgmAr89nZ0CaC4BLf5kJfD3w+8HnGHOarKrI2FgTr
w0HQAdxtWcjJD4JvkfG3mnyHRy94T4NHO3gNZj4V+D+MWcz7w+NzeO2B/n7o
u6PsFehnIX9LGdP8DO0g8C2YD0f/wcCtkfEzsmcj8wiy6zFmsPaHqkHwNvYc
QqdF2Lueb38B1xgZR+F1jLED/p8wr8H6r8C3AZ+XtG3ywWLwXzLC+KY+NNnw
OoUOpdlXdUK34kLWVbdPOwKn4kGwETgNj/Hw+x1+h6Gtw/wP4AtRdGJeyPwi
8BK+NcX2tchvCP0Y5r1r2mfy3X3I6FopCD6tHAQR6FcyklWCIMEYlwKG/np4
/QDPpeiaRH4E33+Czi/AL8a3QWXs8wsF2Bf13ldnhOA/ifU3I/8EMlLYdjrh
ve4O/yu1g2AB67+7qn8U2sng22SbZxTcEnRoCu1h/J1kfgSff43su6FfjPxS
zltvdK8GzSho54bsD9kfgt9PfLsJ+fwFx/mZhX63VwiCA9gwknkIe2oDb4Xn
k/BrA7968JvBt2ngPkTeG/huGfiPgMN8ewdeA+AfAW7NaAvtdPboOda2w58L
2MtLrGkLfDZqeDFr7snlnCCzHnAH9H0DeHTKuhej05fQbuO89UV+S/xVDvpw
0r6RTfOwbQY0z+Db3fjjV/wdS/ouyYcLwd/BvFHgM/hX4LsYb3M3jzNvCjyA
M9QfXQcweqLvGmxuy/r62BBGdg7zG/FXf+wdh73vsx8jWLsU/iOw5wPmo5kv
Yz6KeRgdXmH9jayPFPgM6SzVYl4T3zSG/lro6+pOwm8/Z6IXZ68e80fEmzV3
YstQ9BmBbvUYEeAooyr6bQvb1+XKB8Et6PcYPill/hU+i7K2CHlbwG1lXEbe
LmxcBu9z+Lwfay9C8z38f2Sk8M/dyN9JwGqCD5sBf4tOH2HrOr49B/3IQuvS
jjs2krWzGY+ztoRRCq4Foxn4CuDvQL8i9u8HZHeCXzH8pkLfB9pJ0IwE3zhi
2t3QdEXXh6B5FNr+ii/M32OcZu9/qYUP6yAnbV/JR99Aeznpu6c7eAV4KTFi
NedrLP6Nw3svND2hjWJvdfx5BX4/Qn8D9AG0tRP2XR74WsCbGMPhvwSaYezf
cng2Y79fA38b9i8JWZ5iVALc4phj79PIq428jawfxvrF0AxhfR72v8d+34uM
CPCBjO9bH3Q6BLwIHnfmeM27rG3F/r2PanH4n4+ah3gpRi2G9nN4DGdv10MT
hrYc85XwP4J+TaHtiA5/Yn4TYybnYWzYvNag42+snx733e2kPYT2MvZ0Y+0a
5D8Nfnva8fhLvrVkbU10equ8c4JyQ3v2r1pV3xndnVpxn+UY/KppL9G5ZXnf
wTHQf5FyrFkBzx0p5xTllgfgtw98jYRh7ZH26uGYZTfBvj7AncCH0e0s9gyF
99esP8U8wplsgK6HoXmiomNQI/Q9VtuxTDFxKcBb+KA9azsyJqDfUXgchnYT
Pj0CPCnss1DKGayLLZ04v0XY0oHRGvoG4FdB3xiag8hqh81nkD+J9W2Vn/HH
4KrWUbrKp/JtR0ZneF2B50X88xSjMrjx6L8QfXOYVwLXim/tq1umZEumZCuH
JMCfZBwDXseYD64toxj8aPQdHXGMUqxSjM6Ftg/8x8D/NONn9H0Tn56q4Zhw
BX8NyTh3l2ePSoB7sP7x6ldjHvL7sf451v7K+IX1LSWzunNsh0LfUd1V2STb
boXmAroMZzQALsYHHcBNUD4GLsP6kcxnwe8l8LG4cTrjUeAMd3of/lvL/lRK
+c7q7taB/nLUMVyxfA/jDPB9yn/gJ8KjC3BjeP67gmuSsujeJ+PYIZ32w2tq
oWPNY3wbBL8XY9alB+ejDPdnIPtbJct7Mj3mPdHeKEeNC9mH8qXuxHesP8Ed
m4kvS+A5DN6PxOyvs4wzwL0jxjVB3+Homx9yLaQYq1irmkG1Q8D5rcl+RNFh
A9NN2LAD/m8yVgB3g18hsnph4w1ZrqEeAB4asa8PcV+uw3c9+dZR/uVbD+BV
nMkWOc5BW5kvjLkWUs0zB10iSd9H5cv5zDspXnK+FzFvzfyf+A81g4n4a3LG
NYVqi2fQdxb6XipwrqgFPhl1zFPsyyinM2+hnJ/lnN8KeB3jevhVBr8+7hyu
XL5Z4RfbL7L+Vs7TQHSugG9+ZV6HeRfGJe7uMxnXpqpJSll7Ms+5VHugvXiC
NfWpBTqBnwu+BHsmIOtR1nyGrRlkJrOcE5aAuwmZORUdcxV7+yV8F1Qz9gVe
gPwF7N88xsJC3zndPe3BzfDajIw/kHWe8Qqy90dtm+6o7qpqHNU6A/HR3ALf
ed19xdA20M6E54CqzpnKnTojOivK8cr1m7G3Wk3n4CPo+hvxrFEln7+Guc4h
yiUbuS+xlGsy1WYDOFMfM98Fjz+w5SA6HCz0mdLZysCjLv7az7dvwB1g7EO3
eMhvgU3wS6T8TbiP0PlT7NnL/Bz8uioesB918sxLd64Ra/ci7y3lA8Y+4Ebg
G1ZyDHoIf+9D3r7qrkn3wGuyeFR2Dala8igyjmQ5Zyh3vM76Sax/lfPRHHt7
5jl35LLfPfKc05TbbmYURxxjFWsVExUbE8i8u6JjmmLbQtY8X8lvKL2lcmJ+
SyhHKlfOiZm3atbZ0hebYtyHjdKX836g0L5cj307sW9I2Lh3GbvTrvFV6ysn
f4b/DqqGZe8+5tsB8KMijtWK8Yr1+VffN6ohlim+YM+Icvbx6XzXtKpt4+h4
F/D8fL+tRrL+SXRpiY6Pg7sO/jH494kYV6Q7WuCaWbWzas7v0e3hjGPJBfw7
BP82z7i2U86/J+OYpdg1Xj6LOeYr9j/L6It+UzOOBWugnwI8U2csy3dgC/w6
Qz8c2ubI/ImzOgyaUdBXAb9a8Rr8iIq+oydqu4ZTLXcD9NPg9Q023RL4TH4L
XD3Xe6831wfgnw/bl6pBVYueS/ltpDfuWeApeY4VqtEnA5dEbevD+GMa8o/F
XEvIx8eBX8BfL5ZzjloV9x3VXR3EmAdcMeq7EEHGWPiX8u35co5ps4CjKd89
3UndzW4J1w6Kwd2BFxc6dijmLQJegYwVWb7zc1ifneu3jngW5XnPtHftGWOB
/4GOR/H1x5yPp/D/Ss7L62Ud01cDj+Hbp+CO821yzDWNahvlxJbKp4rfNZyz
lbsr479B+K4f/KcX+Mzq7KpGLwk7ByoX6o40UT4MuTbaA//BMftAvtAdzcI3
w0N+e6uG+rvq59TVtzv5Jld7k3KtJh/L19ujrpXWMv8MuCs2nMz2G+w+4EHo
U7+y30B6C42LOLcrJ7/B2d+RdG5YqBoQ/EpsGIW8EmyYpLcu+JIc5+tpMb+h
9Za+BP2hkHOkcmVLbFiDbu35thx91sHjfuhrpZ2LFR8a478OGccWvVkeiPqN
p7eeavZs/HWo0LWgYt5h4Ilp66I3vN7y5xLWVXu0mP19O9+1umrQDfnOScpN
6mGcTDimKLYoRipWLgn77a4YWgv6VRG/1ZQTlBtkk2xTTfcv5kXQ7yrrGuQ0
9sTjfqupJl1Q4DOls6WauRmy26FvA/QtRaefQj4TOhuPMGbovVzgt6N6IOqF
NEm6V6Oavwjcf/HJmbK27zTwzqR9r2990GVqyndbPZLxwB0zfvsppyq3Phjx
21F7Phx7c6DZjD/6wi875R6YemF7wZ9Gv9lp1x7Pwn8mcLuQ39a6E5vx3+GM
31LaH/UyGsacq3Tmdfb7xRzL1KNqznxb1L2wlth/lvs7IuS91517GtqXQn4L
KQe9xv5NRMa92X5jXYhYR+mqmvUc/ric716bapYz4NP5vpuyqRB4RcqxUf2l
d+BVlPZbVHvQHvh41G833aljUddUqq2Ow/MUe7mwwG9r5RTlljuT7lWoJ6be
mM60zrZqttXAa5L2j873WuA2Ib8fVeNtQP68qGulOnqvYt/UiGtH9Yg+RN9I
xr0pxeQwcMWUe0Gq0S5B2x0fjcSX9fg2T/2gXNd+qrFUa32Sci2imram+jNh
7516nHPSruFVyyuH7Ic+nWdbVfOq9p2S79pQNcJU4La5fguo53kRezqEHZt0
3rcxvzXtt6BiimLLWvANs1wDDom556f+kHqkF4CzUn5raE+1t3sKXOuoZtpd
4BpGtYx6PC8lHbMUu9Rz2p7vN4TeEupRqFexOuzekN74cXj/PeTYfRIdX0b+
nLB9rRzZJeaejXo3qlHyVG/EXUuqx7E3bp/Kt8qZXWO+k7qbc7FxQ9o5TblN
PRT1UvTm1ttbPSH1hlonfbf1Rm0DvDzm3oh6HsvRrXXMvY5pzG9j/nnUsGqe
L4ALM757U9jvP0d9x/6ff9jTldj3Ttq6qMd7Evkvp91bUkyugu5bEj57OoNF
8O8Zc+9XMbeD6p2oaxu9CfU27IJPT+Q4hnXWfUm6lyaZyn3XxO3/FPb0Trgn
pt6Yaoyh6HqytnXTmeyGrAEx1zI6AzoLP+Z6rWom1U4fpN2rVI9xK3CrkN8+
euMXg1+ecq2jN8KrKfeA1AtSD2hZ0jFdsW8RPH9PuGZQ7aAcvxJdf0sYp5yk
3FSc71gjGzsBx9Ou3bbD43zCQ7B6cheB0xn7Xjm8DvCulHs32sOdwL3CPlvy
iXxze9j+Vg/ktaR72Io16mEtTbpnpd6VepSvJh2DhFdMaKtcEnetph6heoX/
A6lRlCY=
            "]]}]}, {
         EdgeForm[], 
         LABColor[0.683723702674244, 0.4309204123635182, 0.4288749731152152], 
         
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFm3eY1NX1xr9LkV3YImyZsjO7M8POrIqAUaORaCzYC6KIpqBGoqL+Iliw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            "]], 
           PolygonBox[CompressedData["
1:eJwtmQeYldW1hn+GcRimXhiYU+acOWXmHHoR8SYQNZEmIlIVEqQogqBXKVFR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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.7472209253440304, 0.33619377292217134`, 0.46551022588901336`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFm3mYVNW19ouhoScKaOiu6hq6q6q7GhUVNc4ogigaoxEwMsoQEBQioBDj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            "]], 
           PolygonBox[CompressedData["
1:eJwtmndglFXWxl9KhBQSicgkk8xMZjITVIodqYpSVNRFUClSRboCAlawC0pV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            "]], 
           
           PolygonBox[{{7879, 7878, 8240, 3280, 6322}, {7876, 7875, 8233, 
            3277, 6319}, {7792, 7791, 8113, 3179, 6211}, {8345, 3387, 8347, 
            7786, 7787}, {6318, 3276, 8229, 7875, 7876}, {8350, 3390, 8352, 
            7791, 7792}, {6321, 3279, 8236, 7878, 7879}, {7787, 7786, 8107, 
            3175, 6208}}]}]}, {
         EdgeForm[], 
         LABColor[
         0.8125172483376876, 0.2240449679556084, 0.42350857840317147`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNnHeclsW1x59l+y5sh333ffftRekgig1BsAARNUY0YqRYY0nseC1Yktix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            "]], 
           PolygonBox[CompressedData["
1:eJwtmnd8lNXSx5+QEEgCCUnAbHaTbHY3G6QjvTelg159LaDSlWtFpFgAFawo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            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.9735241229755421, -0.05249018370661607, 0.31994142972937545`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNm3eYldW1xr8zMAwyhTIDM+dMOZw5ZyaKFEUQpAgmJKBIkpubCIoNvZqg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            "]], 
           PolygonBox[CompressedData["
1:eJwtmHl01cUVxwdC2LIgBMlbkvfylgRBEyAQQBOgqD0EBaSboAVUqFY9Clhx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            "]]}]}}, {{}, 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1ndsllUUx/FbtguU2YEFSmUJpbRltoCApoCUoJEABlAhoCZaK0MJ4h6g
LBVQEUcEBNmjikqJQVGhMlVGGVJoFdzKduvnxj+++d1z7rln3Od5R7NR99xY
mBBCmFElhC9TQ+jdJIReKGsUwsIrQ1iEGvzVkdU4hGwUpoQwLC2EobhGbGFy
CEubWSeF8Gl6CB80DaE2vS0xhMvpaHpIXF/7Rc7Mc/4R9mN4HPvUONU8hF9x
+ioq39kWIUy1Nw2n2DvYV8gzRuxpeb5hn6HlfJ2tuyAHndARY8XtMsPTck7D
k/I+gUz9r6PrI/zF+Flcifh8feU52wPdYy51p5qrY8sQnqJV9PKvmqOth9Ht
Zttp1oZ0sj4S6RR6RtwI+7vtJfE9ypdCH6e/2xtrL989XK/epezLUBvj9dBZ
P53QXH/puJy/DqbrcYL9ich2roY5hvJ1lWcYXRvvwHq/55QovhFm8d8vPle+
buiKOmZaIe9aOsOZmvLUQo6creLd0dZ0nf1mcqWhtf135Rok/3v0MveRI/+l
tCMdJWY0ku3dbc5gvjKxB1CLvZ9+qPZmbMFHqJR/qzrV3clxdl12G33lWXfH
x2o+J18/50+IGeEuT9KR9Hf+UvGVnkOm+t/L04BdxE5iJ+Mmc+eom2GebNqe
dqRz9JYmx3K5tuk5OJOAufzN+Vfxl/JX4auKefxt+Nfyf8Zfja86XuCfRBur
m6JeKpqgB/t6cwzAEHMMxRL9Pq+fpfRm9jAMtF+A5uYcR8dH+CfEOxL3UHwf
zdUX/fU9IL4vSJe/nT4yUGKm5/h26uVZuovm6OlF2kHPxXreLq4GX028xJ/F
v4F/B38tvoswnz+b/33+nfwX8z0s3yU0zf2/bH+l9RS18+PnGP0wWI+lOMif
5Nwheswc5Zil75nINd9sfZ62Phyfmb2v6HF6hFbQW8y7VdyttFjcfvVq6OVr
d1HK3oaT4r5FRXx3UK6/i/R2jB5HgjOF7O7ogTxcg57YJtdB/d1rxnGYgPEY
qd56ufc5uxd/maVAr3/wDaT95O2L1sgyfzY64JycZzFI/HA5rtBPmfxd7HVG
K/HtaAbaYpvcZ8QXxO9TsQvje+H+Zpp/k/0SrHB+OZbhGf0m6K8l/2nnNjk/
XXwJbcH3m3MT1JiIpfqs50xdHJM/2dnZ8bOP+vbrxXefr6a4XeZqaF0hrkF8
1uwF/JXWjd3tlUhCCpJRJG6v+abr9xlM5XsKGeLXxO+QCP86/CRuo/gf6Rr2
atwn/8T4naLff/T3N/7EP+YYYY7h8fPFnos5KJL3O32/p+fZ7FmYiTv5K/kT
xZ9wH8ucb2T9VvwdYOeo20S91PhdLn6gvYL47sb5aX3URbnYo8gSP0SftcXv
E98pfsejqfge6Ilc99JB791oFr3gzBfqFdM3zJPqXFXvbDUsZJ8Ss4h+LuY3
NfbQIWJXqdOenYmM+FuIUThvpjb0arRGO7TFWqxBuvOfyJkg7nV2CvtVmkxf
o5vVHS13L+syMTd4Xw7SG+kmc12Iv2n0LvdWYbbj2Kq/fvSIHJX6/xrfYKg+
64uthwr2Yft9xeXj3fgbHT8Hcr9jnU830Ff53qbXsdfTa2kxfYV/Ne3NXhn/
S9BVtI9cf+v1oNxfqVEe31dcpaf25sxEW2SgHQqw2Azp5iz2DM7r8RxS5Sv0
3t0T0W8RNopbYK+NM1fHZ6aHvPgMUaZentq5OKzeAXY3667x/dFXT/mWxO9t
upQucOZNmsdeRHPpYnpW/C9qntTvJPZkPIDd6p7Uwwnczz5h/4zYLXpeTR+K
vwf8A1CAJeJfEvsi+rMftL9KXJbeOuAFvnlYiIme5SCz7ebfhY16aekOW6EF
Stnp9isb+o7W93yU8G9Eib09zoyRYyzuwO3oo94P7uhaetRdNNRHIyRiuN7G
yDeCjkSmGaq7/5v4Oss9mK6O/4vS/v+v+B9SNoTI
            "]]}, 
          RowBox[{"-", "1900"}]], Annotation[#, -1900, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1nt013Mcx/HPZqRCIUVaba1YW0WOW4jk0KHolOu22k2lti4K0RbF2ZBy
S27JwnHZbCJnSWlj1ZbjDxUrWjc5S44jDm0ccczjc/zxPK/f+/15f17v9+ez
3+/7XWrh7AmzEkII+YkhjDwzhOK+IbycEsIKDD0rhKtS5dEivxenpYVQ0CuE
wckhPImnkNs7hKP0krNDOFPNxfR38Rvq2uil4kX9QxhOR9CR6g+qK7Q+xHqm
3GDslxtKh+A8vT/oF8I1ZrpbvsI8q3C+/Lg+IVwnv4vu5LkLw+THi6+Xf59n
OY9HUYZK67utfYssa9lYKdeD7z77csT5eu0zT4uaPagfEMJG1KGCxyq09gzh
zYEhHKGN9t/iHDnuYyIm4QU+eTQXt5m1xSw301txCybzP8PacP4HfO6s/wN8
7uSdjwJUyxfSGjqM3z79XzNjd3+D1+mptMmerVjp8wq8gpeRZ7Zc3GauifRW
Oom26rea38VmuAQX4jOzXUTT1Txib99z1fEP6g/RsXJvx7umh2mZWX+gm+0Z
Tb93X9N4PCFfRFvFE+Tv0Wu2+BidQ++jt8tf7UyjcEz9P3jIPEXOt5B2iD8y
xwxxMb6W66Y2OOMpNIF2j6pmsnkS6XH6JeF4bNej3J7e9AS1dXQjTtd/P78D
OM7+RCxW/wQ6ybX7W7RhqfgvnknWp8Q7cMbF9r5jriU0UTxb/hu6RF2tGZbS
DbRR/lP6tLiOPkXr6TN06jkhzDPPm3q8hRo9n5Vf5Y6X0ZW0Aq+iyvwJ+iUi
3eznIsXnDPv78UlBR7wTPmNibfwdWs/HWrVbzDnY50aa4zszEVk4Ks6mS7EE
ucjDJLRZy6db6UDaRJv1uds5O/E/AeP0SsZOvZvRIrcbe7EH32K/s7Q6w2/O
XY1ScRUtoe/SNPu3x3vAQzzS9Po4/jbcxzpaa/5pZv+QrhVnyNfSNeL98Vlg
ng/FW9WsoUPED/JdiEXYwDfV3/B5fUrtXU5TxGn6PyhegJ8wHyUYJZ9s/Tl1
D4iX0Sudo4/cffzuxVyk6/O+flv0XU3PEe82z3vmqol3Zm81rRbfpaaKVokn
yFfSSvFU+b78M93P6frO4tuDXuj3Ntvn6fxK3HmZM6xT84m19XQDPsYCa6Uo
t76J32YMjueVy6T96Xj95pp/TnwWmfGQ3lk0Jz7D9cmmT5vhLr1K7Wmw57C4
q9lKxDPF82kxLcIMrLe+gu8snjMxA3lq7rDWyr/BHHearwCFyMcUTMYd8Xeq
fgqm4iU+a/hdZo7LcSkaeAynm8y02hzvoQab/Z4GuZcGOo12jb8j2oWOsX4D
jsb3C2r5PsKnt+/TsvhOsHZE/mf8Ky611sva4z5fYy2VT38k+Dv3pReYLZle
zmeR+YL8On2uNdN1PB6m19K/43M43rH4RfEc+hK9h7bH5wX9w74OXu3xXegO
tumZwX8Q/tS7TV2W9d/oaeqPt/9UmkQT3OkX7uIH/Q/jURSb/RAdHZ9ttAwP
41f+f/M5hsf5Poby+C5V381Zd6up5bsWv+A7uTfi85oexFzrR+zdacZd2G6+
HQj2Nzljh3vYJv4SzXo1q/ncjL3MmEx70j60Xm2j9U9pEy2N70j5fbz3opLP
AbN/pucV8V3ufCNoNr+c+I5CFm6P3xeMUfejGW6gN2Is6sU7nG26vUX4Jf5/
QruYbTz/E2lnzJMrUN9u/X6f6+iA+P6O3w3f/9fM9joOeW+/qNfzeAHLsdDs
lc7wDvbwHOd+bkJX+09CF0w3w/f2Vzj7QDVXOVcS35E03ZnmqV+Azvq1O/tJ
OBnz5brRU5AR36nqR8RnLN3hrr5Cpvy7/f7/3+s/qzhzLg==
            "]]}, 
          RowBox[{"-", "3800"}]], Annotation[#, -3800, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1ntMl1UYwPEj5sRbtvJuCqhIiqhha16qlQJqK0Vt/pEXzLxPpNLmlq2t
LAOv6EydStMU76Vm2tbaTEQsoaXgZgleKu9imZo3vPR51x/ffd9zznOe5znn
/fliwticodNqhRCejQkhpWUIrz4ZQheu4KG40CyE/MQQprYKYX1CCNm8gW/h
oufSjiE0aBHC4TYh1OdDxhfM37S+PC6EOHMr+Lv2IQwX84vcNzvYj4bmGmFY
8xDKonrcwDjf3v5yLOKFKG8bQoZxpj7SeTA3VacJWrcOISkphHPtQjiPZDnO
6Xmd5y/QQ729au3Vx1F5psaHsN2+4eKyPf8o1084qU57ed6Wf7HxO1yo3/VY
oqfFSHeOXLnyMBcL7O9nLg3l4i/LUcHV/BZ/oF4ObzLeK7ZSXBXmmD/Ja/Vx
gkus1fUci6Z6bokW0Vn0fMS9lCMDsfpL5xS+bv0GejvHPee9q+ca3MF93EOM
u3nIQd4HXNv4cTl/c6bjWGNcxZW4pc8O8iVimf6W4zm5H8g919w85GEB5mOr
vdPsy8YedxznjPEosO9zvGBvDD7Vbx1ONzfX80ixC3kBgr2T9DYZ4+ScgPHY
qJef5doc/b54E5fxFp7MDXkiN+IpXCRnhlw9vaNE53wKSeiIZPd7Uf4unIJ5
4uajj71p1jOi3xTm67GPdzrYu8hEgud45LuvX3mWGsV6O4AnxGbZf0XeMdxL
zFq5e3KMuO/NF0Vnj+7fcy43dv5Hcd18sbk55uLdQb7xX+pfwmVcxBVU40x0
D3o961wVzrnb+Ah/w+W8TczXnr/kXXzYXKn6qXpMkX+fejH21kZC9L7Va89z
xWzxPI+/4m2I00cH507Efvs68SP2JfFm/cZbPx7lVauFWl24JU9XsznP5Nbc
zXwr7sqV4qswy1qcufei3wi/z235Q27HT4tN4O58QnyCWlvVTFZ7S/TuuERP
3bmOnrpyOzHb9b0Di5xjF48TMx6DrCVF55Vvqbw/qPMZ7+Oy6MzWlhm3EVvL
vhgsNy6yvoL3837vsqP1Pe6xnvVRcpbyKWuno3wYLHZp9J3DMuTLnSz3Yq7y
m1nCQ6LvgTNk8lBzwzAEl+R/jYv4mDrTnGmnuBHq5Hh+nRs762O4K+4OKuQb
4X7e1dNInhF9+6LvBSerf9B6Zy7hV/RRzLuN89Re6S5y+W819tnTSP6Nnjeg
EJv0sAEP/I7vo571frgq95vy5Dv7QOux5mrZXwf99TkAGRiIZr5LLdAcTZzr
XzVv4gZu4xYe6uGT6PePj/AxZmOdPrMwBqMxFm/gvtr91ErDi+gjtjdq9DMD
t3AbZ/Q5XGyO52mo8d3qpdd5es7D7850GjfNX5PnH8w2v9GeZuoUcg931sZ9
V5v/w/jl6Fsjb4LYs3KeQ5L+U6NvC/fgydE9OfskvmDfeZQ5ez/vq5L78niM
i/7mGe+R4xB3F1fK3xqn6muL/aPVycIozFQ3Vkzd6G+FtZ5Rfc8TPV/T1wSu
b65QXJm+S3FKz1k8Xb5D0ViPTe0pFrMZV91bgblW0Tead4hZyQflW80HeBWX
cLV7Gin/M2J74Jj9qfJnmhuEtc7cWQ9n9brGc46YnepuR4FxJ2tnrGVH/265
Gwqi77Tcx/mB+0iLfpvIxYDou23PUXW2IV9vi7BK7EvW++J53LOvBqvVSBL/
p7yrPE9RZ6vam7HCuKO1itb//5/mPywXYv8=
            "]]}, 
          RowBox[{"-", "5700"}]], Annotation[#, -5700, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1XtM12UUx/HHrblSaV2Uq4AKgjbXbbqVM0tDBoLKRcQbuorJ2gqlLSbN
yPwjtKmFoGma5AVduu5b4tbU7IKtpktCvLtJTs3lpYtLQej1XX+8+TznPOec
55yH7/f7G/r8wqLKPiGEI/6sHBJCTEIIdekhDKCnMkI4g9M4i8vDQriEUXEh
XIwNodl6O4bEh/C+nI1Yj3i5G2gC3USv2y+h1+hwdR5PCiGNPkbTaSYykJsY
QuHwEIpRhBx2En+KuHiaiAQ86vyrzj8h5iSOo0PsoeQQWtGeFsKvaMNpe6dw
1LqDtotLzwyhUz/b9Pcb3U4HDQ1hbEoILwwOoVyfV+k557a6k3z751JDyKOx
5o3Du+x6JInNETuYdjljDV8jGpDMlyr2HnWW0X70gv7upkvNsY7+KecvHOf/
W2/rxX3Dv44eoO/Rg7TD/jGsZX/NHmWGRusGLMcuvjo60DyDME5stfPf0Nts
fa+gr7N7aS19h87j72fm+bSP+Of0fN7d5kbzqJGM23zd6EKbu6gQu1ufB/Tf
KbZa3rPWWZiIbEzCHWe8JL8n6kHeSvqpsz5Dtrx7sd85D9Bv9V3Kn2iGgeo9
iEG43zkj/c/uoylik5GKueyX+ctonLhYxGOJ3n5QqzW6B3U/EZNED6s7Qv1M
jNVHm/5a+MapdRe7lr0Qi1CJV1CF8+pXmHsBhqm/XP0btI5ukbtJbjq7S61u
rOBPNGsT/0Fn/Wt9C124ja1yqjxn22is2nfkVLPz9Zihznb+GnZzNKv9Hvu1
7Cn2u+XfwVDsUP979Xuse6O7de5OOTv5R6rTKy+wV/F/zF5NR9BZ5piNadZl
dC7mRM+qs75zzga62N3V4Igag537kPUaew2oj3oV0yi/IXoWMZVd4p6n0Brs
d28n5e2ji9mTMd1+Hk0Vn4IheEtPP6n9MxLEbxSzV/09aMFXeFtOrtgclOpz
BkpQx/+l/Uo11ppzubn7R/8XetR9lPP3itun9g1zXENf+0vt14vPcnfp8ocj
DTHiBuCm9/CmvnvUz/B+9ef7h92ProreAf6+1hPlX1LzIl5U99XoGVJ3Av8F
vk7cYlfyL6J75Ky0V6ivH6N3iP86/wJaQbP58/TRSf8Q12S9xH2UO+9NPS1D
lrxfxI/2To3BTHYpsqxb1HjKejzG4bC4p+k0eQWYYD0Rz+CIvQHi+yMGRdE3
x3nF0bfXrPP0XkDL6DR9F1sX4UP7W/S0DVtRwfe52b/ACbHHccW6Sdwj9GHM
d2fzcMY5T5rtkHOeMF8Zu1AfHbSAzqG7o+9e9Gyyq8RMpQfYu/iv+NbPiu6T
fzbdrNZMOkm9Uvq7/dfEfaCH1XQzjRW7SdwM++PFldDL4j6yv1fdKdH3SUw+
bWHv4J8uJo/dTifTYjpGTLP80WqdZjfRM+Y/i2PRb0ra/7+b/wH/rh4b
            "]]}, 
          RowBox[{"-", "7600"}]], Annotation[#, -7600, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1VlQ1lUYx/HTMG0zZqvmy/siS5rjRclFQlM2TRfFJAqE1jS2m844TQYi
gt00uXXR4gLmCCqI4IKgTpbjkllpXYhamalpy2QXlYpgGtI4IH3OdPH1939+
5znPOc/z//OaPbWs9I3rQggr/PNpZggVw0NozgrhXE4I998dQovnvEQI6+le
65+hUs4G8Xk5Y+Rs9JwvZxPdZ/1zVMlpFW9GO9qwn38Ac61tEW/Fg/Ztoy+m
QvgVD4lvs/4w/WpECF/jSxzAflwaGsJ2536M3+QMujeEM/SsPYl7QkhHboa7
ic+hcmQIr6SHMIdfFRFXRzy/ibmYGtd5DdkhlDljnDuW0wrMwiln/IgZ/Nm0
Eu32bUG/s4qTIVyjJXSJ/Fvdp9VaGzZjcby7PR/QxXrNUeeXYSF8wtuBAf5r
5piUm8Lbck7zX5Jzi7WX6UG1e/Q+yR0noxTP4GmUOO9vsyum3XQGLuN1zMRW
fgVtVnMWPRTfnTu0iDtpvTl10Qs4bG0ev855VWZcT6vpVTO6mfbTG2kfvYl+
I7/HvitoVudf2ouj/OXOKuJNRAFmukePeo/rdRCKefPUKZFfp+96FJjjeBRi
obU1vIY4R/F8cStdLV7pfa2idXQBv8nzz2r+ZF6LnHOaLqQZ8tdaa8Tk+P6c
P8W937GnzVoRJvFL8RQW8VO8ZLyHelflL1DnH/3Mp710g76OqfE9ssTrvZ8v
9NJCM8VH+cNps3gffx3NEH/HT9Em8V7+WpoUf8tP0AbxHv4aOkx8JM4Xjc57
gf88nsNb7rGatwoJ90xHB2+Mb+EgzaVn9DFUP0NQKC9fzTR7D+vnCE6Kj8dv
XP4P8TunBWb5iH3HxOXi330H48TPyh9wxmDPEzzvit+y2dyl9vH4/ap1kt4p
PkHvoLfHZ36xWiUowllxob4mYDyKMBG5/HdjD2ofQkfsAzc44zH8oWYXP835
7+vlPaTxH0WTnhpx0XndGPA3csXMerCSv10fKbU+otfoZTX66CXaT3fLq5G3
DEvj75K8BL89fjvxPSI9vjck0at+nnM79PNk/I2KvdDp7jQNf+IvzFH/Cffp
UqsbJ8QX6Sl786wPtudD3+QK7FJrN857voBOjLa+k5dtNn3iHNpPs8yh06wy
6Qj33UFH0nw1p5tThbjGe6xyXlf8excvt68W1bxaa2W8V62V02nxt40/1v4H
kIy/meJ6/mx6/Sgz0Xc7uvW+lL8MS1CLGox113z7NsrZhPv0uM5c9mT+/3/K
f8tTDpA=
            "]]}, 
          RowBox[{"-", "9500"}]], Annotation[#, -9500, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1Fto13UYx/GnNNNmIye06dzm9jdDg8wiE0PTorALvdA53QRPoe1o1Kbu
4PwvMA83ggnG0sJCQUFyzgqWiAZOxbPeKYLmvNimlduynBfR60cXbz/P8fs8
3+//NwtXfbJg7VMRUeKf+WMiOsdHzKMV4yKqcyKm5UXU0Ep+sfh6+hl/ungt
beAvEe8riNjA35cfUU/7+UvFPyiK+DA3Yhj/WQzHp3q3ZEe8mYoYwZ+MSdgn
tl3uOzpfbh5mjI3INWOrWMWEiCb7bUQBOx+bzbpCy806adYpVLxktr6P9R/T
V84v46+hpUmcZprTLveGudX8SlShXE8FfpJrVfMjHepOP9Mq8Uosnui98Kre
KXhBXRZ/NCaan+O+NYXqUY1S/UvQ6h477TtK/Ze0xz16USbXbP8M9i7xDv59
9gOkxTPpbvHj4r+z/03e1D5/sEchCyfk/qQP0aInm7bqOSnex+6yWz/Nezni
c/kb3myA/zce4Wu1WfbaQ7+15zJ9y9Fu/zYcRbe6Br1dtJEOuudce0xx5mN2
vVixnkUoQYu3PqJvpHOfxy7nbnH+++wv6FXnrNIzV+0JdzpAX3PWfvo90mr+
8r7H5e47vxe/6W0Q3+ysX8T3qtuTvC3qxHvV55rZ435tzh7LPkK7+W/pXW/f
lN9wIPlN5BYj5Zx+530lN0culXyPds8UWydWb8862p+8Ja6b857cu+jAVX69
b+cjPY36m7ARe82b5ayZaJBvRLP4JnQ67xv507RJ/AxtEU+jzq61KHR2EQ6x
D2K3mtny7+CWmQfECtxtP82jt/3G+XQcasw8rW6l/qVqT5lVRlfw5+CJs+7S
LuzwrlXeoBLX9ZUmf9fJ+9Br/KPiV2gJf4P4ZfYl9L0YcYE+kL9I18kVqznP
bhM7Sxfya8UX0DP8H8Sn8Y9503bcTH5TO3Qm+2Kq/Cu+gdcxGYPu1KHmjppJ
+grZRZhq/8NyKXYGRrAz8By2Yhtm6ZmJp9lD8I/3eIwcu3R5j2x6j46hT8QH
MUzdUDyDZvuMTN5ATa9cD7qx07y0fDr5xjHgHd6ma8xarf5X9XfUnBv///+p
/wF0+dPi
            "]]}, 
          RowBox[{"-", "11400"}]], Annotation[#, -11400, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1FdszlEYx/EHFSPE3qOqNiHWhRitccOdIkIktGYQEgkVFK1w60bVTIzE
DLVaVS1CjKKJLcGVdCARbqhoi88bF9/+zjPPc87/vE3JWp+xrklEjPCnIjli
S9+Ion4RX/tHjO0WUWx9HYt7R8zrHvGiT8T7XhEfkNYj4pma+fxb1ZXIu4Gb
KMVLsVfIEStjtxgcMU7PcuvKgRFVKRHVOCjnT2pEqj6HrB9Y38fpARGnUIEn
PSPq1Y6xHovRqJQ/d5C5sER+JgrlFJjxEl3KzsJ8tZPMWyxvA/8vdSvUr8JK
POUbr+ac89Syz9MO8k/I/9014rgZT+AYdpk7D6v03ElX0lz6w/1U6pNk3RxN
0AxN8VNsC7aiSO8cug0NyMMulPLvobvRiGHubDjKzXHUHLfpYXqLHqGZ8vfR
fOz1rQrofgwV702H0GnmaYEy8fdmv2vWd/QeneG80zGEfUevN77JWvqKrqGv
aYE5DmAT+yN7I63T9ydq2dnsKlqDahyV291+Xawb7dmVljhDZ9oJ3cQe87e3
PuAbFIsV0HbsCv62NJ99jX8fbcN+lOijrpV1vXVrekW8ZeI9oYvYIfu2pxn8
s/GO/63v+AZLvacz3sAZ3yHLejmWoUp+O+evphfdx1nxQnqOXqBFYjViz/V4
gWeYJTYTaeInxUrd80J3sQBh3yT+DepmJX4bYlORjgZnWa1+DbabraPfQQ6d
6zwZmINMNaOcYyRS9SpNvC++RvU7aJF9i3ENJWJX6Q1abr8yfDNPCl9/9EU/
JCOJPx2f9ajzvXL134ngm4xks9QkvqnYZv7sxPvz5ieKfeSfwz/FPGlIxxfv
5TNmyPtEn5qhllbSe+a4iwa1693xOvx19+HcA9zBYXauHnn47szf8FBsqj0e
0Wn0jntZlHgDdAp7gtxCed/NNEbfy4k3kfz/f9U/AlfFDQ==
            "]]}, 
          RowBox[{"-", "13300"}]], Annotation[#, -13300, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1ElMllcUxvHjCGocEAvaWhUQMNGFOJSUWGscqyuja1tlU+vEAk3aClpl
MnFC65BYp8SNsWocQVZNW6digpoq2lQUF+KAgE1Mg40m/t508ee557n3nHvO
fb+QVVyyaE2PiCj0JysnYhZm4kBmxOaPI+Zaz8FsTPow4t9REd/aK7L3cmxE
B9rRhU4MzIvIzI0YjolyClDu/HTnP8cMPFFn7eiIdUgdHtHES6GrsyPWYBVq
P4oooVtpuZrbaJ1a9dg7xh0jIvbQH7FSnQzxefdfwFnkis/RPHqR5tM6+ol7
UuhUek2Pl5OZ9Neg7iVc5V3BL87319cKmmnmb2g/8b6REWnOL+YdS3rTYxke
66Oet1PdvtZrnW+lj3CR34f2xkPMk/9WTov1eXs75PSyLpXzgP6Ns/zt/PvW
f2GhuCkr4ri3GCz/pvVJvQ8RpyVe8u76SdVjL3mtZnmENrM8wUh9V5i7Ejv5
tWhWZ7c43b29aUHSB51Eq+kAfhXtT4ep3e2OdNrmjqdYab2UV4xluKveUf4O
tbdjG1Y485W9fmpsVmuTM1P4k1Ek/hSD7NfIO2hvAX8+Cs2Wqecy3n/21tMM
8Rn1KsUV+Ik3z9kvMB4T8D3va3vf0TferBu31J9gpp7ueua3MjSZGWk4iZ/R
6kyOHk9Yn8YpZIv3efssup92Z+hL3cd6GMO75r7r+ANN+r3tnd/ZvyFuxC3x
TXTpoV3vs+Ts9t2niT/DVGef818kyO+U04WBen0l765em3EIubyDtNt3f4M8
8UZxQX7EBjpI/Ke576BTrX/kd9Bc+3XufK33o2a85+wRep+W6WGJvN/MNkdv
v9LZtFg/X/KXqdVi1ofo4L1Ek7qN6rbpYYTa+c718Fbj6GTxYXWr1NnI66tW
tXlqcMOsP/BSkt+UuBIV6CPexR9Ka5NvQsvd97se2+Vc0kMD6nlF7n/OW26e
F/QD96VjGKrduQU1SFVjk1qlzmTn/P9/7T2cVcF2
            "]]}, 
          RowBox[{"-", "15200"}]], Annotation[#, -15200, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl1Elwz2ccx/EvKpaQ/BlSIkgIKuVgEsRYE1IGtc24lEPHjM4oWRyoPSQO
ktjXm+XgqA5CdEjQxthr6aKuxoFgJloz1jFev+nhnc/zfH7f7Xl+v3/yllUu
qugQEWP9GT8sYlR2RBEdh7FYmROxOZ9+GZEzImKT9UZswXXe0YER12jz8Ijl
cnsOiMjAcBTz8+kw/IyO8k/RTv0j1shfi5R1g9w61GMD7yeswwDx5Wqst15F
75jld7TJeSL2Gf1e/6f0hd7/8Z7Tkf0i7loX0BR6DYrYr+9BhJoHaCb/sLpH
cACHcBDvsiIuOnczLuASWnBR3b/yIv7Gn7icxPBSar3RK5Mu4C9Eu365QyMq
zLzMfJX0B7Gb5WxBnhlu8Kqtb9LtuRFfOMM2Wosa7MFebFL3qZhz6jSh0b7A
HVzgLRxiLtpLvUykkIEyeVX8YudZTSfpMxkTMcYcU+hi/V6r01u9nvbt9iPM
/BUm6HPGvk1+I32jz1u8Qwf1+or/wO9DP9Is2kQnyztP2+X9Ql/Re/r94fl9
unpwxCf5s/iP3X8ZnYlvUMu/aZ7ttMl9zkrelZxKNX+U94pfw/vkWW0yszvu
gX/52+z3O/M+pNvP5R+XcwxF+tyX8wAr1ZvKeyhmj5l2YheGuLN63m7rE/qV
Il1cdyz3PrvJq7K+425u4679A7Gv9c3R6zS9KqcVLc59y7PbybvFdbGznWuG
+qfM8N4dDqID0Sz2VzG/4UrynYltTda0UZ+zeJR8a/YP6SX6Dy3Rp069erE7
aF2iaEjeo/0KsxY6d2f3moY695LmjN2THOsGZJm5b/JtqfUM5dYfzbSKnhQ3
Ro19/BI95/OX8ufRJbTFeWrElOhXimmYIG46LaY75M01+xxk8t46Z4qOTr4t
NUrV+M45Mni1tCh5L9aFNNec37qjxWK68l7I7UJf0m70OU1LvmfPC5PfnVkG
ewdfy92qb765q2lB9v//zz4DFkq6bg==
            "]]}, 
          RowBox[{"-", "17100"}]], Annotation[#, -17100, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwl00lQz3EYx/EnyRIHwih79C8GxUXFjGW4WMZMO7KkQjlYTsnBjBmZsXTX
IYTqzI2mcGCYsS9HTZ00g8Iw03Lx+o/Dez7P83yf7ff9f//ZtadLT6VExBAG
MiNyl0bULot4mBvRPj+ijv1DvJ6uXxRxWPzEwohDtIG20YT4yjy1dBVtFK9a
HlGBSrRmR8wQT8d0XONfxXVMWhyRiikLIr7qlUaz9MnE7ZyIDvSuiOhDq76j
dvopv4Odotcd+tl+j+R/pAVLIj7RHv5jNXfU30U/+wsmOXtuzoA5UzHEnkbT
9JyMmqyIV/JfY9DZU/PesJvZTTiHC2Y+Ee9hV7F300q6h94Ub3ZXE+acp7f4
K91pHgbFqvTah0r8Tu5iz190h/rtaLDDezUn7fSBNtJ39Jb4W3pczpj8F+py
fU8CMxPuF/3iCXOOmFuD7/yjtE3dLruVqd1Jy+kNulqPNajhF6srRBE2oFfN
X3f5B03Jd2B+PUbcT7pZw3Su2jmYl4S/TZ+tyf3k/VVzlb3WDlfoH/6o+Gb2
FsyVP1vdLGRgre8s0jefljqfsF9Jck9192mq3/oBLfG9pSjDD/2GkSc+Qo/R
SvEKlKOOX61PLT1I6+kzs77ZaaNZ68wqpgX0ovoBs7rUdaPQ77MBOewu54PO
uuV2sjvpPdpFD+i7H33ON7m3jWjxri9hr7ffou9ldCXvIvkm5Z1RdxbtcsaS
98Aep9X8cbu9lFdgbj7mOMtI/P9v/gMZEorh
            "]]}, 
          RowBox[{"-", "19000"}]], 
         Annotation[#, -19000, "Tooltip"]& ], {}, {}}}], {}}, {
    DisplayFunction -> Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, 
     FrameLabel -> {{None, None}, {None, None}}, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotRange -> {{0., 6.}, {0., 4.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             
             RasterBox[{{{0.39919122760657544`, 0.0492162102994634, 
              0.39919060066481604`}}, {{0.5255551465972571, 
              0.06309431557759822, 0.3911910564662876}}, {{0.6423363837895207,
               0.08010341501917422, 0.38245371662190875`}}, {{
              0.7591158986795438, 0.09996447838604645, 
              0.3723070529377879}}, {{0.8603431466926151, 
              0.16380397667153132`, 0.36370734676748023`}}, {{
              0.9014801168309076, 0.3084694089821446, 
              0.36465113779091757`}}, {{0.9406335156458691, 
              0.4195662844753809, 0.3630790770121053}}, {{0.9778076384909364, 
              0.5198868566849905, 0.35865501133728217`}}, {{1., 
              0.6205060468129027, 0.3888542952158504}}, {{1., 
              0.7259142967408232, 0.4824721480486498}}, {{1., 
              0.9779017301455748, 0.7232824566953436}}}, {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {{
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -61.36363636363634}, {
                    Rational[
                    15, 2], -61.36363636363634}}, {{-7.5, \
-61.36363636363634}, {7.5, -61.36363636363634}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -47.72727272727271}, {
                    Rational[
                    15, 2], -47.72727272727271}}, {{-7.5, \
-47.72727272727271}, {7.5, -47.72727272727271}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -34.09090909090907}, {
                    Rational[
                    15, 2], -34.09090909090907}}, {{-7.5, \
-34.09090909090907}, {7.5, -34.09090909090907}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -20.454545454545432`}, {
                    Rational[
                    15, 2], -20.454545454545432`}}, {{-7.5, \
-20.454545454545432`}, {7.5, -20.454545454545432`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], -6.818181818181806}, {
                    Rational[
                    15, 2], -6.818181818181806}}, {{-7.5, \
-6.818181818181806}, {7.5, -6.818181818181806}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 6.818181818181834}, {
                    Rational[15, 2], 6.818181818181834}}, {{-7.5, 
                  6.818181818181834}, {7.5, 6.818181818181834}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 20.454545454545475`}, {
                    Rational[15, 2], 20.454545454545475`}}, {{-7.5, 
                  20.454545454545475`}, {7.5, 20.454545454545475`}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 34.09090909090911}, {
                    Rational[15, 2], 34.09090909090911}}, {{-7.5, 
                  34.09090909090911}, {7.5, 34.09090909090911}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 47.72727272727275}, {
                    Rational[15, 2], 47.72727272727275}}, {{-7.5, 
                  47.72727272727275}, {7.5, 47.72727272727275}}]]}, {
                Directive[
                 GrayLevel[0], 
                 Opacity[0.5], 
                 CapForm["Butt"]], 
                CapForm["Butt"], 
                LineBox[
                 NCache[{{
                    Rational[-15, 2], 61.363636363636374`}, {
                    Rational[15, 2], 61.363636363636374`}}, {{-7.5, 
                  61.363636363636374`}, {7.5, 61.363636363636374`}}]]}}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -61.363636363636346`}, 
                    Offset[{4., 0}, {7.5, -61.363636363636346`}]}, {{
                    7.5, -47.72727272727272}, 
                    Offset[{4., 0}, {7.5, -47.72727272727272}]}, {{
                    7.5, -34.09090909090908}, 
                    Offset[{4., 0}, {7.5, -34.09090909090908}]}, {{
                    7.5, -20.45454545454544}, 
                    Offset[{4., 0}, {7.5, -20.45454545454544}]}, {{
                    7.5, -6.81818181818181}, 
                    Offset[{4., 0}, {7.5, -6.81818181818181}]}, {{7.5, 
                    6.818181818181831}, 
                    Offset[{4., 0}, {7.5, 6.818181818181831}]}, {{7.5, 
                    20.45454545454547}, 
                    Offset[{4., 0}, {7.5, 20.45454545454547}]}, {{7.5, 
                    34.09090909090911}, 
                    Offset[{4., 0}, {7.5, 34.09090909090911}]}, {{7.5, 
                    47.72727272727274}, 
                    Offset[{4., 0}, {7.5, 47.72727272727274}]}, {{7.5, 
                    61.363636363636374`}, 
                    Offset[{4., 0}, {7.5, 61.363636363636374`}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.3999633796890805]]}, StripOnInput -> False]}, 
                  
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "19000"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -61.363636363636346`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "17100"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -47.72727272727272}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "15200"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -34.09090909090908}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "13300"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -20.45454545454544}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "11400"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -6.81818181818181}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "9500"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 6.818181818181831}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "7600"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 20.45454545454547}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "5700"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 34.09090909090911}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "3800"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 47.72727272727274}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    RowBox[{"-", "1900"}], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 61.363636363636374`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.3999633796890805]], {
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.5], 
                   GrayLevel[0.3999633796890805]]}}, StripOnInput -> 
                False]}, {"GraphicsAxes"}, StripOnInput -> False]}, 
            PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> True,
             FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}, 
            DefaultBaseStyle -> {"PlotGraphics", "Graphics"}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"WL14DefaultDensityGradient\"", ",", "#1"}], 
                   "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "20063.32404079967`"}], ",", 
                   "1834.9967622470765`"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "19000.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "17100.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "15200.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "13300.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "11400.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "9500.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "7600.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "5700.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "3800.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"-", "1900.`"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[0]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"CapForm", "[", "\"Butt\"", "]"}]}], "]"}]}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.954301396857583*^9, 3.954301482875987*^9, 3.954303750456736*^9, {
   3.9543076561303577`*^9, 3.954307674776061*^9}, 3.961304097794942*^9, 
   3.9613161543403482`*^9, 3.9651228456082706`*^9, 3.973130280487884*^9},
 CellLabel->"Out[36]=",
 CellID->1288177192,ExpressionUUID->"1876a654-970f-4115-9423-43654a110586"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Mxy", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "4"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"Contours", "->", "10"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9543014472442617`*^9, 3.954301465185863*^9}, 
   3.954307634230027*^9, {3.9543076828678417`*^9, 3.954307683117247*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"1d6737ac-9f00-4e10-844b-74d032811388"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJx0fQVYXbnW9uHgbgeoT93dbZqUeqde6qXu7u7uU3el7k7dqFJaWlpqUAEK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      "], {{{
         EdgeForm[], 
         LABColor[
         0.2374577454874495, 0.4502326479674301, -0.29344758919909575`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFlstvVVUUxvdp7/ue3ht1YqW9BSXAADQdtQNhIISBUQdGMZiAWgciMdo6
cALVAXHixIiJjX9BC77jiMCgNJYKLdGgCTgj0tZX07RgSW878fu5PsJgZ6+z
9trrvb59tg298/zbHSmlv7U6tU5UUpqopvRyIaXP6ynd1OEz2p8Uf0H8lSyl
46IndT6aBW/e/NQRdEPk5UrcPSf+G6K3aL0pelNrXfS72uekY0kymdZtfRfL
oXObdDxqHz6px90XmildE+8XrRnJtCtBo6s7Dz2HJHtUvFullC5IplQLXYcL
4eei1j8Kco++d2tdlMzjhfAP37iPnmuyNV8KPTuyiOVHrSnRp3X2uugsj/Pf
LTMn3oru/qrY91bCFjnbVQvb2MVn/CUnj0nPH4r3tGwelK5Z+dHsUu60Pi6m
9ID2Id17TastG1vyyEdfHrZmtXZ0xL2Dkh/Rviq9rY6oRY/2XupBXbX3aXVo
lfKIuaj9lPa3XEd8RX45i73lu+QKefKDbI/55P6a879YjlgGdDZWjW9oeuTp
Yth5SPF8KvpB7f3FoHtc927spagzd7HFvmD6Z+n8Setfnc/Xwsdv5P8jureR
RS8tin9X+1fN4HG3Kwv9+I3Px5Tr67pzoB79RW/gJ3XZqERfTepsu3w7K/1T
olviH5bOTdVgQ+t4FnvbdLdjaGl9qztP6O532tv6Lsin9Sxy1bZ+8tHvnBRr
IYOfpXL0P3170z7RJ5/J9jHRZek8qX20EnHSp61qzM5fteiFqTx4fVX3RiW+
oYl1q+NlL9ousaCfWRguxPyjn/2k6fdN03/0JHeQByeQY74uaZ/WOk//5HHn
rHwfrIUtZMrlwI5R15deoU74M2bf6Cf6ipoyR/TlvZ6EpreZLc6YKfoeHCEP
a5XoFfrkgGv9bD1k91l+SWu5EBiF3B3pG88C48j7c/WY6SPV6ElqAk1dwAzm
kdiZfbAGWWLHFnqIteR4yTk08Q0WY46YJ3oHPT+kyOWQZxx/6HN6ifMh24JH
XJey8OWo/cEHsOiC8wNukCv6n9lAPzm5W4m77zVCBoyBjz18vu7cjVs/MRP7
hGeEupMn5PGNWf+gEvUCG68Y6/FxzbY63X/g4ZfNkP+iGf0In3pRi521qAvv
BjR1Yd9lPvYnjOHg3lXjLDrmrJ+YiB88uWo+Pb83Dwza53lkFkeymOmSZw1s
xhb24ZX9BpGDkmnmCn0Paz/TjBnsyQMnqCs1/VM6ZrTvF3+5ZlzO49247Fm+
Ypp3hMUZ/lCfNfcQ80D9wL22Zbi76j4Fx6CnXa+ZSvQfc8c+Yz3T5iND74NL
5BPcpEduycff6kGDqWDkKeP793lg1EI9en6P8X/MGHLPx93mn7c/ve5b+PQe
+vqN82DLiOd01jTYMmm75Jm+PuKZAo/b7qvtzvFF54R8gF036tFDC7X7OAKf
93DONogbGWLf8P8H2NKlGfhIZ3nX/X+XXsdBfqHv+P0g58P2fd298T/mp9C3
YX+oVds9ds624D/ViP+J/Y3IDfLkB32d1sl7u2pbfPNWo6fPMvQ5GHzCOMyO
T8wFeLjg/42S8Xar3+ZN+8I707Y/9Hryf0LL/wkrfieJi1p87T4/Ywwf8FvF
rOz0vMAbNNaNO1/4X7D8ut+UAcvctgwY8mIj3tRDjfjf4j17qR66qRc4UFVt
PlSNKl2Rgw7n6tVGzOkrjcjZiuuFHewhwxsI1iwZKzr9n0lPDLv3ivYff/8D
kueH8w==
            "]], 
           PolygonBox[CompressedData["
1:eJwlk71L1XEUxs/v5r3Xe3+/e2/WUmlGFo6GIBSFQgoNQQ1hRg0lNSgOtTll
TS4tkUHUfyD2QtEUOmiDtzfXLKfANAy5OTXo4ufxGQ6c833O23PO+R6/fe/K
3VxEnEWakJU0oq85ohcZr0Xks4gugDP5iFn0PmQeewy8hF5ERtG3CxGD1Yjr
xLRjzyURPWDL2NvYvyjygtyD2K3YI8gC9gAxv4ntxP9D5hjF3gGfwjfJrK/i
cx7fRd7q2LP4/ChHbGAfK0Vskv8wvv3kbNDf5j5w9LWy9VP0/xb8XWZdHMV1
iJw75B4j3xzYNPnugz1AjmJ3YK8X3fOT1BzFVTFX0a+lrv2Nmv+o9R3///gu
8zYKdoQcW+hLvH0Ce4k8RP9DzhPoByoRT+mnG3mP7yGkM2dOe9ywb5C7A/sv
9n7823KOOVjxm7DTvLXjO5U6t3pW7228TTSbk7hph9rlSWQe30upe9VMNVvl
UC71+Ar7JhwLRe/0Y2oO4qIeN+D7WnwT13hT803oNorEDBO7lprbRWQJbKbm
2YpTa+ada/eT4CX41MG/qBZvP8l/Dnwh8Y09Axsh32LiGWvWt6qupR7Vaws5
Huc9I81KO9FuLvD2OfPN6fZ004XMO9fuH4FX8L+c+lbVg3p5jl1PfMO6Zf0J
/Y2G+gNbLVtXzfGqOYqr/kiv+GaetTiIi3pQL1/BG8TWKtY1w3XsAfB6k29G
t6Ob1+3rj/Sj7wIbpoI+
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.3120375340660039, 0.5267229230786709, -0.15611287746101535`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmFtsVVUQhvdpe9qes/fZWyRRoAgKtE9eAAEhRhB54MELgigSbwjU1pLo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            "]], 
           PolygonBox[CompressedData["
1:eJwllF1MjmEYx+96e+vtfZ73eZc2y4TSdGijjZnpQ1YzkZJoGJphDjgwH4fM
5xxVWoZpOKt8LtaMUCwb4a1kHPrIlCWbmgNmfpf/wbX9r6//dV/Xdd93bv2+
6r3JzrkaJAW5FHcugSGW5lwr+Kbv3Pywcw3I56hzWwPn+kPOLSZ4G3iF59yE
JWLbDS5GTpN7EnmBfwSOrHTnmpOc++3JZr5TSBH6RvQ31JtC6gLVsFrj8L3H
X07+a/g70LvQ1xIzmepcHjFtnK0J2x58v5A8Yufiv4s/myOVw1WD7VlIMY3E
NqJnkjsbzr/o8Rg29G/UL4NvDbaP4B/4K8DH8PfBdYWY4+AL5Hfjj3L+i+BB
ZCxCffqrJf46+pGIOL9Q/yl6T0QzzYC/Hb0E3yb4Z6G3oW9JUc4N8H1PvT3i
vN3gjrh620zMNXCYnL6Qekr1dUY763708556sF4KkO/UX43tQ7J2ZLu67Wu2
E5z3FniDp1jrwXrpD7SbM0gpvj/IQLJ2aLvMDzS7c8R3oVchZ+H6ycyrwc/x
Xw0rp5DcacysmvgmbJngMvxjqdpBC/XTkIX4u5EW8pPQ88GdloNe6OuuTXHm
ZeBSZB36PPi/0t8qYqZHxGnc9choqmwV+CLU3EX8Iuqlg7N9zd5mbrNviKqX
BHo5vnpPd9HusN3l7fCdSBKncY9ENbthYt7hz4Xzclg9h9Bb7T2Qe4f4HOLn
+Nqd7XwmuBcpDKuHUbgyYprNUs4QgOvi6t3eWC9cPrYF6EuIiYHfRvWW7E7Z
3SqC7x5nOYotgW8gKvwQ/xP87b5ma3fmMXy1gbhs5uvBDzzdtUH0lcSOeJq1
7azT15nsbDn0dJD4nYH+Btv5MLUqA+3e3qS9zU9RxdqfYX/Hq0B3yd6QvaWi
QG85jr8Y3OQL28xsdgn0SvRmZBKuA+SMh2UzXxZSlaIZ2ixLA+3W7sxy8I5A
b9N2NhTVm7S3aTkziD8U099gnIfBL4kfStEfVEJsT6DaNtMCTzO0Wf5/8752
aru1PyYXnOzpb7A7YHfhH/MWuQE=
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.37727463792245725`, 0.5936311849086808, -0.03598222244693665], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFl1uMnVUZhv/O7P3PPu/o1IG2KC3T0oRe1ovazjBV0w6T0UiLTjSmnbYS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            "]], 
           PolygonBox[CompressedData["
1:eJwllV9olXUYx3/bec/ZPO95z0t4o6DVNBW8TAPR6VlKTVHRjcpSnNssI0rX
LjQlwsi18Mb8h6JOS4zIPzeBOZ06nTrFnFJTd5VQmHiRBJri/JP4+fK9eOD5
936f5/f8e6uaW+pXlIcQWqEIGlsM4WQuhObKEJ7FIXwPfZkJ4W5FCOPTEPry
IZTBf4R9O/I8/E9jH45cj3wH//nwjWDcTEJowl6Jfwnwfr7NoWvLhvAS9EMh
hMd8E9AfBmMb8jnsq0goh38v/Lt8/wys/6EF8OXgL8beD43C/jLUAdbSMjAV
D/snZf7mPfwbwR9DPkcJswS+RIwesD8lp1fx3YCuQW/B/hB5ZGJfYb4I34zu
KrH+w+c6vt3IZ8h1HHIT8jJiFMF6A8wP4I/xlv3Yi3y/kVhX0D2GHwBjBt9G
6M5irxwSwo3UmMJWzsq9hP9f5P4nNA1+E/7Dy6yrKfqNeusD5HrkuqL5Kuhg
4pqoNorZBp8F8xq5jSDG28TaCt6BjHuq3p6AfuS9WfL5A/td8r8S+Q2/YBsD
fhfY4/HZgG0funUZ90y9G4XcQbx30DUT71f82yrco4x6Qbx7kWdCs7Ep9WwJ
Q1jnsU8n1+34jIXfG3vWFPMVsHpj11o9bODbzfh8kXFNVJsDmgF8B/imHd/Z
qWdJMzcndQ/Ui8/RdcSeQc1iNbpT2B6hm8n3tdAlsAawv4l9IvbOgmdEs9IC
nSafp8jDsK9DngpfS4yh5DaV995T7RJjqSaX4b+J3RvlqFzPQzU51+Rj8Aex
L6n0DGoWNfOafflcgP8HezX8FOgMch/fzCK3ft5zAdvQ1G//iZasx1aXehcb
oW/h5+bdu3bkn1UP5OrgHe9MrZOtDsw1mh/e+CjjGlfB9ySO/ZZmGPxxBfdK
OSk31VC1jMnhKti/Q5OxT0HXXfAN0C1ogv5OPCOalR3IMfjV+HRHftNo+C2J
Y+kGbIZfm7dvDt3X2CdBXZF79AJ8NnHuo5mHCP4ymOvJpYHvo9g3SrdKMS6B
9RrfHI6cY77gHdQuaqe125+B8W/WNajF/yJ4X1V4pqdh/xB5Ft9+xzeDqXde
u99KjD2pdbJpx0/hvxD7xYxv5iL4W4lrMZseLCf+Kt2bcsdcrd3Gpwa8FvB2
gbUzNa+clbveqLfqhlYknkHNonJUrn1F3xrdrBK23alzU81UO82MZkdvOIS8
O/ZuDEK3Y/dMvdON/I33v190b5WTctNN0m3SzHfifzT2LdcOa5e1M9od7cgT
bEeQJ2R9I69rt1LH0g06Evum67arZ68jH1cOGf9T9hc805pt7WifZif1LVNN
VVvtpHazFZrAtyvxKZW7pqptT9E26e7nfeN06xTjJP7tBc+WdlC7qJ3R7ihn
5f4cC2fx6Q==
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.4425117417789106, 0.6605394467386908, 0.08414843256714197], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmG1snWUZx5/1nNPDOc/znGctTsmSMVYcsA355LagTYj74EYjRkmws5uu
khgNyBa3mZRkrGUiKB/YojK2IQ6jmQgLY6zMse4FZGXA3kegwFr9IL5F45hg
273E+v95/c0+3L3vcz/Xfd3X6/+67s64c8Xty5uSJNk6KUlKmkeak+T3Glfp
9wtpkrTr47l6kgzVkmSG5qXav0WEX9D4oeg/KifJ1VpP0VhVTZKVGp/TmXad
7dP6tYbmPEnGKuJXJMmOK5Lks/quz8lc/fmeaF4RzW5979e4VfvPiuaixlSt
L+j7mNZLdO8a3XWXxje1XiYeE5JzyPTwhec1WZJ0i+aGLL4nOn+P6Nv0e5H4
H9F82jxPab5Wv/tE3665Rb+bkFnHDpXirhe1Xqb52xo3a93j9Y3iea/0Oiue
O6XXY1oXuu+c1ifE+7jGgqaQ/x3Z7jc629UUdsSG7A15v60ev9dr/6Lo361d
Pveu90uW7XGtJxehQ6OIszPsnwMaa0vhuwHdv1fjKf1+Vbpt17xHBsp05qTO
5prnaySimat5uuT/uXS5RnO5Ev7Fzwd1phD9uGjGK+HHY9KjX/s9uue47i7r
zPe1X8lDFr6jIz7EN5/Q+gad/0B8ZmneyDnTdOiOR7XeJFFS2W+H+FypvbXl
8B++w7fPOW7wVW859om9yc0Rf4wtoumwnV8uhW2nam9cNGMao83hV/z7deyg
9WAa93AfsXSqFDT4HV/i00el0+F6xGBRxF3sr2kKWZBpy6SIp226b4vODmhv
Tjn4ra7EfqfWs8txLzGMP7kXeRaZlnuJO2J9o3kSC+hy0WvkQMZB6wK/Nc6L
Z/LQ/cuN4N1r/jvti6nOl132yw7vT9E6L0WsE+cDTRHbxDB73Y55zvX7LOd2
+uxzzkHW3Ituy61jyWvyBJ63yZYviGZhJfJpQvd+UIk74fe8+eyybOT1JWMC
95JfJzWuLQemEJPrxLNdv89pva8pYpD9JZpbyxG77O21zNjhQTFerLufls0W
iuZ8JeISzNvle/9cBN+GcujGWtgCO3EHONcmeWrlwL8u0b8v+v9o/bc04pFY
IU6qpiE+/5jH73+kkVfk17fkrzFyTfuPaK+1GniEj3sdX/jxSdG0SM6fSp48
C9mQ8Uda18gdrfdXA0+nlQI/3jGegA1gxCzxmZ+FD4YkyzqtS6If0fyh9qYb
z0vlyEX0HapHjA6K/4E04nhE67ezoHk5DzrWYDg2x95gF7ym2z599fjWX4S/
F9iGxPwh5wXnlhgf0H2t8x3cXeY4JGY436v1Qen0kvWiBrGmDvENfa/yfNA0
fGPN98PS5XrpftQYiQ7E/27tt8p/n5ec82wrbHar8n5Y9C3lyGnyk7x+LY84
OJuGT4iPByzbAd91j+37J9EuE9/rdL67CNwlZ8Et/NBh7EVfeCDP8izw7uEi
Yh+8Jf6pmbltjm/wUato5+Xx7dOan9foFc1WyXYsDx2O55Fn5AI4vqIScQqf
1/PArH9lgefUmPWuWW2uNT/OA69/kketQ0782NWImvsVyfJeJbB9c3LZH9Bc
aESMXmxEzj3hvOMcWExtX2Oc3Oh4mGEZyFVy9qE06thb4Il+318K/vi63/hG
HtPPDGvcO+lyDSCXwJuzxhzimHguZ4HZg64B91XjfuJws3TepDFBHlXjGzFK
/Slcg7ALPgSr/5oGDoAHU1yfyP3zjcjLnjRiHv5gPviDDfiNH6bZp5MrUcPJ
3aWNwNLFRWDnTOMn57qcL+DfRmMg9hhwftHvgAHE6+v1qE83Z+G3faYBX7ET
2Phr91H0U49ALx1nNqx/OfC85jwg/jl7yef/ksb8RBoxvtC+PJIH/XntdxbR
y2woouavcO93qRr4sN64+pFxk3jkHmIJDB9w3BILna715NBir9njLujBQGon
PL9mG2LLO4qItYrk2Z8FvxP1yBXsDVZ8NwvcWqr9x4rAoaNa/yyNWrQhCxzo
qkXd5yw+4zzfoHmxHj7c67rzxVrUBnTmHOfRb389sG2be9UB9wTUBPBgk+v4
XuvOHcPu1cGC7cau1dWIPeQnbunxuptinnAtJl8mnDN/TwPrr8/CfjXbeoN9
tIf6QJ3Q/h7JeHcWsfxqHrnS4p4ZHJ1cjfwiL9EJ+7NXeJ+696F9ip3WOb7n
VAPTqAdV95P0leOuiQ/qzqN5yEatO1IPX+ATelDsgQ/Bm9scJ59shJ6/cM28
371xw/bk/UJOYyPs80AaPnxIfF7RXYu0vqPumlOL38yf8pp3EnzhiW03Gx9m
F7FPraaWI/+4+2j60THjEb4jHpClw/4tNUL+Lt1/S3PECnHysNZvujb8Uzxv
0v7cPGS5yfJwN/rQx5KvE8bFx7PoGelhB833UB68WXdYZ3R/Iw95eQMg1w+y
kKu3HnYreR+c3GesfDuPuCV+6fHxK3nQm4WNV2n/M1nQv6F1Kh3PiOZO1yhs
Sg1rsu7Y4H33SPRK1FSwYGUW8iHnNvEZTUOmPu2fyWI96r4L3dCrZNv9z27m
Q63G9uQP9idXep0v9GTc+x3Lu+qK0BG8BpPn54H/vdXA7e1ZxD19BHjc7poN
7q009vW5ZlAvwFrwmd5xaxa5eEy6/Lseex/LA6suGa/gQY38P4YudM0gP076
jdntvogYQK8RY8LH87hrSh71aq1lvr0RPQdvvqvzqL/TNE9KQ8Y/ZFFT2O/y
mwsdyd8lru/UeWIP3/W719xtDKeuks8LnItvGQfwwZvuCX6VBWY159FnjTgn
pqfxvTMPGy/yG/yreZxdrHlKGjXyrHjMr4SfiEfO0XMQr2D/sO9l74z3qZf4
CR/trsc745dZ+LnV/TbzlX5rn/A7A1z9hvsE+l94v2f+vC9n+/1FTHNXm2ie
yUJ+eueX3H+uNBaOuQ/Z7j6b+D/t+kx8H3aekq/E6VOO1WfTiBli5+k08pr8
Hnb8kwfkbrff8NxBzwM+ozO9Grown/Ca3uC035X05dTfC+L9uzxkoz6M+g2N
jviV823uG8k3/MH3cdPsyiOv6INmZYGv8wq/66uBUdSBzkq8Da5z/83/Kojv
+xyr9N097vmJTfaX+i3Q41yjThIHxAB25g1ALvMW2eGY5P9Mq/y/KQZ+QP4v
1SNvwPuZWfyPIcmi7s7xm4T4IE5+W4/fo82X3+8tjpOTtie24Z7VloHvraah
pp7yW/7uRsTYXZr/C033ghg=
            "]], 
           PolygonBox[CompressedData["
1:eJwllUts1FUUxm8782em839MmVJNjChSeYiPuJA2ao1xo9WERCHQ2kYpbnyg
JQImVI0diqJh4UJEiS9iYsBYogZLrVZFioLQoogRjYJuNMYFD1EDBaL+Pr/F
Sc77nHvPud+95J5l83tqQwh9UB5qikM4HIVw66QQ9qchvIrcWxPCuWII35fR
l0L4NxfCCPZn4W9GVyna5zd8m5G7lRBdC/wdWQg78X+NnPPhO8k5D3kDPhfj
fy+6ciGEeug++AXEXFC0bgf2NQl9EVumuVPIJ7F31oWwEt1ecu2jh4+wtSB/
iO9XyKvoZYQco/g2QHXYOqi5lvhZ+OTw34o8E35u2b32EPM29k3Iy5FnQovh
J9BNzjvHOPU2k/+l4B7US3fZvgfIdzf88+ScjO9P3M8NnOcD/M8n9yA+n2LP
Y59DvtPYF2C/FnkEuY2Y6eqHGleR+0roqPpHt6LoM14Hvx6qx/cE9zMb+4zM
s1hN/Uvh36deI/W2EbNDZ8P/eu76XeRPkCeRv4lca8hRgN/F+WbA3wLtw3cz
dAXx3fhsgX89dm6daQ7xu4m5jbQ3UnMP/BTsQ9g+pp8zmWeoWc5Ct5X4Yehl
8jWgW4rtgcx8Bboffg/0BHwVaiVXRo2DBd/xk8hnM+eeSg8T8L2crzvyTmg3
rsFnJfYV0Cj2qdpZbBNQP/yFUGetdRel9pHvI9Dc2Duj3dEM9pK7TP2uGvdQ
Dz+Azzn4s9DVyIvwacf/T/wfInYKOW8i/wvozoNvTM3/AT0GfxCfy4k9jtyL
PEx8f+QZapZF6M2cdTnsR7Sf8Bn5DyeeiWazHblZs6SfvoLvTHf3Rea766KH
Gmwd9Jgr+M7by94B7YLexCD29dSImV0DNQ+RrxWq6izYx0reUe1qK/m2x37z
evva4Vdi34HuQnf0FvLsxLvSxrxuL3nHtGvawSHky8re1T7qbaP2WOJd/xp5
N/HLkeuI7yT+Yfh1+P+Vt+4Y9pbUs3+cfhqRF2mnybcYeSH8g8QU8t7JpfAp
ugMFY0wtd7Mr86w1o7/p59fUs1PML/DVxHf9jDAQfm1irNmI/BT8ztR3JcwY
hd8U+yz/QO8hV5DfiXynzyFv0A7B10MbkTugb7CvQ16F7Xjis8jnxdQYICwQ
5gn7tLPaXWGQsEg5lEt30qNeNbO836ze7v6SsUszvysz5gh7jkCt8EuI/yEy
pgvbn46NhcLkAWyfx8YuYdIS6q1GdxrfCnK15J7Vu3ayX+8N+2DkN6+3rxqq
pT9gCHm85F3SjLoyY5iwTDHNxP6ceFdPIVeR+0vmVVO1p5Pjx8g9q/fxxFii
HW2C/zL13yRMHoP/LvXbEGYdSr1T2q02dAP4T0v99wgDhAX6E/Q36M3p7f0e
e5bCEGFJJXGs3tj/b63kXVBPMeeJUmOn3rTe9pnYdyWMEFYcRbcs8k5oNx7F
/0TkP1N/57ySsUA62abh823knU3o7bPU2KocyiUMEZZo5mlizBR26k/Q33Ay
8V+oHMo1HPtvE8a/ga099V+rHbwTfmHJb1V/zDHq/QfDewJ3
            "]]}]}, {
         EdgeForm[], 
         LABColor[0.5071763423139369, 0.669174585608105, 0.1911978330990779], 
         
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmH+QVWUZx8/u/bF37z3nHkfAWNgKdHJYqCmBXULSkVVASRbGkoUIHZ0R
w1UYHGssRfnRuMKKMPwGGbAasWFnmuKH2EIaiyHSOA7JlJVNf9EUmqWNaZrZ
98P3Yfzj3Pe973ne531+fp/nPaNvX3rTksYkSUr6KWi8NE2S5cUkmaxxXSVJ
3mhOku6GJLkjS5JbRXBI4xMad+p5TfS9Ra8PaP5iPUleEZ8ptSQ5UU2Sudq3
Xmv7xaOu/5NEc7ximoV6t0V7L9WjV8kIjSP1LNL6p3TG9pL+Z17j3Uui2dvo
+UDweSF4/axg/o8ULAt00LCWx/qD4jVXPF+TXgN6v03z0Trrar17XP/XiP4r
NfNDjxGZ5UePBtFeI7p2PVP1rBfNWtEvlV5L9HQ2JUmTaC6SbF0F894S/LHT
qYLlP9BsebBHa+jL+uM671rx6MqTZKxod0mv+Vpf3WA+X2av1kuiv1jjugbb
Z5fWD4vXM3rOlmU3Pd2a31syPbQzRHOk5Hm35pdk5jlUY3+j5UOGQ8GnrP+7
i/Yx/n1csrzZ7FgYW3U8bNK7v5R9NueiUz304j98xmjvYMV+wtcvxHyb5iP0
fqSel8XnSvljps4borFRdnhM+7Pc8kwsmk970fMWzXsKlhuZV0iH26XLn7X3
NvFuL9mu2Ls1bNsSsURMPazxvtj/H511RDb/sG47t+i8cRqXlWz/1aJ5vuiz
ORe93wzdf1SxnR/T+hTxPao9H+bWCd3wV0vM9xc8tsR6l85rE8/G1PzeCNu+
lzpu/63xtNY26hmQfIf0f7z4H9TYr/jcLH4faLxL557Veov49evd5Zqf0Pox
za/S/JfYs+i9DRrP6Iz7xfN/OmNQNv5Xk/PigUafQ2wQg8Qyeg0WzedafCDd
LpFtNonnaNYivk6l9uFxndtTt/2fTW175sQ3NryyZDs+KLox5GfdOmL/eYnH
ozH/oG6Zhor2fXzY5Jxo03NC81XgVO75DsXcJum1seI42FPySLwNpMaSU6L5
rWx1k3T+ncZF4vsx+a75H/V0a/31zGecbLLfS7nnO7V3vsYXm3w+fjsC1un5
OzGKXpllP1yy/FMCQy5OPe4JeZ7S2CW6RVrbLR3v0ZiLdkTNOn1Ra4vFv1d0
Y4q20y9K9ktVZ1whHs9VjX97I/6JQWKRfD9V8tin9TnNjmFiGbmWhWw7I/bJ
60eLxu5OPdPF/1eimZYZD5mDiSNrxrobtP503bb4scaJNWPo32pewzbYbYLO
Hd9svMF/+HFiZj9i31F6Ls9si89pbA8+g3X7hHXsA8aeLPlsMJa4BItbC7Y5
fL+amWamxonNPps8xGZHwm7kJGvDa7br6LAtOckINoJVhwP3dmS2O3GKLbEt
eP5P/a+Kvi+3r8YEloIbYB51bXvR+ExePFN1XXsut23IZewPD2ywOLHO6I4t
92rt6YJxhlyEnnOez71+WPzmVH3GmNSyHwhsv65uLJ5Wdy4uDv2Id3Tm/3+l
V6fWPtL4kGQeEvhMHBPP/YnrQ2vo9ZOa8b9d5/8wc115MrNOyEq9Htps+alx
g6Lr0LtXqu4deqKOg6f7Q86D2v8F8RmfGw+RdX/Ubeo3NsyKrrHfpa4FroKv
5N+JiDN8gB3floxtdWPZ2LrlGRYyHcvN86h4zyo71sGx2QX784nEdYj6RJ/w
/Zrf1XPnw2DULOwEX3QkvjkfPyZFv2O9kFn3Smq8mxm6L657flfdcsEH2+8H
ayRTm87KUteEBzLHG7L1RUweCh9dGznaH/W0M/ofeon9UbOIqXERV8fKfsc6
2Abmk1Pk0NLoVQbDHv3B52CzawG2ZA6PowXbBFtR3w8EDfvpeVhnhCe5SX1G
ZnCN/mRJrLdVzQv6fVG/vpQbx3pCl9cqzn/i//ep4+DdmnELu2Pz4ZpPbvb+
gagDxCp5T/7PjV5lctTo8YEJc6O+nI56Sr09Fz0t8TUh8IqHPeTBorLn7CUX
T0f+UkOpn8T/bwIj1wZ/eINL6IrOyIBN0A298AP78QU5xBw+n8+MPXdTB6Lf
oNZ+r9l7sWdf2VjYF30IfRg6gOX3RZ8G3oP79I3zM8vXnbmfYv9W0R6sGU/A
FfYjJ35hHBsyb8ts93+k9smi8MuCEpcE+wbatpBhgXiNJl9y2wPsxiZXlY3V
rdE3XxN5fVnFdRTswQcDgT8LS6499OHUOerdDOXO8rLrEe9urBuvZtVtj87I
F2zWEXZ7qOy6MDViFQynn7lg9/MYW/PaDzL39rdGfz9b507X+vLMsYxfsP8K
re/T+kqtTwdry+71ifNzkQvEHfG3Oe4fPdFXk9PQ9kUMkJPE0OnMdihEn0aP
Bgb+vGbsAsOuLtuOpcAXdBwMbGsMenAoiT75bp3fUzEvniRoLtKeV2WLPHdM
EVsfR6yyTp4jO33ovqhT70et2tDgdXy1vmI6aDoy+5c+6O2oj9+RjN9OjUN3
VN0nbo9a9dOq+++P9f6lzDZ8R3u7U8fF4qr7OM7iTPCXkdgYXjFm4fslqWN8
e+Yegp7hr3XH4KiK70TbRTNM6zuid14SNtmh8+7RvJbaVszbovenloPFL1WN
3/SPw2runybpnE9XPrlbgG34Hr93So/3wlZrRLO24hhCFmQaiPvaqLAh2Lom
aLiPMu+N99AhP73zzLgfNtTcQ54MHS8LnviWuxZ+5/xx0V8lkSvk3FvaezMy
5e4VqePEPf0Ce9H9yajvezSeiLwhj+mJoCMHqAkHoi5wLnVvUuQDsbBKNhtZ
sm3oMWfn9tkcjQNVn/OU7PnN3PrtQp7cNp2Xuw6MiLo5texeER+vLLpmouO7
Vd+rj9dNT/2mdmzJbZMXaq4RxDQ4Rp1cGPEzqvIJ3hA38N5S9V2LXG3T3nrN
uU5vDhaj9ybxXh53FnpD8nhr4DC4Ar6Q37tCr4cz3+vIa/Ib32Iz/EuvTR9y
S4Nr76NR15el9t+9qeN/U+QX9sJuR6ruI+m9Eq09HXewvan390YNba35DlAN
2s+UjHf0HUOi96Cnw0/4iDtZR9Qb7nVg57NV92i9Iefm3DFAj0ktWxk4c73+
36n1c5l9sTz8wZ2SvKNPWBf3MnQBX5qivwE/1gdOvhmYib+uKxuL26M3Hx13
zJaae/qd8f0GW1IbVqWuFfdTK3LLuzs1DhMH8OQ7RkPFelO3kuDfG73pjIix
VVE76MtWxvxc5DgxQ5zeFvm/Ib7V8M2Gu+nJuJ9+q+oa+YfU3xvYS//zuv7f
ov9/Si13b5wLTt8d+HO+v4ycWhLrDZHfPUHTEXdt7ty8Y51cnJjbZ/TXG0Je
Yv58nY9vF0PiGws96YzI8+sz94+rwxaflZ3PaP0b8X1odcg1KzdmUDPbw1bE
wsOp/bUitd2x/8mq798bA8Pp8/Az3y349jMY33964tvFXfH95gLeg++D0ZdO
yu27jtzfNfi+8evUdZW99D7EHevw5FvF7LJza330TPQhw+ve837q+zf1l14A
n4E1YCY90rqg3xp7+6LfI4egB0ehBzuoY/1l917EH3E4L+5Yp+IO3hX9BzWC
fZ1xFt9K8GM9tR/oV6bGHZH7BX0teUV+vZG5F70iYoY+gH6KHpU6jh/ALHJr
evQkF/pX6Kmv1Nm9kvHrVfezb2XOA/oq6gT1+eroMdh3Z5zHf3oPziOn6TnI
a+LubNQBcoWcAVvo18mxeal7OfKZXMOWj4Vt4c0ZyPFR2OvGzPWXuyBxiA7T
ol9Nc4+jxPut3PLcXDVeziu55vVGTWUvdYo7zCPR/3MW9jgU364n5I7flRHD
0LJ3evTPxAT3DfKA/hmZqYXM8TG2eCDuHeg9LnTnjn3huwLYST5yHnIj/zup
4+tM8NwUfSb9Jt+jwbWaZDyQmeeemmN5VsQzPQW1BLqFiuei4upl7X1V9F18
f019h6R/GZYZ+8l/YhcfLwzcW1GzzfkeQB2ADzUbfFoYOnImPMlnYgVfLai6
Xs2Kdeoc9W545l4ZXb4mmv8DN3nXvw==
            "]], 
           PolygonBox[CompressedData["
1:eJwtlntMl2UUxx9+F7D3915cCwPphpUDq5XGpVi25QXN5DJLkARdbllm0sRq
3VBGbQ5n4YbIxRbrBk22VqZhAqu8As3c1OVKW/+Us9qUrppt2ue70x9nO+c5
53zPeZ/nXN7cFc8sqo8557qhBHQp5dzWuHOtE5zbFTm33XcuK2lnO9DdhDwb
ORfqgx/ynPsYXSZyJ/J5bGalO/cANBJwBsbTYNVDPvpjnJWhq4AmIj8VOreA
wIX4r4bfA96kNOeKOItj+wU2M9HtQz6BrpuzYeQ8YjYSaz/y/WB1oq9Evxia
mW5n0p1E7gBvKj79YK2HHPxS6El0Rz2LVYI8jK4Qn91JwzhH7gPo+4h1A2fv
on+BmEMZzg1C/5Dvg9i3coEj6B+Cfxb79fgeQp6HvARqIeQx5Br4f0PzfRmf
S/AbwcxAV0GM18D+zrfcAnL6Fv5RfE4gvw5mHPtKcsriLgexX4icpXzQD0Il
2H5N/M8TlvOulPnIdzMUg78XzEb0K7mTUWx/BC/zKnJGPov9n8gvIa8hvxD5
e+yXJe0bmuHnEuMgciN4DfinkKuQp+Pvwc8LjX8C/fzQ3kxvp5wrIqsp1dYO
8JrQjXmWi2qgBPxiMAaSdse66xH0y9CXg3cc3d34L+fb7kAugD+FT13ScjwN
34v9XHSl0Bj2v3O2LWZno8iRb1iqQdWialS1upiczhHvb2hOumEKWxjC0hvp
rVSzql3V5JfwV0NHwT+A/0HyuYzcj/yT6hnfdcgX+TYPGgf7bc428+3XgvEO
fE9gfAP249guCKyWVEOqpR58boOfBu0M7I30Vjr7RLVKzDZir8CnSbnic5n4
1ehPIedH5queyousxlXrqhHVSrNnbyEMYXX51st/cP/vEWsY/UbkRWB8A14C
m8PoaqA+3jdCPg4/xJscxjaMrJZ1NhH+Yc5Kwd8E/k7kdGg0w+5Ed6MaUi2p
J9WbWcR4E7ETORs+E7oHuR15ku4Lmxz47cT4kPx+A6+Sel3LWQf6ILJa15v7
8CH2R7DNweYMsgeNYTuLs6aU9bR6ewr5fEoutXzTGLoEOdbBt3DWD94GbD6C
zwkstyruczL8pshqp4Yc68E6i8/76K8QfyX4RzzDUs7KvRZ5CfwF4q1VP2F/
Bvx88Pai2wLeY+BdD1XDLwwsV82YHPCKOEtD9xb++ZplvuXeDt0K3wXGoQx7
I72ValK1qRmoWfiDb7XSA6WlbCZrNs9A3u3bHemudOcB8p3k1xwzzDi604HV
VjnyLfAHwLgZ/1xoaWQ1o9rZp2/C9y7oVc1HzpLoL4K5mu/p5ewCfApaM8F2
hHZFYWRvq28shh/07G5k04Xc7RmWaki11BvaLlCOk4n9M7Q3ZjNNs+2Kb2+n
nlRvZof/9yY+WaH1nHpPNXEdvs/71qur+P7n4L/ybXdoZk7R7ABzdob1cFlk
M1ezVzspG/8G395WO1C7sAk5LWkzRbMljpyfsDtr1zz07e5jnP2SMhKvnfoZ
/IzIZp1m4HR9r2+7Vz2p3szzbfdpJ2s3zw9s97zB986BnxbaW6gH27AvC213
KIdy+HWcLU9ajht862H1sna+dv8e33azalK1qR5WL2vmvwL+ed96TzM7k3yL
kVclrOeKtMvAqyJ2Ae8xju9IaLWnmXkf9gWB7ULt3CLty8hqXz2oXjwZ2OwR
prDbNEPi1jNbI8MUtnbgALb78elIWg0Ugt/uWW9qRmhW1EVWq5oxtfBRynad
MG/H/9fAdpdyfgTfD0Kbdaph1fI1gc0ixfhLtZmyWtZOejywnlBvaAZM1ff4
tstfBK8avjqwfwHt9BvxbQlsVmjnave2hjZbVGNbQntDvaV2bin8f3FVNvc=

            "]]}]}, {
         EdgeForm[], 
         LABColor[0.5709110903974609, 0.583163275778258, 0.2770008301715096], 
         
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFmnf0VdWVx9/v/X6/V+67794Yo0HR0cnKig1FqiMiRgULRUBRsaK0mEi3
YY9ZCQJKiZkZxQF0jLGMWKMiKsVRMwaxRFSkgwVdVkKRopDZn9/3y8ofd53z
ztv3nH322eW797n/Onj0maOKhUKh2lQoNEb7bblQ2BrPqOh3joGFzYXCrUHQ
JikUjohnU7VQ2FUpFA4K+mnxfzXG7mgoFAbFs1+MzWhU/y/xzqxoT4xnbbxz
afx3cvSPrxcKC2LOrtG+lBYK3WP8B9GuDvq+8fy5Qf8v8rpPxHy/ibHOwc/B
sdZB8bwb840sFQrL478erFsrFG4J2i51/c/YTUE/P/7/ffTnRL/cID7pD2lW
/9GC9vRE9IdEv0uD+tui/3LM97j7Y2OtMSX9/i7WfiTazTH+cIxdG3Mtjv6i
GLs9ninR7xhzdo3+0OhPDx76x1yz+S/6/SyX62LfU6OdFTQnRn9xUb93xvw7
4lkXMt7qOacGTfcYu8lrIdNZ5u2JWGt5tJOi7RY0x8czPuiGx+/xMX5yXbwe
6z0+He3p8dwc/d3x9HWfdU71WvT7eS/PRdvf42+EnN+NPbwe7W9jnfXB42tF
7W+d5+Vs+kR7Y9DvGzzsE89LMXY1ehV8bYlnY8jtm5LOBtozvBbr9/VaZxb1
357xM3ymn0V7nuXWL3iZW9Tv60OGbzVKhgsaJH/2e1Ls/5pofx7tKuvhcfHf
/OjPjOfyqs52VYPOH3kht7HWiy6ep1ODZDgg+jviOcVyu81yg7fb0Y3Y3yHR
L5bUb4Uuxfj/xnNNyOCTkNkGy5T/55h+qmXOvtrUNZ6HnKdUNe/9ZenaeOvA
JTE2KJ4vY51xTdrXsBhvF3wPdv/aJunZLOv/te4je/rYArLgXXQV+Z1ovfw0
aA6Gt/h9Vx500dbCTq+JsZlNsvWflNRi72MSyRl5T22Uf8Dem0uagz1iy8yD
PS+N8etLorvefA6M8d4l/aY/Kua8Kt77cya/MpR9RrstZDE8+t2RY9D3K+m/
qdF+2Sy9mFMS7evx/qiS/AXvYB/MdamfA5tE065RchteEP9DmjR2nflDJqOD
n6vj/7mZaIdYzujpyY3Sed4d5/EfJuLlPMt4nGWCHj1iXRoT+vBts+Q+J3T5
6kbZM/5gRowPiHa/uvqtov0w5vwk3r0yzmRp/J4U46/F2P7N6uPzmmKuBfHe
hKB7rqq2R8w5rybZfx7tlmgnmoeFDdJj9HlGzDsh5nkh5uwccp4Y/dNjrvmm
PztoCvH+wBhbE/owLNr7refYyCT7vdXBx20xvqxResScnP8O2wz2Ug/e0ngm
xviRse5f44yODNn+Mfodo/9C7G/fWGNa0F4W7csl7e3WRu2T2IEPOSzT2P3B
1zt1jedBv2/wf1is2zt+j08V0/6LfcXTKVFcwv4neV8D4yx2Bm2bmGt9/L8a
m0k1x+3xrIjxibHfV6J/XdC/Gb8nxO/J+OJYtxbvbo/2oXhndPw/M9HavL/c
caBtolhAe7T7+Hv626N9NPb4dVm60D6RPQ9znCIG4/s3V9UnFvMOc+F70Uno
iYWrY7xDIp/3XPDUPuadZx/Y3nNOiP6GiuT7cVH9pTHPCYloDmlU28H91xwH
Bwf932Ou0dHfGG3HeGd5PN/gn2OeRfGsjN8dYr4jYu8fxrtfBl2vGN8Wc50W
z8+C9pepZLqmQXpxT0U+co1jCTGlJUbVxN/Z0Q5tVvwmdi+L/z+wbl+W6Exu
ijnXhBwubBZ+6RjP+cYSR8b8h0d/VaN4XWb9P7pBfeZp6zn5/7pUZ7qpJllz
BsSCojEQ+Af7WFqRjdC+4z7n0M1nkUTbJRFWQr7EAPw/tLyzMGjeCJ1fG/0l
0b4ez+roL452clF4DN+yK9b9uCLZ0n4Uz1sNisPghdMapNfgD2yQmAYN8R/b
wEZmxJ5ujP4P4+zurisOlI2LKhXhP+zk/ar6+Nibgr5tvFuGx6BfUtZvcBZ4
q7vjPn3smvZgj+PfkRV+b3kumT1cU2w9wvr8XlX0zHFetJcHb1/Vtf4288A7
vLszxgcEzWVB80X02+bCjd8ba4A5nmqQbh9QlazBlMhnZ0HYBQxzfy55fl+V
jIjzq4zr8Gv4t7Ex/7RU8WFKtLuK8nf4urdKmoe54Re9R7+TmKta0fu9g/fv
/c7kVDp7Qqx7b0W63ifGlxSFdcA5xP8B7s8OvmZVtc8bUsVB4uGyJvExoihd
R+fHxXga47sds8BvW40nHqppne1B801RuDyLZ05VMePORunh36y32Co2i+2N
DJoRVennveFjFxLLM9kPdoTNE9vx74/H2I9jjnmN2s9jqeIU8WoLa5W17qfm
DYxHPCEOtdhf8LmBOVLZ4hbbJvSfGRc9X1W/6OdTzzMgxs+qyj/d3aQ94Gv/
VFNsaZMLrz3tGIfPpI8+dDVe7GQftsy+ARy60PSvOi+B/i+ZMG+XmmieMw/9
3cdfEUPOC5l0aFSegb8a5Bi70HjxqaD5RbPiPXKY3/BPjLnAmHOSx4lNG4ry
gS3+wy1r4bM/sd/uZ5kgqy115Rpb6+Jtg2VGrEA2+NfNdeU2m+rSnR83C7/c
nsmmvgvau+I8Dg/aFxPZE2fEXN8GfSWe1vF7baN0DL99tn11v2h/Z3+FXYzI
FAt/lArLky9Nca6xyDJ5y+fFuRFX8b3E4AtyYdNXYvzYRLEff3VMzH1gWfyA
0cCO0A2rqA+G/IFzTHABPm+vknzyffG7VfT/O9ph8ayLvR8W878d/Z7ME+1T
QXcoeKkgfHmg8Se+EZ+FX95qmSN78B3yw9ftqon+o1Q4uaex8glV5Wmsh63A
A9jxg7r8A37irLLwP/nB7NjLOfG8UdJ6xINR1jH0C6yCzYNb8RFgXPwyPpPz
OMWx9ZxY8+x4Xi8JG24yriPPJkYSHwfF/P8W/UlFYfz+xtU8YGz2c2HQHGMc
9Gyu8VvjTD5qlF7iNzjfPsZ44OdrjecT57XY0pqqMMozjcLI4HZyOfSpreNv
R6+Dj+voMXwCsYO4Qf5LrO9s/teHDE+Bh2hXxlMlT3M8BKNtj9+PBm0azyEN
kgdyBdMjlxb5FWSvnBk2+2DQPFDVGez2+SLvO8rKvcjDqQt0MT/ghK5eC5+H
HqPDhxk/ggOx6Um2d3BfW2O/p3Kdy1ngtqL8DrHsGJ/J9QX5WnA0/vY2ny0+
6sq6ZHhFtHc3K64QS1YWVct40phqt+nxF/39e69EmBL/3Cfa3vEsiL29XVK+
PrYg3L25WbqznnMEVzYKv4CBiBEv2a+ic+j09KJwy6l18X5lrPPHsnLjVs7l
P7VfImbiK8Ei57nFj5FbED85y79G///iuaEgedBn3hOMtcBcyJWcFvxzeV01
k92p8mfOHNx5S0lzMQ9xb6JjEPYI3+juATXxvzEVHlxm/TumrJjcE/+UGNtV
lb+Rx5G3ITPyl7GOL53MD/gc/zPc8X1ESfqPzZKfYrfrrMPfJsLRxCR0f15V
udwzFeVFzP9aTeeBHcM/tQH8E/WBvRPln887zuMzifXwRh3mSZ9/0fFrair7
xm+1tc8DD+OvjiIXKyguHev9EOv6Wn/wVS15fkGy4n3eRYfod4/+xtDtdvH7
guCpkdykJP05tCKe4OcRzw8GwxeAocqOmX0dI3pY5/EtE3xurMU5kzORO/eJ
M+pVlt78rC4d+mldecDJJfkK8lNiPfJdbFvBhz9u38BetvjcWSM1Tlxl38Ve
yIke8fnglzhDag2jjW06eRybH+nx31REw5nj30cYTy6y32SPxBx4oOb5WKN8
FmPgd/Z8uM/nUNPMjTmfrSi3/1Uq/3ZFnOMzqeotaSr/hFzBFdQwV5pv/D0x
BVs437EAf4sPIP6xzuBUsf6rmmxzrs9lRFn8QYefxk9hj1ty2fikunh81DJ9
sqbYRS7OO495X8gcn8ZewEVgIs5yn9jTjyqi+6oqO6N2M9Mxif7Pc2HubtH2
qKpOSu0Hu8V+7wkeXoyxF6rCCs/GeyvsE5EBNoYcpsd/U8vyu9ty+b52mbAx
vg0M1qsun3N6XbU35sDng1nBRZ/Gew+UhdE517lNqmvjxx9pUpy7syg/usm+
9Msm1YXB5b+ONW8uie/Pm4Sz4Y+8hjl2WucX2N7RZeIf+gwOb9FdfI5t9q5G
xZy1zrGxneWuwYDF6KOT1GnAc8scn1aY5icV+TUwFT6fegdx9KAYf6hJv/s7
ZyDuU38Ca813DjDPvhQ/186+7h8xz27nz8XYV0OiOiw5x0eeB9/A3PgH6i5r
zVMb6gkVyeUocray/tsYenVZ8HtFKvyAruJzPne96+lUtkMMQ37k4sc6H99V
ln9EVuREx1XVP8R6iU5yNpwRsZ66NzV96jbkQKvtQzinVe6Dow8yViBOYWPY
1xCPUXvBB1JHoC5DbQw7xQZOqau+1D3aIa4jUU+6xHko+eiOuuR/b/D/cjwn
xZorMukjug0eWWX9Q29eTVQbWFKTXHkXXLJ3Sfc74Cf2RO7EeXZw/YdaEfgS
nDne/A92jvluotrbolQ4/zPb0/mJ6kNvZcK7M22n+BhqBtj/qkR1izdr8rtL
nPP2iN9jwGCp9AA8SXy51nYJFrqrLNv4zHa12rnZqEx5x+hM+2S/a8Iee7qP
DG7PlSdvibFXmpRTfeJng3MqdJD/GCNOrjR26l8Tz/DOGH4EeVOre8q12/EV
2Tk2Pq0s+cN3apmBL7Gx1s4xiY300dUjU8mHWgs1lraWWXPw/Gac09GZfMNk
Yyr80CT7bfAbOnqi/TnvQ3dx8HBRWXSNMc8S4nGmWio1vwE13ZmRD7WqSabI
Fl0Gp3DW/Md5cC6zEtkYtlbKtZdvnQN+Y18GH+R7H7s2dUGsf35Z8QG9q1n3
7isrTlPLgA/4eTuX39zlmDijrHnBpdgjcQ38dkYimV3q+vP3xof4JuYGe7fE
YcfcjZneHVeTvi9wPRA7m2hcPcU1SWqTvWrK8d/MVfdfbGzwq5pooAXrzTDe
A+ORY7Au+IyYid+4LZOPmpwpPs/bg9+qwmV7cC/xi9zvxFyYh/p670z3ZP1y
6QlYinnJR86tyC7JDdENzqOb4+BJ0bauCd/2jrM9PVcMPS3/533A4Y7d+zi2
gh/BwcQU+IMGTIXOMf9DmfD1Ca4Ds/5A89De42Bv3pvn+ZmXdYn9d3if7JH9
0Qc/EKN2l+1vXV86NJOevm6cfK7zX/a4LdUd2PZo5yS6i9oa/Umxt7PA8bnO
oZPzPewc27sxlV63cewgphA/iB1flYRBsfHBuXwpPnVYrlgz1O2Rfre9ayPU
HTd7fvzKDXXFdHI4cBIx6NZc9gFv/CbXZC/ck91lP4m/JDdnz78oqNaMjXCf
wDrUGfFvnMMbphlYFj3yWZ+qJv5htO/WlY+TlyNLdAY7wS7fKSmGEZuW+t5t
fiY9WGD9BEdydl+UlOeQ43Cez3p8UCJ/8lim/IQ85R6/i96g88TbZ91HHtwh
oV+3VIR9wb3IHbugZkS+Al4jZ1meCoOuSPUfNVJwy5OJfGyHGH8pEU5bGuue
61r/wFS2AQ/obe9UGKxPqjwV7II+fBhyyfmd6x4CP3VmTbJDhsvrwilrXJd4
07gHHEK9ppvv1sknyTf+kcrP/c54mvur13w/Qh7NGSCj/Z2Tt67Lx0LP2tTt
wRNgiTvs0/Bt1DOZi1pYd+OB0+q6e2F+chDiNe/ipzpmOt97EsV+6MD71G6p
4XKOc7038jD2QV5HToc+zrZ9zXe9F3p0YKRrvxcl8pl8u0F+zZ3ZcZ6fPtgY
zAYuRGZ9c2EDMALvjzANOjzbtawdie44uOv4Za4ayXrfNVEXws/gH05wrWxF
orPjDNEXcD4602B6+GmXC8+1z1Wf4z7hRueGLXlBUW0P97mTBePsucOFnrzy
gZruQo7PhQ3nGBMS78H9+ApqP/TB/7SXeJya/UzLcGGiOx3udr523Q+Zw+8q
80xN7z3zSUttkdod9yHvuc89yPuuN1Lv5W6Dmu/bNfkmfBW1WcaJoxfmwu4X
RTu+rO8PuFcjp0Mv0UnqA8QhsAp62sc1H3KkFxybkBP3kXOcv3C/Tg7TMlYS
Hp2cqAWfUs8hrpEj4leRyZf2Q6yNjfbJdU9wRq67Gr6LANeh19TwV1m/Zlo+
5Mh8/wAuIGfsbf6hxU6wEf6fYhp46+Ec8E9ljVP7YZ2XvRa5/Fl+N6mrflWr
q3ZFDWuna1Xggp516TLfTFBzppb5jWvL1AUfNEYmd6OuBB4jbv/dNMgBGRBX
zsg03ieTbPgPnfm6pP5JXmej3+2eqI5xZ6ZaPjVHchDOiNo39ytX5co9uT8B
v7evKB8bkat/eS4bh1fiDrkYtSdqWO/7zmXPHMf42xRysc4VYeGxufpjwKFl
7ZP8lO8PWH9cLp7YI7ZATjfL/pMYTo2V+io+aax9Y9ey+vgqznm+7QV8+2vL
8F/KytvZ63d1fSsyOFF+hj3eaXx8s+lPy+SzTs10H0YNo0dduvyi9Rwd4Hyp
T7Z8d1LSneLIXHfVo3L5JngmzuKD0TF0kz3N9r4u8++e9m3z7QfBKugD8p5u
3rBr/OgXrhleY12EB9Y5x2sRz+kjM2iIfWBudBf9Jq8/qCy5IPfhNdVSP8uk
z3xLAd5u41ouuQA6ntqmhiY6/+cy1bFS0yMP6gvofOKceJD9WNG5+WLfmfL9
F3nBq2VhD2r51PTJr/iGYadjWeuyat/4dM6ri/0evoi9sS945F4QbA8tffAz
NkgtnFo1tfEdnpO1dtg2Vyf6tmNkJr7gAYxEzQucD95n/r18v0xOQp+1mnLJ
e0aiHIa4d3eiXJycnFhP3RT/iM6gP3u7joodYo//mQlf3Of8BblRC0Yn2W/N
NWFqHUXPSY7bvay6yKuu6eCLqrnu0yu54hHfpFArxm/hv/BptA+43yrTd4f7
+Zso1uG8oEFXyE/glT3gh9F9dIa99PPe6P8h0fc0h2fKrVrq4wXx39Xx7spM
OndVJtlvt/x3e2/sizMlP2cv1DzJI4j1PTP5tV6ZYh/1O769AicgZ+oe1ICY
i/syYiK4i7gPxoIWbLgukR6BEbAbYgY6m9VUY6TWiP609v0yOgiuQmdecd2D
GgByJS9AtmBK9BAbBB/u9l6qrgvh56lhHeszBYd0tQ5Dz/dDe+br7FwD2i6m
J+//fVm1CWyNbwyovYIV+eaAsYsT5cX/k6mGTE22o1vowZP714T1H8g09p3n
YX/sE5uo2SeyLjweZz4n2K6wKWxrs+0LvIRd48ewbX4TZzvXVPOk9tmSr1kO
RZ81Z/V8ou8CewQ/v64pHiS5eNtlnllnk9ci3o63bpAjM079mXX4HpS6fxfn
2uTcq80PvBFPiHfERHQFPvDVyzLJ9v1Mucgg1zf4RpD6ypPRDkkUc57OpEfo
HrZCffpi03fx+Aumg57v+7AV6jjYCHfV1EmHpvJ5A+33nsiVzzye6zsSfNC9
uXwrPpZvIXtZ/4fE+H/EMzzoG1PlTvD9aCb95a635Z430X3RpeigZcK3BrsS
xf6VmXQN/UPfqNNf4LrK2Ez6Py7aC2uqmazNVAsk1hJn0bULTc+3IORXkzLd
k8MbNd7dXotvB0aYn/ty3e0MrajGjL4y18PRPpjJl+JTwTXcu4NbXs107n+L
9t9zvfuHXPL+2jLH5tbZ9t+rCWuMzvW9zy3OE69LhGf5BrCb3+U8W2fCeQdk
8r99fNdDzLzXcXN9/DczxtdlqiPNdC3pqlR351en+kaBmiG1Q747JN4fZR/f
23Nen+red0ouftea5y6++8PuqL2ipx9k0p8DHaPJU6e5domPnO7+SuM55L3B
eA68/XYm3qmDUj8FK13iWJI4LpP3Mu870a6O507m9PnPsA/8qe+8VtVVy4SG
+uY8fwe4ItedEDVnvu2da/1/JtOdB/Y5L1eO0fLNR4PyiTG+D+iYq27TIdoH
E+UGR6f6Dor6LDnu9Ezxblqmb7OoZfBdCfHhHceI/wdoIqFo
            "]], 
           PolygonBox[CompressedData["
1:eJwtmHlw1dUVx39N3ssLv/dbxm4EoXWZcQEBK2HAVuvKTiIIzshaa1iFQAgo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            "]]}]}, {
         EdgeForm[], 
         LABColor[0.6346458384809849, 0.497151965948411, 0.3628038272439413], 
         
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmgm01dV1xu/lvnfvu7Ndy4iuJulKU20akRIFBRUEh+BATJlsoGrAsWFQ
ZLKC7YoDTkCWgFrjxJRoVUCJgSS2aYOiVkRFBeOIIDZAUpWXaFaNA/1++T4W
Wev91zn3jPvss4dv7/O+dN6lIy7pUSgUppUKBf0V+jcLhe+q4aB6obC+VSg8
pvoxqv9ju1B4oVgo3KS2/vSpfYvqF6v9dU18QW2v6veiSqHwisqfdhQKt6i+
VeN2qL5Q3yqtP0PlIn0/V/0mzRmnuc9rz5mM79jfvzBjFub3Eq3zZLVQmK01
fyI6Vur3rzq1t8YsSfssfTO03s4O93+nXCh8tatQGKkxF6o+Wf2PqP0I7bdS
cw/Q/pvqpp9z3Kx5CzpM00Ua87bGHK7+n+s8/bTG6Rqzveh9zih6Hus/W/T+
V4a2SZ1e/1DNmaDyAX0HqX6t9p6r8RNVX192/eyCy3mps//NOS9nfyd8mBna
luQ+uJfTVJ6jdc4um77b1Xanxpyl8hatd6u+/1B7P5V99b0o2n6tvttE59uq
j9S8Wqf3O7fhvf5aa25thWdqm8yZdc7Naj+86bM0VZ9ck5xozET1/0rjtWTh
FpULtM9vNOaegmXh1sjAotwv9HeWTHNfjZna9PjLVI4tWVaQk2+o7KX2d7hP
fUeovls0j9BdP6G552jMTu3XU+X3VU4THf2191SVN2r89zV/mPb6nuYN6PIa
F7V9rgvaXoM7gOfX1MynLaJhqfqma/wSldep/3nRv0DrLNfvGWpfpvJ4rXW/
1p/fw2NpP0O/ezfcvlzr1duee5V4taVkfXhK49/S9zPVn1Y5VGdZXTbv4P0b
Fd/1TvU9rt87GF/zvb2BLqo+WPWXVZ+jvg0af67G36uxz1bchtx9q2zZG9Yw
f+DTKNE4Qt+PNeavRNsujV8k2oanfaPWva/me5utcleH5zB+ddN6NlnlMI3r
pfU/LVimHy57D+79Zn3jO03LM5X9NFKfrDErwmf4/Qt9J2itr4uG1aq/hh6o
XCqefK3LsvV6zXRN0TnW5eybdZb7NOcm8fShtn/TDm/Y6+4u8wTbhI16UeUy
rdmny7r7eY35W9W3af5A1efrW6X2Zfp9p2jvKlp25mLHepieJZnPnb2scWuK
luWZkefZ4du0ptedr3W2qpxUsj3jTrd32p5sVP17Ok9D9fkqv6Rvusa8r7lr
S65ztq0121vs7sxO7wXvzi1b59H3p8o+75Nl6wqy/j8l6/7M2FLWZc09Ku+o
2z4e1XA/62LrLuz0HMYfUbKdmqD1h2jOOvV9JBr6YFvVvjv2Ct3Bjp2qtln6
hqt+vGg+Ud9x+oak/oHa10UWuJfhVdM7SfVjdL7fqhyP7VD7oqrH7il4jW+r
XIXsiIa66Fqqr3fJayJTG7Juz4rvdq/a92reaLUt0L0fXHEftu4T9e1QeZXK
kUW3MX6CeNGtc39H5fXYeY2/QWWvlvn7Q5Xna81xav+R6u9qzila/ySVh7ds
R5arHK3+r1XMiws0/nzV17bME84yrmDah4Qn3PVg1QeKjv8VnydonXdV/pvu
aC72om1bgczhU1h3aPiML3skv9FHdPHqgvVwYg/r5Zlaa6P4NlzlZeLrFH0j
1TdCv59X+1nIW4/wqmC/sbxk39FRdLm4YLmfFf6eHj7Cw7k62wC136hyYM3n
5Iwnpv5B5GFw6vtkgjv9NHyDf3siQ/vkZ2B4coDKPaJ5jfo2FW3L+6t8v+ox
7IWeoqP0ocOD9P0ePKD2T0vmBecepfYivkNfQd/NKm5U+w367tAZNuMXiz73
sZo3T/PmaMy2mu3FVO43Y5iLjuGLSvqe1329ot/bdF+r65bRgaoPUDlX61yL
jKm9gzla5wqd+0jVr1H7F1u2/3+h8u2mdfs/VX9B9N9TspwNr9sfjKj7fE3V
P4zuNFTvzlnuFJ27e9hfYof/aI/KPt9bxeCr4AFsNGPGqv25rIMO0rYgc5dX
jRvw/U+ovr5qzIOvXhA7z5k5+3OibWTd+29rmRb2nVqw/vWN7T1TNDzTw7w7
ULQdV7IP7RW7Be2XtbwO623OnSCH0Lol9c2pw//e+MOi9XFay7jhcw3r+jvR
d+T2rcjuhLb9yyVtywLj0J1ju4wxwAkjMpf+w0qWUeR2Q/Z6L/zBr3C2BfEF
2NKC2vaqrYrMdtqvg+P6ibaXdeajVX7QsO39sGGZ2hy5anTZB+GLLqrYX+A3
tmQMZ++STFb03V81PtgUG3okcqP1j2oZ/wxLH2vg6/E7rar9PT4Vv06ds7wQ
DPxS3fJ1YMUydrn2uQ7ei86VDfsj/NJY8W4aelYzz7hX7vS/4tNP1To/qtue
nKSxS8AfWnOxyj5qm1m23fq9ZH6G6h/io8quIzOfq5gG9sPvjIrvWdYyXvuk
ZWwKlgPTXa5z7O6wrbi+bNyG3p0serrAxS33/6Vo/UnJeBfcO6Zk//Z4p+UQ
eXws9ROa9m8X1+zzv9Jpv48vZM7gpn3F6Nj8H7SMST9r2Za2u3z+IRWfbS22
QnPfVvtzYMzIKjILHgEzgB2IMfDtp7bd9mmHsQR2bqrWOTOYFjlFZ5Br+pHt
F+u+W3DT75oeP65mvWIs+jK5ZOwBNkF+0F/k5KXIwHbte3TVPAT3gp37Bz9/
VPP+Q4kR1PZ6l++b/aGTuz2l7bOf3Lb9mZ47BTNy79NiP3fGhq4seh3s9myw
kMo7Gm5jj7uKxjvIAdiD/d/o2j/vjdBwtsq9Hbat3Df3fkrNsQF+8TaVg5rG
NcerHKz1BlW8/gIwT9n+8eKG6V2sud/UuGfFqy8S26rvN1p/ncq/a9o/zKx5
jRMqxqD4W8Yje2D5L5eN/fDtxKLI63EV+030DD9/XOpfqJvf3Q2fYU7ZPgLs
y53e0DZeHZS9oJvf8A0/fmrFvnxRy/WFKueVfE7Gzm+Zzo9r9o1gHuIwdPfd
2GXiWOg8qmhcPDB7Eb8hx8jwHyIDv23av23MeeHfKRXzkHHcPXYXzAR2Wq1y
pS5lhb5dBduq/6uYxj8rOd7AJuF/L6jYB4OhLkz9afHnJfX9i/ad1HTsv6rp
tc+rmJZzatZZdJe74Y5GNo3DWGtNy/dzfezDgy2Pv1/luTVj0hWqvw/eRWeb
9uPjsz4xMP5wivp71p0nIV/yUMtzV6p8uOVYZ2LN53ywy77pwZydmBe5wL5j
279d83jmrcg6E2rWz+2JF5gH78DA6OWc0H9o1ev2jX59VDEWJP/R7LSuvyBa
d2rMprbtDbYA/45OHxu9PkJ9H2huL3Q/uQVyP4+rbX3F5wS7EmeCt8Hqj6cd
34CPuFt8aLYcw6+sW7YmJQcypuEzdmn9icFC32g41nizw/HGQZ2mAd/FOcH8
nKtH2zTM1rwzyo5V4A37r0v8W9CYx1Tfq/2X1mxDzqs5Dp4YGv69bZkbr/Z5
NWPkk1TeVrNP+fuafcN9HcbmRzR83jtrzqOAndgb/zw+ceL2hn3+toZjhcdC
D/gDXvdJ+5PJVxCr8Zsx+BowELz7B7BYl+k+vWU5P63l/MDXq46xyYuAJ8AS
2NoxXba34EnmYjMoz069u+mz3CX674zdw/6RnziobB9HDAHWBGeCmc/stG04
q+F7Gd3w2AMzHr+Mr8XPcj+TckfcJ/PB293oANhP9/VocinkVLA3qyuWC3zp
zORMftq0T3gUPap4Lv4Pnm1I3uDRjAF3XFa3fOytO4f0UMaz9kNZ/6hgIe78
EJWby7bxn8VH/6t4MqZme0yu68GqbfRrRevQrOQ3sDvEStgR+Ew7dwSfr0id
M8MzZIxzcSZwArzsThxyYGw+eObNxPXgKdrhKfx8JPZiidpvbDsnc33b+BIM
/WJiVurErWDYPsHnYO1p8bOTgm/BuWDmd+L3t9S9Bvkk8M6VZeexiIG2BUeM
bloewX3wo3/FPLms7VjgUpXH6utQfYDKa1qOea9uGQNRJyaFJxOS89zctN7s
aJinV8SvfaT2f8IHqLy87Dp3jN2tkH8r+awH5+wP1x0T9W9bZqGB34zrW3EM
eVjVWAGcgJ3CPoDbz2vYv4xv2Ee9HF//SfAkNgA7MSG2AvuM7cV3kxMkZrq+
ZlzCnWNjrmt53zktYyjsFzhqsOirg0lUzmpYV69QOUXjDtH4S1Xem/xV77Zz
sQcnRwEuw8Zh39Bv+IKO039I+ACGujy8AsOy17LkRj7psJ2+nVyYxvTWXnub
9s0zEjM8ULR/J9eCHceGE+MsSh27ekvyMMQxXYk7JsZPYcsnxFfi97A1+Ej8
EfpxRXRnfc1YF8wLLmMMY/FlDwYDcLZhicvIE6xNbge7NT12eG4wwZxg8Ynx
2wuTeyNXXG07H1RpmzczwzfOypmJj+DNveFPj07bweOTj6ENObm7YcxO7DIv
8QD6MCcxO2d8uW7fSb55c2JQYrfRyZuQSyHO4Az4E2JGckZggG/W7YvxycWq
Y0XiRPhMfVVsKfoDZgXr4Av+u+5+5uBfZ4nmL6i+q71/Pnd0D/lT1X/WNj+P
Ty6lK2NY/43g9pWJbZckvkXnkGd+/02X89XkrdmfEpu2Adurfd9qW36X5r7I
FcE3aFmbPNHHBedw4AE0MIe5W9uOu5BZ6HotOV5iF2ze8OScb01uhBwJvmJ6
/MWrmv+Z6q+1PZaYFtx6Wtu+A//zcYf9F/iCnAmxLPkNsO0DVcv/PU37tbua
toHkUMg7HBJfcbK+qVXnzrAVhfAeHo5MXomcUiOYB+yDHWYtbGm/qtfA1l2j
+tVV4ypKfoN7iW/4DT7HJk3NXuxJHVz/u7rxwXydb1PTeQPyB8j+mNBzZcM6
9s/EDsh80fm08xuOey9omA8rkh/rnzo8mZIzIrdHZy45JXiE/oyIneG+2O+Y
tKNT5NWm/Mlc5o3T94uyMT0xO3licr6T4tOp44O5k+dCA36MHDt5Rkpy7t8t
2PeRYyF3xL3hp/FH+LelycmTa7oxebzZmc/c89qW4/Pju5ZX969HHb/ZZ9/6
wXBgOd4kiWf7JKbeFh+JbED7iNBP/pI65wOjgdUqBcvs0GC2h9OHehOjHBt7
hj8k146dJ77BzmBv8MvYJLAWOSj8PPkr5AhZQ5Z41wTXbwz/C8lf0TYp7WD/
RvA/fLs/Mk8OgdgN3SeOIM7HtiGr1Ik/p+c9jne5T2t+w+Ndl7dT/C6YcXds
25rI6trkkHsnr0ROaWjwJbaPPO4BsUXkrshhcY9D04+svpaz8c4EzV3xV8Qy
nIO+TcS00KGyu2r8BA0ftu2zVzQdP3OOHzYdR56f+HFU8t7kv3tq7YNrzquT
1+Q39oozQSdrEvONS9zHPNbAF5CP75m5xL5zkyvekLwg+gIv+4W35JPWJafE
eTg/ukPupRI+8C64NXHz9sQ3YA/6Gcd43pZ5D2Bf9Ar9gt+cg/ws7WfXjQHJ
YRDP89YLrgBTYdex97wrgldYl3lPZu725G3fahmzdpb2v1/jj6gvDr/g1Z+3
/JbEmxJ692T0d0XiVOICMMVh8a30PZEc8p7YC2wFcTx3i9y+2/JcMD5YHnwP
HeTg0UN0EExKPhy+rY6OgTOHtJ0/PVHlm8FaYK4D9fuX4Oy294df6/9E7tEp
+omvsOP48dvjy4mvwZTgyb4t5yfJWYJfDk370TkPMgy9tHN2fDM+emfbdmJ4
bAXv/LyfEfMSl1wbfwNuZS/WQN8XROc/bhpX/UHlsry5T44OPRB7iM8n3pkX
+9wdOZxUs98kDgOfEluDUXlbIvd0d80xKXEWthkcBG7mvuDxjvAZLMlbC/PX
JW9FzmpF3T7/Lsnbw21jNt4ziSfB5rtiu/rFtlwdv4e/A18iH+xFrIFtxz+v
iT4gY+SwX4m9ItbsjFzxrks+jjefXyavRX6L/zfBXqFLvCuTF9zQtr4+nTV5
1yUvyrrkgfFp+FLe5MnzMo53mj/isLpzY+jRvncLypHJcbM+79j4Md6lxsXW
Uf8w9e68YdHGb2wgdqs7Y8BZ0MuZB9R9v9zzey2/fb7fsrztDoYkBzk399Cd
NVlnacM8J07CRsIf+HRa8jkb2+YX88ACvF8vyhvxiJrfFHdLxlaVbXPR7aVF
v3sVovfoP/oLLr8p2O/EvOvxvscZnwveAl/0D95A53pG775Vsz0ix7akaF7i
556K/eOOyBlPS86c+1iT9gF5F0D2VjX8bjRD/FneNG77QdMY8aXg1e2hl/W/
WrePwFeAZ5/Kurzz7MgZn8j/DPD/Tb/O2bED5HvGBkeDy8Bq+DzegrD73As2
Y9/bKfK/K/fFGUckRsBuY7O5S9Yam9jqnYzB1w9K3vWuyNrb4RF3MSrxBXbi
0NiKUvpvDlbZmlieM4FfwAbgZfIa5AjBd0cHH74XnIetIGbqlXcZfPKRGYPO
glORId4Jjwlmg6dnhGb2GRYcwr2x/+nBiP0z/qKa/SD/U7A4/VdFx1dGVnY1
HIfvbtifPBGfgm14IPaBtwcwDHloctTrYwdOS96MPDF+fG3iju7gTHQT+p9L
G3dVDf+hm5gVXwB/jsyYMYlRwNiTWs7VTG5Zh5rRo4GR+317HRl+8n9PQ2KL
NuV88GN3cBKy0TtxFP/Pgr4MCq/w7T+OrLDeM1kT3H1M6sQ9vNcQ+7zS9P9y
vZo3KXIx5EPoOyq4hLMVc0fo6p5g9RnBVuCvm2rW/8+3fD+Lo3ejIn/oCDLf
O2s+E/qQF96OyTWNzVlXRvexQ+tyR8j1qrS/nrcd6pckn09enzeBwXkX2J43
cd7GkfElkXOwDOfbE9z1TGgYkTHI5pboVyl0j87c3dEX2vnfPWQKPoFVTwke
PSNnRz47Mhe9I958NmcfHZ7QvrDmmOcrLfttYrhi6NqQ+ypGf+H//wOyk7Gm

            "]], 
           PolygonBox[CompressedData["
1:eJwtl3lwl+URx5+Q4xfes84g1Km209ZRq6DQikOoB1aYokhUDg8KFMIxNSRB
IBEF2mpFkMvWA7XDUSCg4ACawVqY1lo5bIcbD+QuiZ0GpLQeWLQI9POdb/54
5t19d5999nme3e/u8+2q8QPq2oUQiotCKOE7IQ3hRGkIIxlHkhBey0KoKoQw
gjEqCqFvHkJ39F6FvxU6xCEsQDcpD+Fm+HXoj0RWURxCHfr/w96UshC+5N8q
dH+OzfMsNBT9U/Br0K/BzNvorIUuYGMbujsYv4jtg3zRGlrrKDrHcXgB8mbo
fvz7O/w0+J7QE2P79grjY+RjsHclax3En93IKuBL4PfgQ19sr0JnHKY3s/7L
0Ck6L7NWNaM1sQ/y5UX0u8A/jU5f+NdZ8zX215/99cb2U/CXoHsL/zoG27gK
2XHGGGz/GPkx6CuY/xf4BvjLoWei/yf05+PT6/i2Axt7sRe3D2Gr/GXOZfCP
oN8Jvjc6OboL8Gcac5sy343OXGf/NZ0pa9cwPsLfp/g3uJ19fgb6IGO+aMZZ
5neBn4X9U/BdsH0961Xjz3Tm3AA9CXtNyD5hvWrs9eLfW9jeyPgRdA/mLC72
mfaEfhx716JfgL8e/hQ69ez3Zv6dY72Z/BuAbBDjJLbPIe+DbDo651PrSFc+
ytcd6B9B9ybi801kDfzrzNr98aceumPss9mMfjt0z6BzE/SNjLnI3+DfGuYf
Y0/rkC1ijRnQHVhvMfQsdCrQ/SHjC+Tb0D+EfiU2v4QfgP1W6B7IT8P/Er4j
c1ex/tWcxzXof4FsD/++j62/IX+X8+iH/I/Y/x3/BiHvyvivfEM/xn7EHmYz
vxb5hZrP/g4jr4P/OvxzjDsVC/C9irynDxR76FQydwn250HfiL1lxbbZC7pz
7rvsiM4K5u9kjduhP0T/sth70F6q8fdf+Dc789o6gznQK1LH8i74GFudmF+p
2MfGB7FjVrGrPS3JfGY6uzn4sBL5V/C9Cj4Tnc1R7A1jreGMZujfM2cUstGM
P0AvVXxCd2fMhL6OsbfMMaHY2M8YCP8bfGgRdiDfiOyv/Ouc2YZs9WT98ZFj
TrHXFfm98FPwaXjwnJB7D9pLT3QacseIYkU+y/eFqWNDd6y7vgWdxmLnXB/o
u5BvZ/7jmLsTupx/tcGY1R56auxY3MQogn809lnOwF5grQ2MsfDfhb8y9h3r
rj/iTAdLF/kc+N+y3yH4s5I9f4f1jsOPgt6GzhWlxghhhTBV2HoO//Yr1uUf
Sx3j36Xwb2KvtmAMGoC9fZlz/1nGgcxD9Hrsb0I+B3uH4P8BP5z11gtDC213
hvyZ2LZb8GFsaowQVghDhyG/PPZcxZxirwNjcrljvAZb29vwbQM6W9BfEBlb
v2I8hO5C+JdKvGftfbzqDfPfIUbfZ+5y1ruozJgr7B2B/sQyn5nObgP/OsNP
wp/1qXNEuVKCfrVqRebaMRH5UOVyW3xfAt5OQfdz+AdLjcmrI9+B7mIrNl+A
vpj5a4Xf2PtGZgwWFr/AGayEfp4xjLlb0Dmbucap1g1hzM2N8cL6MazxHv59
mhprtIfPhBeRfWuAv5b5n6emhaHC0geUb8W+E93Nksh7fUg1Fvlo7A8Mrnmq
fYsi5+YJfByb+Mx19qqZt6leotMD3QpGPfSSxFgpTF8K3RAZm99jLI+cY8o1
9QTqDVTjVetV06ehfwh+U4kx8y7sfyz8L/GdfqL7YI2faC3WmKr7xcZFBWOe
sO/DxGfTT+cXO2eUOzMZRdCrU+eOYlSxqn+S7WDOHci+Bd9U5ho8F1+eg++k
foV/z2eOMcXaUnxuYv7D8GeFpcxvjoyZws59yHdB35+49glzhb0/gz9Z4phR
7KhnUO+gHmZ45DPWWe9n/31i70F7SZj/JLIRjNYSx9DsyD2IehHlqHL1z5mx
Uj3WG8JG5IeRn2FMhm7MHFtDkS9TLLLnf5Y655X7b/NvKrYega9g7ZG6T+Ze
wH4qWe/h2Pkqm3cnznnl/ve4k6rcPZR6KdmQrT2MudCbmbMlMwYLi0dgrxn6
U/TvK/cZToHfgI2linXk3dB/BX52sWPgVegLhcHYG8K/BPkPEufSAfxtwpdn
1QMG3+F86CfQ317knmEW9LzEZ5kyfp14iNaZ6mzfZc68gmvmW5F7DPUaOoMq
5Kex8Ri5vpH9XIesDr4b8mZ8qIU+zBneW+YeqkvqGq1arRq0D36daka5z1Bn
eTf/dpW6pxgMXRU5ttXznoH/j+5ItRT7J9V/Mb+I9dvj32rmt6D/ZKl7mrWs
9UTmWtgX+9MzY4awQznzmeoRNjeVugcby9yBqWuRfBgEfSR37yiMFdZ+M3Zu
qGZVIh+V+67fV4+SOSeUG/wKvbF3KDPWKicPq5eP3NvoThdHzhHlyjXw9+fG
BGGDMLkR+wdy1yJhsLBYMaBY0Jnr7NWDqBdRDHSAvypuqyUF18aJjIsL7vEn
CN/Qqcfeg4zl0F0T936L8felyD2oelFhorBxZ+zcFQYJi+6JnCu6M93dydS9
jzDyPu0n99sgw78W4XPq3kE9t3rvG3JjhWL4RWwvg28ot081Wj/320c9mHqx
Sal90xuqPnUPqF5QcxqRn1DPV+qY+Df725U6l1Rzdqfeo/aqGq9aX8u/g8E5
Xpf6znR36jFvg27NXbuER+rV1sTOLcWYYk1vDr09urHeY+j/KjOtnku9l3pS
9abq0dSr6Q2mt5h6mp9GfkPoLSGf5btqnGqd3hTnoUcn7k1U41XrV2TuzVQD
l6s/TF2bJjNOp44ZxY7u+GjkmqPaoxxQLlydudbqTaK3ycLEuaIebBH0A7lz
VT3BBOhxubFOOVwDPQEb08qcI8qVxsi9ejv4RxP3fOr9VPP2xn7j6a03jnEs
cc4p9/SGmaHePXZvJswX9gvThe3CxN16iyaeK8wQdiiGFEvCrAOsvRu+tdw2
ZGtwmz39uyN2DVYtboHfjP723NikN4/ePsJsYbfejE9H7inVW6qnVW+7M/dc
2dBbWG9SvU3VQ3fP/AbWW1hvOL3ltuZ+S+mNo7eO7kR3IwwXlp+PjVV6M+nt
9E5m7BemClv7J+6lVFNvh/4/4ZFKAQ==
            "]]}]}, {
         EdgeForm[], 
         LABColor[0.698380586564509, 0.411140656118564, 0.448606824316373], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmH+QVmUVxy+7vPfd9733ua8p1CRirpAVKD+nBKuZVPxREwLKDx1KG6IE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            "]], 
           PolygonBox[CompressedData["
1:eJwllVts1UUQxte25xTP/+z/ILYalVZR8EKhtRC1QnwRCNEotpUWYxVNU4Ua
bSFeiCGIUBQMfaE3YiimFyqXFEWIBnlQ302MPChoNPFBitUKUeP9Un9fvodJ
vtn5ZnZ2Z3Z2TmtnY0dRCKELKUH6khB+KA3he2ReIYRK9B4IK4pDeCCGMJkP
oRj8FGvfgTdgPwL3MDKVhnAT+jC2VjhrsT+Nzzps5zMhdICzcHqz7IOUCsPv
gDsXfS77HUUfQB9Ej9jHo2NtvjSEX7GfYm29csO+EO572E8Ruxb7Rex3Indz
juIZISwBb0uc+9XwE/Q6/M+A7yFGCfha5Dh6GzlXgquQl8AfYv9XXM7QRPwI
54XEd6K7mUL60X/C/iz2j5EK9Gl8tuI/jz0D3DL0NvBbXG45+E3yvYZYFUgX
/NFcCDuh3gWnmlh51trxL0KfD7cb/Wv2GoE/C/8mOC3wr8feDJ5A2tm7GfuX
8GfC31jkGi1E35w4l/fhFJHPMvb7u8hn7gb/TswX0U+yxx86P/yDRa7Jk/hv
RD+KbRz5EXtt3mdRTsrtxoLv4hA+f8kWXUvVXLWvZ+2LEveIeuXt6Nqpx9Rr
x5AMtZpNfsNw67CfzLimV2KrIv7PcGuQl9l/Ezm/hv9p7E1wz7E2hK0BeQL+
LvTFqg93tBM8QswKuGfxeRffcuLty7pHy8Bb4CwHV+OzVbVPjbPktBR7GzED
/FFi3BDdY+q1epYfIt4rqbH2fBXcg2QuCWElem/qHlYva888uA+f++G3op8n
3ibir0JP0Qeie0y99hV3tjrvmqq2OqPOupz9h8QnvxXgaviTGb8JvY0G+J9k
/GZXgY9jnwn3Ktb2E++Z6Ld4MzHfAfdH772BtQt5vwm9jT2sZcALEtdWPbwO
7oN55/Yn8hx4gPOMgT/A5x/4D7P2TYlrpFrpznX3enN3YD+M/hm4EjlEvJh4
lqgnq9CH8u6F64hxAu6t0bnpzmrAywo+u86ks/2Wund1h7rLMXyO4JvBZwex
diPHsI2Rfzf4Yupe1hu5AF6S2qYeWapZgP8gehn63rxnmmbbImJ0Er8P/V70
YWQCXFfwrFEPq5fvy5mrGKfx38faLVnXqJP8H0E+B7/O/r9gfxz9DHo/Po+B
B1P3smZAovmA3lzqmaTZtCd1b6kHptnrisRvW29Gb6cR6YX7Kfpq8IzEvbse
+Zb9DkTPqh78R1XPaO4uzTfVkvhrSj3DFoBvR7qy7unbUs9IzUrdQT+4PfGs
0hvfTazpxLXTzNDs0J7aWzPqHHhNzrNLPaPe2ZvzrP0I+S/1m9Pbq2HPhpx7
Sr2lOxhJzRFXOR4Ab0/91ts0T8HP53w25TwdfSadTW+iHr0l77uezdrB6Bms
WayeqcG2n7XyrHtYvbwt9ezRjNCsGIye1eK8Ad6eOJZmumZ7c/RsUg1UC/W4
el01bwGPRf9F+jP0d1yeerarR3eQ60T0bNCfo79Hf6T+yrPoa6N7Ur2pmajZ
uCXnt6o3pbelP1J/pWb4fHK7rOBe0587CzwZfVf6IxvhL0Y/kfEfUAuek3gv
9eSj6FMF10KcRerPvGeJ/uhxuP8D3i4LxA==
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.7639376724784871, 0.30748215290890285`, 0.45475723264129847`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFlkmMVVUQhm/Tb75DAyKToiEEAWlAdKGRRN0KLKCB1QM1IAgLu1mAgIRW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            "]], 
           PolygonBox[CompressedData["
1:eJwlld1P13UUxz/w48cPvk8/kZ5QW2NYgUJkXfTg5rpVWxHWlSAN5pKL+HFR
G9bSbLVRROAmXmheiDgGC0Ha2trc+hucthkusJW0pesGQXzafL33vjjbOZ9z
zvuc73n61neX2vvKQwjdUAV0IgphAiaphE9D+BD6Ix/CKYw64deKIRytDmEW
uSUO4QfezmJflQuhD3krtIj9n1APuneTEBqEDd4Q8jhyXBbCdeSdWQh3oF8K
IUTIx9FvAf8G8jKYjWA9g7xQMKawe2NjTSFvUz741xH7V2zW4b/jLYf+Gv7v
EKsZ+7+x/Qy6h3wJvOkq4uEzi+7NzLksQG/Af8H3j5PvKHIe+VXwLuLbyDff
wncFOgx/iO+P8B9DP1DuHE7CP4W+I+ec6+CvEHNDzt+4Cl4tdA7sHt42whfA
6Mb/LrQX2yO8vUX8FuyPwk+B+Rz2n5LDCvrNYB7MuUbPwtfH7k07bwewvc1b
U7Ux3uNbjkBjle5hF/r/wJwsuGfbwTuWOdYy9l/Cd/F2s8I5fo1vR+rYqsl+
+P3o/6owprBVQ9WyDZvLiWuoWtZQ45/R3eatD90FqAb5EXI/9lPk/BB+Bozf
wJ7A50l8i1An+hlibIDfh83b6J/m7f3ENVft28j5dOaeqDf65lfIrxb9fN49
24G8pJzBLuC/mDon5Raj/z7xjGpWl6DnY8+gZlE5K/dZ5FLOM6/Z35G4d8pZ
uVdmrv1V8tmIvhz7w8hz5FgGv5w6d+3Uv/DH8dmFb5G3ZrDOyB/fMmLGxH8x
9bdNEr8JvjU2lmrWLzx87iH3QDfh5yP3TjOt2X4B+jzvnMfw/QranXPPJvH/
JHbs68grxP449u4uIA+j3wPmWrlnshLdefBPBmO0oqvG5wP4n7CP4L9Bf57c
Z5EvwNdkruUEPseQG1N/i3ZSuzmUuPaaMc3a74lja0euwr+eefd0I16D31T0
LdBMfEs+HYmxlUOnZiPy7I1jMxJ5x7XrqsF9+Ccyz5ZuwEfEH0y9a9ph7XJ7
4lqsQqXEN0O3QzOzN/LMaHa0M7fASmLfHvVMvXsp9i0cwKaEbVXs3qxDDcg/
Zu6tenZQs8vbP3nXTLVrU01zvpG6lQ8S74ZsejU7Re+CbsqgZrfoWdNN0G14
GZrL+wb9j+/dzLdQO6BdmI7cqyrkwcQ1Uq0Us4R+NPVuaiZHUvdQvdSNGY79
D9C/QDFa4R8Dk3XK4Q==
            "]]}]}, {
         EdgeForm[], 
         LABColor[0.8306167584033657, 0.1929584024143414, 0.4118661273953421], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxFV1lsVVUUvby++d77LsV5jEBNS5WCvyaGMonSCAkyKzgFI5q2Sk1kKKZV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            "]], 
           PolygonBox[CompressedData["
1:eJwtlGtoznEUx3+2PZc9/+f5/1Hu1zFtRm4vlczaxBbLvKBhuSWX3EJj5jLX
KRteMFEIQ/NimSnltnIbJS9corlvpcYixhvE59vx4tT5/s79/M45aQtXF61K
cs4thVKg3oFzJ3h4EXGuD3wr1D3Vue/JzrV5zpX5zs1CMQP5ZvjdvD2D/8Db
vLhzmQnnhuDnXMi54fBLoSZwOXgZfC/8vUS/gbeLMecOYN8qe2gQskO8ncFX
ahgZ+m+h4rD5LECWR4yHyAvwlw7/DJoJPwb5DPhW/PVIspyVezE4BO6IOvcE
HAE/xz4Xm/voz41b7qeIUYH/r9Aj8D0oB1kT8ccj+0n9N+E/IX+QYm+3wO89
680S/N0AZ2GzgHgrqOc6/VnMW0my9XQYuqOhdnS3Qw7ZMXQK0b2Kv6Hw3/Gf
BR4OlYM/xiyXPPSb8Z0LNYM3UU8t9Yz1LNZy6Br6GbxdQr6WmEeQLYJORqzm
AmyTiFmBr3riDUB/HG+15PYenYHYViL/GzIb2f6K299tgX7D56vn+JoGfgy/
B5tCcvlNvB3wpVA2eBTltWD/BJ2ikP3RU/hzgeWuGdIsqQfqhXLqkjAf8jUd
nV3wb/AxGT4X2gzeGZisDDoP/xb51KjN0GDwO3A+eAq0DVzjWS/0tj2wHqlX
BeAxyBrI6SvyL9Br8JbAYjVqZuHLoJyo6ZRi2xfcgv1ZepaJfj/lELEZrwL3
ROc8vb0A9YI/HLfZ2QGdRv4nbr2sQ94XeRr2bRH7A/1Fz8B2TztS6dlOaDek
cxD8DZvL8FegDeASzR+2ndBe+hdFXhO2ndRuqibVph5uxdckYtxNsZ3Qbvjo
nwhbTfvA+/ERBkehVeDZUEeSxdiDrNqzWVGNqnW+Z7E1s5rdisB6qx3ULn6O
2a3Ipua7xG4HZyJL185jn+oZrx3QLlTGbJc0w/UxuxG6FSeJ1xV5/8B6r54P
gE/l7WjYalbtRcSYgH6j8vGtR+qVbspIZKOowacf6/DRzbOboNugGueAV0KR
sPVAvVjvmS/1XL1v8203VUOrbzdHt0c2VejXkW+ts5xiyAPfcleP1Wv9uf5e
N2BNwmZUs6oZ1ix38+0W6WbodmhmNDuTkG9E92DCbqNqUC0ZCbu12tnjvt00
3TbtaNiznqv3ulm6XbfBE0N2Q3RLXnnmWzur3dUN0i3STu8Gd/rWK+3wD/jq
xP/Z4G1E3GZcs64d2RTYTdZtVow7cbtZul2auey47ax2Vze8g3zaffOlG/8J
/h/OpeIh
            "]]}]}, {
         EdgeForm[], 
         LABColor[
         0.9735241229755421, -0.05249018370661607, 0.31994142972937545`], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNVktMXVUUPe/y4H3u4x14NGBi+TyKEJQENMHfwFRjZzhxZLRpTCd1JB1Q
0bb+tRor6sSamFQTCuhM67B+I5DQmdW0Ez+00MZEPqVo4kBe61qu1eBgZ++7
7z777P8+1f2jjz6dhBD+BtQBNvHxViGEB4BrmRCuA8YBU6YjYAD/7m0IoQj8
djaEIeCuIPo4YBDfD5VCuB94o6hzNZ+tgpcHLEP+w3IIB0AX0hC6gVPAFfA/
hVwlI3oGeEdG8uQtATcH3X+fbfgoJ7tp82052Ud7lsv6dxm4HXb0g98A2AXe
UD3sAX0Y/3rxPRNDeAXwSD6EY1ExuJqXTt6xG9AJnUfL4v1Z1DneR//n4O8E
fO8B/guBvAe2tYL/dWMId4O+BB+HG0T/YL+aAYn97QI0BflMP+njGeBpQEtG
9/C+O3DgFsAK5QHdOflDX6o5fZNu8jfpAceFZ3tx/45ENhyok8z3oNsS8cvO
85TzftB5OweZU8CHMpKh/4zDk6l8pu97gE/gew06+6JzZV9W7QttXrDeH61z
DHARdMl83tWVKO+syUngUcv/mip3X5QUX9qySBnwK+C/XxLvkPnR+qmzZpq8
Wfv4DOBW1zr9nXftNfle2lNyfpgb1sA66qKjqDqu+TztzyWymzYzP8wT80s/
ulzzL0TZTz8oXzV/vqT8rBbVB92u4Z34LiSK4SYUPwVo9v+CZXoS6eK9tIv2
sdaJqb/i/A679libww3b8WPeGR/iZtNfos5Pg74Tdj4OWAf9IGx8wvRP8KMC
3JIoPjxX8dkW06wr3tH2v3vaXHu8nzT/nzZmvpqsk2cZl7x9/6devuR8H+Vm
g/p1JK858k2j5sJ3wN82Kp4rjEed+pd9zJnBOiHN3thrPeNl9c5h+LXLc4nz
6QJ0nwdcSxTbduedwNzQtoLpBuN205yFBc+cZ6PuZZ3yf4fn0XNRfdhWlmy3
Z2BqezvD9jdpnt1pG1irNzwf2FPZRPX8EnT2wc8PUsUp2kf2epNjyx7tdT0M
ePaylhZKqqffi8oXZZqN+0xzrve43lo8a5iTIc+ZmzW57nxdg+DJrGJNP+lv
a1n6Nl3PlNlrWxlrxpxxY+5OZJW/EeeCuXkx6uxFzoNUNcSafT3qP3PY6rve
SXWWtTJo3SPW/0kU71XgtaJo8pg77jP68nFW+lmfFfcIYzgd5fPDiNliKnto
1xHvFO6WUc+PWe8sxpp1uSevmNBv2sL7aE+X/Vr0nON/xmTC9gy674/btq/K
su/2kngj9pH2cg+xr5aj6OVUe427krXXGTVP3gV/t/PO/HNuXPUM+ayoGnkT
+EiUPb9xxntWtrj3qYcx+TyrmJOmDt5HPax95pI1vekc9zt2jOFsSfIb3rn0
dcJviw3bU/FeyHlmjkfp/CVVTK74bXA0Kr7PR+X6gmuGs4Cx56zttw2MeUeU
3XeB/5rfAHwLjHnXnbMv67ah6tma9xxknXNGMgbUQ9+33JPsR/bWgPt5xXt/
CTJnvYMueUfM+D2w5l25ZD1T3lk8t2KZOctkvGNn/EY66HspzzifzMlP7sNT
3rMV9+t/ezaj9wdjt1SW/B9F7cD5zPYOXw7be3zF/BuW4a6kLXPe7xXrvMlf
tTzn04L3+JR3MH2njjXLMLac9RX7Mml55qJm+8fsS9nvgkn3WK1eZ3PWsWU9
xxpFP5bq/i3HZ8o0c8Qc1nyWNp9xbClz1m8D9g/76GXk/OdUtccapO7rvos7
hHOWPXDZ8uy/afvIfnmjUfL78P891w17kfXH+qlGxXjV8fwXEVZS5Q==
            "]], 
           PolygonBox[CompressedData["
1:eJwlkrsvg2EUxk/Upfq1/RJ/gLiFQQSD6yBIukgsJiIusdTESLWEoCwui5ow
sSpzXRIWm0EsRFwaEtEGsbnE7+QMJ3me9znnvOdWOjLeM5YjIjVYLjblipQV
iIQ9IhHwHlYJr8NpF7zsE7nErzFf5Cgg8uiINIG/8E+DB7BPfLeJeQqKFMLD
8GuvyAXxvfCfPJFvbJH4IXgR+f7gS/BNeBX5KrEk/NDP32jl5JskXyk5khQ6
yn/r+D5jLfg2Y8f4b+BflGdvql3h/+61P/QvzaG5tMcJ8Jnfelsh5zl4Hv9a
eDcxC+B6Yg7gO+gp/OP0vwUOocfQHxybRQOW4v9beNZjNUyi98F/wVly9IM7
/IYrsHbwnGuz0z/q0Fcdm732WIx2GrDeqtFPwCG/1ao1ZqjlVespsJnr7CPU
+JFjb4/gN5/F6g6j8Dt8Pjw20xny3+u+PDbzWfiaY7PVtxLXdqC7yBCfQJt2
rXfNEQV3kT+Raz3foMddm53ufBFc5Vqs3sy+z25Ab0Fr1Fp1Zjo7vSG9pXTQ
bqcNPQZ+8dmsWrFOeh92TNOd6m71hvSWdMY660HHbklvLI72D78CaUo=
            "]]}]}}, {{}, 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{2634, 3035, 3959, 3036, 3960, 2978, 3221, 3046, 3518, 
            3520, 3519, 2795, 3269, 2796, 3707, 3706, 4006, 4005, 3140, 3267, 
            3268, 3108, 3141, 2797, 4007, 3971, 3972, 3970, 3974, 3973, 3619, 
            3738, 2825, 4041, 3705, 3810, 2794, 2909, 3811, 3812, 3708, 2803, 
            2912, 4052, 2911, 3463, 2910, 3462, 2904, 3461, 2905, 2907, 4051, 
            2906, 3137, 3136, 3272, 2791, 3138, 2800}], 
           
           LineBox[{2694, 3964, 3965, 3963, 3038, 3966, 3037, 3250, 3704, 
            3703, 3962, 3961, 3607, 3606, 2958, 3870, 3122, 3873, 2960, 3871, 
            2959, 3872, 3039, 3967, 3040, 3968, 2967, 3504, 2966, 3879, 2735, 
            2696, 3517, 3041, 3516, 3042, 3044, 4067, 3043, 3969, 2864, 3771, 
            2865, 3772, 3114}]}, "8000"], Annotation[#, 8000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{3183, 3154, 3827, 2932, 3826, 2933, 3116, 2705, 3471, 
            3472, 3374, 2833, 3308, 3473, 3828, 3829, 3283, 3284, 3285, 3153, 
            3469, 2925, 3468, 2926, 3470, 3115, 3818, 3819, 3550, 3551, 2635, 
            3150, 3466, 3368, 3369, 3367, 3739, 2826, 4083, 3464, 2915, 3147, 
            2823, 3271, 2822, 3146, 3279}], 
           
           LineBox[{3208, 2730, 3594, 3593, 3592, 2949, 3165, 3164, 2689, 
            3601, 3428, 2853, 3427, 2852, 3864, 3865, 3862, 2952, 3863, 2731, 
            3600, 3599, 3598, 2953, 3866, 2856, 3868, 3869, 3867, 2957, 2734, 
            2693, 3432, 3433, 3323, 3324, 3325, 3610, 3440, 2863, 3328, 3329, 
            3330, 3613}]}, "6000"], Annotation[#, 6000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{2916, 3363, 2824, 3300, 3301, 3302, 3546, 3813, 2917, 
            3740, 2827, 3741, 2828, 3370, 2921, 3467, 3151, 3152, 2928, 3820, 
            2927, 2703, 2636, 3281, 2991, 4028, 2738, 3223, 3883, 3712, 3713, 
            3709, 3711, 3710, 3899, 2641, 4076, 3378, 4075, 3379, 3377, 2835, 
            3831, 3832, 3830, 2935, 3478, 3477, 3310, 3376, 3375, 3476, 2708, 
            3559, 3558, 3287, 2934, 3156, 3155, 3188}], 
           
           LineBox[{2971, 3439, 2862, 3770, 2861, 4086, 3503, 2964, 3877, 
            2965, 3878, 3322, 3321, 2860, 3431, 3604, 3605, 2733, 3121, 2956, 
            3602, 3603, 2692, 3167, 3211, 3212, 2995, 3641, 3642, 3643, 3234, 
            2741, 3639, 3640, 3588, 3589, 2685, 2729, 3496, 3419, 3420, 3315, 
            3497, 3857, 3858, 3590, 3591, 3422, 2849, 3421, 3424, 3423, 2686, 
            3163, 3495, 2946, 3494, 2947, 3119, 2725, 3204}]}, "4000"], 
         Annotation[#, 4000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{3191, 3157, 3158, 2937, 4019, 2647, 2710, 3836, 3746, 
            3747, 3627, 3837, 2711, 3838, 3748, 3749, 3628, 3839, 3840, 2938, 
            3841, 2939, 3842, 2838, 3384, 2839, 3385, 3510, 4079, 2648, 3900, 
            3717, 3718, 3716, 3720, 3719, 3745, 3714, 3715, 3560, 3561, 2642, 
            3775, 3144, 3897, 3898, 3896, 2992, 3233, 3232, 2739, 4029, 3071, 
            2929, 3821, 3823, 3822, 3307, 3306, 2832, 3373, 3549, 3305, 3304, 
            3303, 2829, 3371, 2627, 2700, 3615, 3614, 3733, 3732, 3814}], 
           
           LineBox[{3201, 2723, 3118, 2943, 3484, 3486, 3485, 3162, 2679, 
            3413, 3414, 3410, 3412, 3411, 2678, 3408, 3409, 3406, 2846, 3407, 
            3585, 3584, 2945, 3851, 3493, 3313, 2845, 3405, 3492, 3491, 2724, 
            2677, 3583, 3582, 3638, 3637, 2740, 3730, 3731, 3729, 2815, 2728, 
            2684, 3908, 3909, 3907, 2994, 3229, 3228, 2988, 4059, 2989, 3597, 
            3596, 3861, 3860, 2854, 3278, 2855, 3166, 2955, 3500, 4085, 2858, 
            3769, 2859, 3430, 2963, 3876, 3501, 3502, 3436, 3438, 3437, 
            3505}]}, "2000"], Annotation[#, 2000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwV0jlPF1EUh+FrhQhCwxegwgIwYiIUAo2AEDSRDhM3ZBEUNNpQ0SJbQ6EY
3BoVF/xjJzHKEm1kB4UElAANMZGwJaJgwTPFm/ec3z33TGYyqRU3yxoOhBBi
KDgUQldSCKf4Pt/DA6yiNDGEM7ieEMIvfR13mDuNWnkd7sg2nN3mTS5Odo4S
fNR/wsrhEJaxhD/uPpE9RRqOoFN2Flfsq8CaXc3ut+AubskWnE/L53lFtowZ
/RRq1JNcxZWoRpU7i3aXm1/z3N/YUZeZO4cf6nFeMjvBz5CuzohwLxNdZs5j
Qn2Zt+3Ywq66yPw/HjH/FYX6wejb8ACPyUZRrM/GZztO8I7smLqfH0fvjA/q
47IsHFX/l7Wr97iD5zCLYf03HuIZnsZ35Nj7hacwiQJ9tfd/ZO69fT36v+oW
Z21oxTX5oqzX3E+ul91Air4SV9GDh842vfMG1pEq63M3hhf2ZvJzzuV33Oi8
250MbtLHyeNxEOXRv+Ssz3Mu8VvuRSz6t/Rv+CK/4pd4jRp9vude4Fw+iTx0
Yx+NEW5D
            "]], 
           LineBox[CompressedData["
1:eJwV0rlPVFEUB+BrKy6VWmjDf2ACjRYKWAkFRrEhFAaMC8vsFCzaWJCwaE8j
W2JMiAmuOJaCcQcTUQYVBiigRhDRYPxu8eX3zj3nnfcyb0obk+cTe0IIedJ7
QzizP4QrslLuHAyhQlaRcjZ5IITL8ql8wjOS6seyST6UEzwioe7eF8INNktC
6LfrpxyQXc4GGTbTyF/7/3Bfv6C/wHP1JHnq1UPmdlz/ZpsNs512dLCsd91M
UWY8O80F/aJcZokG9VWzd82Uq3/ZscUm/5x9c7YrC3KeBV7G97O3iRp1NWd5
Y9dN972WL+So/git5vNyOL4vY7wz84G3LKkXee962my1nJIzzj7GZ6hP8soz
TsgRvTZa4m6aSdDGZ/2UTJNkLu43+929P0jFbxO/A+f0LlLLJ7Oz1Lm+5vc4
TKf71p2tcUT9Va/d9ReZlRlyrJh7oN9uZ44sh9THuafXRdbvkSNDmkW9YE+l
+6s4Ff9TnKZXb95MgZX4HSnSa37G2Wz8Puotxu2+xZyznvgfjL+B61W9XfO3
5QB3uBR3mDnm/Y4yqF/mbMJZH/8BeKx69g==
            "]]}, "0"], Annotation[#, 0, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[CompressedData["
1:eJwNzj1LgnEUhvEjvQw+pmu2BRUUQc219rYJ6dYW5BQ1RE36AcLRBh+Hpizn
KCSLwG8R1AcQg1Boa+k3XFz3uT3/87h4fH54lomICvayEZ9zEV9YwgqWMcxH
VJOIa/m3EJGXb3UFXtedclN/gx39LvpudXIRr5zqE7nFOX7GE0bevWCgf7PX
0qW40626sYamvoS675T50W5N/rCXcBbv+n27BxiZv1HR/fARj73pydv4k+fd
35KL3OY6p1zjezcWeIOn7KbeT/ODuYtNzJjb+lm+8D/G9hvyhK/Mlzjx+z+J
Ti5W
            "]], 
           LineBox[CompressedData["
1:eJwVzT0vQwEUBuBTtha1abEYjT5+AuqjLZEICV0kEiohETNWC126CeUXGFhM
JCJWH0v7Kyzo0OIxPHnvPefc9w6t7y7uJCJiia1kxHJXxAqfqYi6bLBpfiD3
5GR3xBQTTJNj33xWzjHDgG/zsk2LI+/JdMSg/NBzYVbjikvuzAv2RU56Iiqc
8qS3/7+PPrJkOOTM7RolVnnUUZWd+l/sO2RRR4E8C3bzvOu8t3ugl1e3afkm
n+3OPY+4G+XGbFyOcet5g2H/+XLzTZOM7ixlu21+zH651nXMH200Lg0=
            "]]}, 
          RowBox[{"-", "2000"}]], Annotation[#, -2000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{2652, 3185, 3186, 3055, 3528, 3054, 3978, 3182, 3480, 
            2709, 4081, 3479, 3311, 2837, 3383, 2936, 3833, 3835, 3834, 2836, 
            3380, 3382, 4077, 3381, 4078, 2645, 3523, 2640, 3112, 3104, 3239, 
            3238, 2749, 3542, 3543, 3127, 3126, 3274, 3011, 3086, 4070, 3085, 
            3451, 3349, 3350, 3348, 2805, 3779, 2869, 3778, 2868, 3049, 4068, 
            3048, 3507, 2975, 3506, 3881, 3880, 3219, 2744, 3331, 3080, 4034, 
            2767, 3261, 2766, 2996, 4031, 2743, 3235, 2742, 4030, 3072, 
            3109}], 
           LineBox[CompressedData["
1:eJwVzi1PwnEUxfGLNnly8AIUm82izoeXYLKATgpN2SBQbCJzo9INNoNsJtic
HRCc2QDM90AwkPgQvjv3nnPu7/8vVOqXtUREXKCxFfGQimjiPxkxpTPM0cK9
vJSOuEIROzrXdDMTsYF0NiKFXf5Cfyxb2F/dTcxt3pMsw9tGFiPZM/+Nf2Dv
0iV65qbs0V2L9te7+U83If/yvXM6omc0xx/o/Op2zUPeN93Dyfpf+J90Qk9p
Hrdu71DFh73jvogSbnhl/Oi/yN69d8g/xhH2eStcECqp
            "]]}, 
          RowBox[{"-", "4000"}]], Annotation[#, -4000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{2646, 3181, 3557, 3556, 3555, 3052, 3180, 3179, 3526, 
            3527, 3525, 3524, 3309, 2834, 3474, 3475, 3286, 3521, 3522, 3051, 
            3111, 3110, 3270, 3000, 3236, 3334, 3335, 3332, 3333, 3282, 3449, 
            4017, 2637, 3450, 2633, 2702, 3621, 3620, 2977, 3882, 2976, 3220, 
            3645, 3644, 2998, 3910, 3047, 2973, 4056, 2972, 3216, 2745, 4032, 
            2997, 2801}], 
           
           LineBox[{2681, 3203, 3063, 3982, 3064, 3206, 3205, 2687, 3595, 
            3426, 2850, 3425, 2851, 3533, 3534, 3531, 3065, 3532, 3209, 3859, 
            2950, 3498, 2951, 3499, 3665, 3666, 3359, 3360, 3356, 3358, 3357, 
            3458, 3999, 3935, 3936, 3934, 3013, 3937, 3006, 4061, 3076, 3667, 
            3923, 3007, 4088, 3687, 3688, 3244, 3015, 3276, 3107, 3132, 2763, 
            3991, 2764, 3675, 3674, 3926, 3925, 2821}]}, 
          RowBox[{"-", "6000"}]], Annotation[#, -6000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           
           LineBox[{2802, 3911, 2999, 3646, 3647, 3648, 3217, 3218, 2974, 
            3616, 3617, 3618, 2631, 3447, 3448, 3446, 3445, 3280, 2804, 3777, 
            2867, 3776, 2866, 3135, 2768, 3262, 2769, 4035, 3082, 3125, 3994, 
            3995, 3683, 3684, 2771, 3263, 2770, 3681, 3682, 3916, 3915, 3654, 
            3222, 4090, 2979, 3985, 3070, 3622, 4023, 2704, 3143}], 
           
           LineBox[{2820, 3789, 2881, 3671, 3672, 3673, 2913, 4053, 2914, 
            2880, 3787, 2879, 3788, 2883, 3790, 3459, 3460, 3362, 2818, 3361, 
            2819, 3786, 2878, 3785, 2877, 3068, 4069, 3067, 3255, 2774, 4036, 
            3089, 3128, 3997, 3998, 3685, 3686, 2773, 3254, 3983, 3921, 3922, 
            3663, 3664, 3241, 3003, 3005, 4060, 3004, 3145}]}, 
          RowBox[{"-", "8000"}]], Annotation[#, -8000, "Tooltip"]& ], 
        TagBox[
         TooltipBox[{
           Directive[
            GrayLevel[0], 
            Opacity[0.5], 
            CapForm["Butt"]], 
           LineBox[{2776, 4038, 2893, 2884, 2920, 4054, 2919}], 
           LineBox[{2777, 4039, 2894, 2892, 2969, 4055, 2968}], 
           
           LineBox[{2792, 3139, 3098, 4040, 2793, 3266, 3096, 4073, 3097, 
            2902, 4050, 2903, 2799, 3273, 2798, 3142, 3343, 2790, 4013, 4014, 
            4009, 3100, 4008, 3101, 4010, 3099, 3103, 4074, 3102, 4012, 4011, 
            3875, 2962, 3874, 2961, 3924, 3009, 3078, 3077, 3259, 3008, 3242, 
            3131, 3990, 3079, 3668, 3669, 3670, 3260, 3341, 3340}], 
           
           LineBox[{2882, 3032, 2789, 3248, 3249, 3034, 3958, 3033, 2788, 
            3247, 2787, 3702, 3342, 3345, 3344, 3347, 3346, 3251, 3045, 3277, 
            3133, 3134, 3081, 3680, 3679, 3678, 3010, 3929, 3124, 3986, 3073, 
            3649, 3650, 3651, 3257, 3337, 3336}]}, 
          RowBox[{"-", "10000"}]], 
         Annotation[#, -10000, "Tooltip"]& ], {}, {}}}], {}}, {
    DisplayFunction -> Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic}, AxesOrigin -> {0., 0.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, 
     FrameLabel -> {{None, None}, {None, None}}, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
     Identity, PlotInteractivity :> True, 
     DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, 
     AxesLabel -> {None, None}, DisplayFunction :> Identity, Frame ->